/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import com.creativetechguy.TimerTypes;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="tree-despawn-timer")
public interface TreeDespawnTimerConfig
extends Config {
    public static final String GROUP_NAME = "tree-despawn-timer";
    @ConfigSection(name="Advanced UI Customization", description="Detailed options for customizing timer overlay", position=3, closedByDefault=true)
    public static final String uiCustomizationSection = "uiCustomizationSection";
    public static final String UI_SIZE_NORMAL = "uiSizeNormal";
    public static final String UI_SIZE_POPULAR = "uiSizePopular";

    @ConfigItem(keyName="timerType", name="Timer Display Type", position=1, description="The UI style for displaying the estimated remaining time on each tree.")
    default public TimerTypes timerType() {
        return TimerTypes.PIE;
    }

    @ConfigItem(keyName="highlightPopularTrees", name="Popular Tree Indicator", position=2, description="Increases the size of the timer when there are 10+ players chopping the tree.")
    default public boolean highlightPopularTrees() {
        return true;
    }

    @ConfigItem(keyName="timerColorLow", name="Timer Color Low", position=0, description="Overlay color when the tree is about to despawn.", section="uiCustomizationSection")
    default public Color timerColorLow() {
        return new Color(220, 0, 0);
    }

    @ConfigItem(keyName="timerColorMedium", name="Timer Color Medium", position=1, description="Overlay color when the tree is nearly running out of time.", section="uiCustomizationSection")
    default public Color timerColorMedium() {
        return new Color(230, 160, 0);
    }

    @ConfigItem(keyName="timerColorHigh", name="Timer Color High", position=2, description="Overlay color when the tree is fairly new.", section="uiCustomizationSection")
    default public Color timerColorHigh() {
        return new Color(230, 230, 0);
    }

    @ConfigItem(keyName="timerColorFull", name="Timer Color Full", position=3, description="Overlay color when the tree is extremely new.", section="uiCustomizationSection")
    default public Color timerColorFull() {
        return new Color(0, 255, 0);
    }

    @ConfigItem(keyName="uiSizeNormal", name="UI Size Normal", position=4, description="Size of the timer.", section="uiCustomizationSection")
    default public int uiSizeNormal() {
        return 16;
    }

    @ConfigItem(keyName="uiSizePopular", name="UI Size Popular", position=5, description="Size of the timer for a highlighted popular tree.", section="uiCustomizationSection")
    default public int uiSizePopular() {
        return 25;
    }
}

