/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.runelite.api.GameObject;

public enum TreeConfig {
    OAK(27, new int[]{4540, 10820}),
    WILLOW(30, new int[]{10819, 10829, 10831, 10833}),
    TEAK(30, new int[]{9036, 36686, 40758}),
    MAPLE(60, new int[]{10832, 36681, 40754}),
    HOLLOW(36, new int[]{10821, 10830}),
    MAHOGANY(60, new int[]{9034, 36688, 40760}),
    ARCTIC_PINE(84, new int[]{3037}),
    YEW(114, new int[]{10822, 10823, 36683, 40756}),
    MAGIC(234, new int[]{10834, 10835}),
    REDWOOD(264, new int[]{29668, 29670, 34633, 34635, 34637, 34639});

    private static final ArrayList<Integer> blockedRegions;
    private final int maxTicks;
    private final int[] treeIds;
    private static final HashMap<Integer, TreeConfig> treeMap;

    private TreeConfig(int maxSeconds, int[] treeIds) {
        this.maxTicks = (int)Math.round((double)maxSeconds / 0.6);
        this.treeIds = treeIds;
    }

    static TreeConfig getTreeById(int gameObjectId) {
        return treeMap.get(gameObjectId);
    }

    static boolean isTree(GameObject gameObject) {
        if (blockedRegions.contains(gameObject.getWorldLocation().getRegionID())) {
            return false;
        }
        return treeMap.containsKey(gameObject.getId());
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    static {
        blockedRegions = new ArrayList<Integer>(List.of(Integer.valueOf(10044), Integer.valueOf(10300)));
        treeMap = new HashMap();
        for (TreeConfig treeConfig : TreeConfig.values()) {
            for (int treeId : treeConfig.treeIds) {
                treeMap.put(treeId, treeConfig);
            }
        }
    }
}

