/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.RenderableEntity;

public class CustomTextComponent
implements RenderableEntity {
    private final String text;
    private final Point position;
    private Color color = Color.BLACK;
    private boolean emphasize = false;
    private boolean centered = true;
    private static Font emphasizeFont = FontManager.getRunescapeBoldFont().deriveFont(16.0f);
    private static Font standardFont = FontManager.getRunescapeSmallFont().deriveFont(16.0f);

    static void updateFontSizes(int normal, int emphasized) {
        standardFont = FontManager.getRunescapeSmallFont().deriveFont((float)normal);
        emphasizeFont = FontManager.getRunescapeBoldFont().deriveFont((float)Math.round((float)emphasized * 0.65f));
    }

    public CustomTextComponent(String text, Point position) {
        this.text = text;
        this.position = position;
    }

    public Dimension render(Graphics2D graphics) {
        Font originalFont = graphics.getFont();
        graphics.setFont(this.emphasize ? emphasizeFont : standardFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(this.text);
        int textHeight = fontMetrics.getAscent();
        if (this.centered) {
            this.position.setLocation(this.position.getX() - (double)textWidth / 2.0, this.position.getY() + (double)textHeight / 2.0);
        }
        if (this.emphasize) {
            graphics.setColor(Color.BLACK);
            graphics.drawString(this.text, this.position.x, this.position.y + 1);
            graphics.drawString(this.text, this.position.x, this.position.y - 1);
            graphics.drawString(this.text, this.position.x + 1, this.position.y);
            graphics.drawString(this.text, this.position.x - 1, this.position.y);
        }
        graphics.setColor(this.color);
        graphics.drawString(this.text, this.position.x, this.position.y);
        if (originalFont != null) {
            graphics.setFont(originalFont);
        }
        return new Dimension(textWidth, textHeight);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setEmphasize(boolean emphasize) {
        this.emphasize = emphasize;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }
}

