/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSAnchorType;
import com.ericversteeg.frosthprun.view.RSTextView;
import com.ericversteeg.frosthprun.view.RSView;
import com.ericversteeg.frosthprun.view.RSViewGroup;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;

public class RSViewOverlay
extends Overlay {
    private Map<String, ViewInfo> viewInfo = new HashMap<String, ViewInfo>();
    private Set<String> pendingRemoves = new HashSet<String>();

    public Dimension render(Graphics2D graphics) {
        this.removePending();
        long start = Instant.now().toEpochMilli();
        int numInfo = 0;
        for (String name : this.viewInfo.keySet()) {
            ViewInfo info = this.viewInfo.get(name);
            Client client = info.getClient();
            RSViewGroup view = info.getView();
            RSAnchorType anchorType = info.getAnchorType();
            int anchorX = info.getAnchorX();
            int anchorY = info.getAnchorY();
            this.applyFonts(view, graphics);
            view.layout();
            if (anchorType != null) {
                Widget viewportWidget = this.getViewportWidget(client);
                view.setX(anchorX);
                view.setY(anchorY);
                if (anchorType == RSAnchorType.TOP_RIGHT || anchorType == RSAnchorType.BOTTOM_RIGHT) {
                    view.setX(viewportWidget.getCanvasLocation().getX() + viewportWidget.getWidth() + 28 - anchorX - view.getW());
                }
                if (anchorType == RSAnchorType.BOTTOM_LEFT || anchorType == RSAnchorType.BOTTOM_RIGHT) {
                    view.setY(viewportWidget.getCanvasLocation().getY() + viewportWidget.getHeight() + 41 - anchorY - view.getH());
                }
                if (anchorType == RSAnchorType.TOP_CENTER) {
                    view.setX((viewportWidget.getCanvasLocation().getX() + viewportWidget.getWidth() + 28 - view.getW()) / 2 + anchorX);
                }
                if (anchorType == RSAnchorType.BOTTOM_CENTER) {
                    view.setX((viewportWidget.getCanvasLocation().getX() + viewportWidget.getWidth() + 28 - view.getW()) / 2 + anchorX);
                    view.setY(viewportWidget.getCanvasLocation().getY() + viewportWidget.getHeight() + 41 - anchorY - view.getH());
                }
            }
            view.render(graphics, new Point(0, 0));
            ++numInfo;
        }
        return new Dimension(0, 0);
    }

    public Map<String, ViewInfo> getViewInfo() {
        return this.viewInfo;
    }

    public void addViewInfo(String name, ViewInfo viewInfo) {
        this.viewInfo.put(name, viewInfo);
    }

    public void removeViewInfo(String name, boolean immediate) {
        if (immediate) {
            this.viewInfo.remove(name);
        } else {
            this.pendingRemoves.add(name);
        }
    }

    private void removePending() {
        for (String name : this.pendingRemoves) {
            this.viewInfo.remove(name);
        }
        this.pendingRemoves.clear();
    }

    public boolean containsViewInfo(String name) {
        return this.viewInfo.containsKey(name) && !this.pendingRemoves.contains(name);
    }

    public void clearViewInfo() {
        this.viewInfo.clear();
    }

    private void applyFonts(RSView view, Graphics2D graphics) {
        if (view instanceof RSViewGroup) {
            for (RSView sView : ((RSViewGroup)view).subviews) {
                this.applyFonts(sView, graphics);
            }
        }
        if (view instanceof RSTextView) {
            ((RSTextView)view).setFontMetrics(graphics);
        }
    }

    private Widget getViewportWidget(Client client) {
        Widget widget = client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        widget = client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        widget = client.getWidget(WidgetInfo.FIXED_VIEWPORT_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        return client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER);
    }

    public static class ViewInfo {
        private Client client;
        private RSViewGroup view;
        private RSAnchorType anchorType;
        private int anchorX;
        private int anchorY;

        public ViewInfo(Client client, RSViewGroup view, RSAnchorType anchorType, int anchorX, int anchorY) {
            this.client = client;
            this.view = view;
            this.anchorType = anchorType;
            this.anchorX = anchorX;
            this.anchorY = anchorY;
        }

        public Client getClient() {
            return this.client;
        }

        public RSViewGroup getView() {
            return this.view;
        }

        public RSAnchorType getAnchorType() {
            return this.anchorType;
        }

        public int getAnchorX() {
            return this.anchorX;
        }

        public int getAnchorY() {
            return this.anchorY;
        }
    }
}

