/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSLayoutGuide;
import com.ericversteeg.frosthprun.view.RSView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class RSViewGroup
extends RSView {
    protected Gravity gravity = Gravity.TOP_START;
    protected List<RSView> subviews = new ArrayList<RSView>();
    private boolean renderReverse = false;

    public RSViewGroup(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    public void addView(RSView view) {
        this.subviews.add(view);
        view.setParent(this);
    }

    public void setRenderReverse(boolean renderReverse) {
        this.renderReverse = renderReverse;
    }

    @Override
    public void render(Graphics2D graphics, Point origin) {
        super.render(graphics, origin);
        LinkedList<RSView> subviewsCopy = new LinkedList<RSView>(this.subviews);
        if (this.renderReverse) {
            Collections.reverse(subviewsCopy);
        }
        for (RSView view : subviewsCopy) {
            view.setOpacity(this.getOpacity());
            view.render(graphics, new Point(origin.x + this.x, origin.y + this.y));
        }
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    public int getPaddingStart() {
        return this.paddingStart;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingEnd() {
        return this.paddingEnd;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPadding(int padding) {
        this.paddingStart = padding;
        this.paddingTop = padding;
        this.paddingEnd = padding;
        this.paddingBottom = padding;
    }

    public Dimension layout() {
        return this.applyDimension(new RSLayoutGuide.Builder().maxWidth(this.w).build());
    }

    protected abstract Map<RSLayoutGuide, Integer> layoutSubviews(Map<RSLayoutGuide, Integer> var1);

    @Override
    protected Dimension applyDimension(Map<RSLayoutGuide, Integer> guides) {
        Integer bottomGuide;
        Object weight;
        float totalWeight;
        Integer endGuide;
        for (RSView view : this.subviews) {
            view.applyDimension(this.subviewMaxDimensionGuides(guides, view));
        }
        Map<RSLayoutGuide, Integer> layoutGuides = this.layoutSubviewsAndResize(guides);
        boolean appliedWeight = false;
        if (this.dimensionParams.getW() != WRAP_CONTENT && (endGuide = layoutGuides.get((Object)RSLayoutGuide.END)) != null) {
            totalWeight = 0.0f;
            int totalAddedWidth = 0;
            int weightWidth = this.measureWidth(guides) - endGuide;
            for (RSView view : this.subviews) {
                if (view.getWeight() == null) continue;
                totalWeight += view.getWeight().floatValue();
            }
            if (totalWeight > 0.0f) {
                for (RSView view : this.subviews) {
                    view.setX(view.getX() + totalAddedWidth);
                    weight = view.getWeight();
                    if (weight == null) continue;
                    int width = (int)(((Float)weight).floatValue() / totalWeight * (float)weightWidth);
                    view.setW(width);
                    view.dimensionParams.setW(width);
                    view.applyDimension(this.subviewMaxDimensionGuides(guides, view));
                    view.getWeightParams().setWeight(null);
                    appliedWeight = true;
                    totalAddedWidth += width;
                }
                int truncatedWidth = weightWidth - totalAddedWidth;
                boolean foundView = false;
                for (RSView view : this.subviews) {
                    if (this.getWeight() != null && !foundView) {
                        view.setW(view.getW() + truncatedWidth);
                        view.dimensionParams.setW(view.getW());
                        view.applyDimension(this.subviewMaxDimensionGuides(guides, view));
                        foundView = true;
                    }
                    if (!foundView) continue;
                    view.setX(view.getX() + truncatedWidth);
                }
            }
        }
        if (this.dimensionParams.getH() != WRAP_CONTENT && (bottomGuide = layoutGuides.get((Object)RSLayoutGuide.BOTTOM)) != null) {
            totalWeight = 0.0f;
            int totalAddedHeight = 0;
            int weightHeight = this.measureHeight(guides) - bottomGuide;
            for (RSView view : this.subviews) {
                if (view.getWeight() == null) continue;
                totalWeight += view.getWeight().floatValue();
            }
            if (totalWeight > 0.0f) {
                for (RSView view : this.subviews) {
                    view.setY(view.getY() + totalAddedHeight);
                    weight = view.getWeight();
                    if (weight == null) continue;
                    int height = (int)(((Float)weight).floatValue() / totalWeight * (float)weightHeight);
                    view.setH(height);
                    view.dimensionParams.setH(view.getH());
                    view.applyDimension(this.subviewMaxDimensionGuides(guides, view));
                    view.getWeightParams().setWeight(null);
                    appliedWeight = true;
                    totalAddedHeight += height;
                }
                int truncatedHeight = weightHeight - totalAddedHeight;
                boolean foundView = false;
                for (RSView view : this.subviews) {
                    if (this.getWeight() != null && !foundView) {
                        view.setH(view.getH() + truncatedHeight);
                        view.dimensionParams.setH(view.getH());
                        view.applyDimension(this.subviewMaxDimensionGuides(guides, view));
                        foundView = true;
                    }
                    if (!foundView) continue;
                    view.setY(view.getY() + truncatedHeight);
                }
            }
        }
        if (appliedWeight) {
            this.layoutSubviewsAndResize(guides);
        }
        return new Dimension(this.w, this.h);
    }

    private Map<RSLayoutGuide, Integer> layoutSubviewsAndResize(Map<RSLayoutGuide, Integer> guides) {
        Map<RSLayoutGuide, Integer> layoutGuides = this.layoutSubviews(guides);
        this.w = this.dimensionParams.getW() == WRAP_CONTENT && layoutGuides.containsKey((Object)RSLayoutGuide.END) ? layoutGuides.get((Object)RSLayoutGuide.END).intValue() : this.measureWidth(guides);
        this.h = this.dimensionParams.getH() == WRAP_CONTENT && layoutGuides.containsKey((Object)RSLayoutGuide.BOTTOM) ? layoutGuides.get((Object)RSLayoutGuide.BOTTOM).intValue() : this.measureHeight(guides);
        return layoutGuides;
    }

    @Override
    public int measureWidth(Map<RSLayoutGuide, Integer> guides) {
        if (this.dimensionParams.getW() == MATCH_PARENT) {
            return guides.get((Object)RSLayoutGuide.MAX_WIDTH);
        }
        if (this.dimensionParams.getW() == WRAP_CONTENT) {
            return this.getMaxSubviewWidth();
        }
        return this.dimensionParams.getW();
    }

    protected int getMaxSubviewWidth() {
        int max = 0;
        for (RSView view : this.subviews) {
            int sw = view.getW() + view.getMarginStart() + view.getMarginEnd() + this.paddingStart + this.paddingEnd;
            if (sw <= max) continue;
            max = sw;
        }
        return max;
    }

    @Override
    public int measureHeight(Map<RSLayoutGuide, Integer> guides) {
        if (this.dimensionParams.getH() == MATCH_PARENT) {
            return guides.get((Object)RSLayoutGuide.MAX_HEIGHT);
        }
        if (this.dimensionParams.getH() == WRAP_CONTENT) {
            return this.getMaxSubviewHeight();
        }
        return this.dimensionParams.getH();
    }

    protected int getMaxSubviewHeight() {
        int max = 0;
        for (RSView view : this.subviews) {
            int sw = view.getH() + view.getMarginTop() + view.getMarginBottom() + this.paddingTop + this.paddingBottom;
            if (sw <= max) continue;
            max = sw;
        }
        return max;
    }

    protected Map<RSLayoutGuide, Integer> subviewMaxDimensionGuides(Map<RSLayoutGuide, Integer> guides, RSView view) {
        HashMap<RSLayoutGuide, Integer> subviewGuides = new HashMap<RSLayoutGuide, Integer>();
        if (this.dimensionParams.getW() != WRAP_CONTENT) {
            int wGuide = this.dimensionParams.getW();
            if (this.dimensionParams.getW() == MATCH_PARENT && guides.containsKey((Object)RSLayoutGuide.MAX_WIDTH)) {
                wGuide = guides.get((Object)RSLayoutGuide.MAX_WIDTH);
            }
            subviewGuides.put(RSLayoutGuide.MAX_WIDTH, wGuide - view.getMarginStart() - view.getMarginEnd() - this.getPaddingStart() - this.getPaddingEnd());
        }
        if (this.dimensionParams.getH() != WRAP_CONTENT) {
            int hGuide = this.dimensionParams.getH();
            if (this.dimensionParams.getH() == MATCH_PARENT && guides.containsKey((Object)RSLayoutGuide.MAX_HEIGHT)) {
                hGuide = guides.get((Object)RSLayoutGuide.MAX_HEIGHT);
            }
            subviewGuides.put(RSLayoutGuide.MAX_HEIGHT, hGuide - view.getMarginTop() - view.getMarginBottom() - this.getPaddingTop() - this.getPaddingBottom());
        }
        return subviewGuides;
    }

    public static enum Gravity {
        START,
        TOP_START,
        TOP,
        TOP_END,
        END,
        BOTTOM_END,
        BOTTOM,
        BOTTOM_START,
        CENTER;

    }
}

