/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSRenderable;
import com.ericversteeg.frosthprun.view.RSView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class RSViewBorder
implements RSRenderable {
    private RSView view;
    private Color innerColor;
    private Color outerColor;
    private float opacity = 1.0f;

    public RSViewBorder(RSView view, Color color) {
        this.view = view;
        this.innerColor = color;
    }

    public RSViewBorder(RSView view, Color innerColor, Color outerColor) {
        this.view = view;
        this.innerColor = innerColor;
        this.outerColor = outerColor;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @Override
    public void render(Graphics2D graphics, Point origin) {
        if (this.outerColor != null) {
            graphics.setColor(this.colorWithOpacity(this.outerColor));
            graphics.drawRect(origin.x + this.view.getX(), origin.y + this.view.getY(), this.view.getW(), this.view.getH());
            graphics.setColor(this.colorWithOpacity(this.outerColor));
            graphics.drawRect(origin.x + this.view.getX() - 1, origin.y + this.view.getY() - 1, this.view.getW() + 2, this.view.getH() + 2);
        }
        if (this.innerColor != null) {
            graphics.setColor(this.colorWithOpacity(this.innerColor));
            graphics.drawRect(origin.x + this.view.getX() + 1, origin.y + this.view.getY() + 1, this.view.getW() - 2, this.view.getH() - 2);
        }
    }

    protected Color colorWithOpacity(Color color) {
        return new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.opacity * (float)color.getAlpha() / 255.0f);
    }
}

