/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSAnimation;
import com.ericversteeg.frosthprun.view.RSLayoutGuide;
import com.ericversteeg.frosthprun.view.RSRenderable;
import com.ericversteeg.frosthprun.view.RSViewBorder;
import com.ericversteeg.frosthprun.view.RSViewGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;

public class RSView
implements RSRenderable {
    protected DimensionParams dimensionParams;
    public static int MATCH_PARENT = -1;
    public static int WRAP_CONTENT = -2;
    protected RSViewGroup.Gravity layoutGravity = null;
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    private Float weight = null;
    private WeightParams weightParams = null;
    protected int marginStart = 0;
    protected int marginTop = 0;
    protected int marginEnd = 0;
    protected int marginBottom = 0;
    protected int paddingStart = 0;
    protected int paddingTop = 0;
    protected int paddingEnd = 0;
    protected int paddingBottom = 0;
    protected Color bgColor = new Color(0, 0, 0, 0);
    protected RSViewBorder border;
    protected float opacity = 1.0f;
    protected Map<RSAnimation.Type, RSAnimation> animations = new HashMap<RSAnimation.Type, RSAnimation>();
    protected RSViewGroup parent = null;

    public RSView(int x, int y, int w, int h) {
        this.dimensionParams = new DimensionParams(w, h);
        this.x = x;
        this.y = y;
    }

    public void addBorder(Color color) {
        this.border = new RSViewBorder(this, color);
    }

    public void addBorder(Color innerColor, Color outerColor) {
        this.border = new RSViewBorder(this, innerColor, outerColor);
    }

    public void setLayoutGravity(RSViewGroup.Gravity layoutGravity) {
        this.layoutGravity = layoutGravity;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        this.weight = weight;
        this.weightParams = new WeightParams(weight);
    }

    public WeightParams getWeightParams() {
        return this.weightParams;
    }

    public int getMarginStart() {
        return this.marginStart;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginEnd() {
        return this.marginEnd;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setParent(RSViewGroup parent) {
        this.parent = parent;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setMarginStart(int marginStart) {
        this.marginStart = marginStart;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginEnd(int marginEnd) {
        this.marginEnd = marginEnd;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void addAnimation(RSAnimation.Type type, RSAnimation animation) {
        this.animations.put(type, animation);
    }

    public void removeAnimation(RSAnimation.Type type) {
        this.animations.remove((Object)type);
    }

    public RSView getParent() {
        return this.parent;
    }

    protected Dimension applyDimension(Map<RSLayoutGuide, Integer> guides) {
        this.w = this.measureWidth(guides);
        this.h = this.measureHeight(guides);
        if (guides.containsKey((Object)RSLayoutGuide.MAX_WIDTH)) {
            int wGuide = guides.get((Object)RSLayoutGuide.MAX_WIDTH);
            if (this.dimensionParams.getW() == MATCH_PARENT) {
                this.w = wGuide;
            }
        }
        if (guides.containsKey((Object)RSLayoutGuide.MAX_HEIGHT)) {
            int hGuide = guides.get((Object)RSLayoutGuide.MAX_HEIGHT);
            if (this.dimensionParams.getH() == MATCH_PARENT) {
                this.h = hGuide;
            }
        }
        return new Dimension(this.w, this.h);
    }

    public int measureWidth(Map<RSLayoutGuide, Integer> guides) {
        return this.dimensionParams.getW();
    }

    public int measureHeight(Map<RSLayoutGuide, Integer> guides) {
        return this.dimensionParams.getH();
    }

    protected void applyPosition(Map<RSLayoutGuide, Integer> guides) {
        switch (this.getLayoutGravity()) {
            case START: 
            case TOP_START: 
            case BOTTOM_START: {
                this.x = this.guideOrThrow(RSLayoutGuide.START, guides);
                break;
            }
            case CENTER: 
            case TOP: 
            case BOTTOM: {
                int wGuide = this.guideOrThrow(RSLayoutGuide.MAX_WIDTH, guides);
                this.x = (wGuide - this.w) / 2;
                break;
            }
            case END: 
            case TOP_END: 
            case BOTTOM_END: {
                this.x = this.guideOrThrow(RSLayoutGuide.END, guides) - this.w;
            }
        }
        switch (this.getLayoutGravity()) {
            case TOP_START: 
            case TOP: 
            case TOP_END: {
                this.y = this.guideOrThrow(RSLayoutGuide.TOP, guides);
                break;
            }
            case START: 
            case CENTER: 
            case END: {
                int hGuide = this.guideOrThrow(RSLayoutGuide.MAX_HEIGHT, guides);
                this.y = (hGuide - this.h) / 2;
                break;
            }
            case BOTTOM_START: 
            case BOTTOM: 
            case BOTTOM_END: {
                this.y = this.guideOrThrow(RSLayoutGuide.BOTTOM, guides) - this.h;
            }
        }
    }

    public int guideOrThrow(RSLayoutGuide guide, Map<RSLayoutGuide, Integer> guides) {
        Integer val = guides.get((Object)guide);
        if (val == null) {
            throw new IllegalStateException("Must include a " + guide.toString() + " guide.");
        }
        return val;
    }

    public RSViewGroup.Gravity getLayoutGravity() {
        if (this.layoutGravity == null) {
            return this.parent.getGravity();
        }
        return this.layoutGravity;
    }

    @Override
    public void render(Graphics2D graphics, Point origin) {
        RSAnimation fadeIn = this.animations.get((Object)RSAnimation.Type.FADE_IN);
        RSAnimation fadeOut = this.animations.get((Object)RSAnimation.Type.FADE_OUT);
        if (fadeIn != null) {
            this.setOpacity(fadeIn.getValue());
        } else if (fadeOut != null) {
            this.setOpacity(fadeOut.getValue());
        }
        graphics.setColor(this.colorWithOpacity(this.bgColor));
        graphics.fillRect(origin.x + this.x, origin.y + this.y, this.w, this.h);
        if (this.border != null) {
            this.border.render(graphics, origin);
        }
    }

    protected Color colorWithOpacity(Color color) {
        return new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.opacity * (float)color.getAlpha() / 255.0f);
    }

    public RSAnimation animate() {
        return new RSAnimation(this);
    }

    class WeightParams {
        private Float weight;

        public WeightParams(Float weight) {
            this.weight = weight;
        }

        public Float getWeight() {
            return this.weight;
        }

        public void setWeight(Float weight) {
            this.weight = weight;
        }
    }

    class DimensionParams {
        private int w;
        private int h;

        public DimensionParams(int w, int h) {
            this.w = w;
            this.h = h;
        }

        public int getW() {
            return this.w;
        }

        public void setW(int w) {
            this.w = w;
        }

        public int getH() {
            return this.h;
        }

        public void setH(int h) {
            this.h = h;
        }
    }
}

