/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSLayoutGuide;
import com.ericversteeg.frosthprun.view.RSView;
import com.ericversteeg.frosthprun.view.RSViewGroup;
import com.ericversteeg.frosthprun.view.TextComponentWOpacity;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class RSTextView
extends RSView {
    private TextComponentWOpacity textComponent = new TextComponentWOpacity();
    private FontMetrics fontMetrics;
    private Font font;
    private String text = "";
    private Color textColor = Color.WHITE;
    private int numLines = 1;
    private int lineHeight = 0;
    private boolean hasImage = false;
    private BufferedImage image;
    private Color imageBgColor = new Color(0, 0, 0, 0);
    private int imageX = 0;
    private int imageY = 0;
    private int imageW = 0;
    private int imageH = 0;
    private int imageOffset = 0;
    private boolean imageOffsetNegative = false;
    private RSViewGroup.Gravity imageGravity;
    private boolean animatesColor = false;
    private long animationCycleMillis = 2000L;
    private int lineWidth = 0;

    public RSTextView(int x, int y, int w, int h, Font font) {
        super(x, y, w, h);
        this.font = font;
    }

    public void setFontMetrics(Graphics2D graphics) {
        if (this.font == null) {
            return;
        }
        graphics.setFont(this.font);
        this.fontMetrics = graphics.getFontMetrics();
    }

    public void setText(String text) {
        this.text = text;
        this.textComponent.setText(text);
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setImage(BufferedImage image, int width, int height, RSViewGroup.Gravity gravity) {
        this.image = image;
        this.imageW = width;
        this.imageH = height;
        this.imageGravity = gravity;
        this.hasImage = true;
    }

    public void setImageBgColor(Color imageBgColor) {
        this.imageBgColor = imageBgColor;
    }

    public void setImageOffset(int imageOffset, boolean negative) {
        this.imageOffset = imageOffset;
        this.imageOffsetNegative = negative;
    }

    private int imageX(int imageW, RSViewGroup.Gravity gravity) {
        switch (gravity) {
            case TOP_START: 
            case START: 
            case BOTTOM_START: {
                return 0;
            }
            case TOP: 
            case CENTER: 
            case BOTTOM: {
                return (this.w - this.paddingStart - this.paddingEnd - imageW) / 2;
            }
            case TOP_END: 
            case END: 
            case BOTTOM_END: {
                return this.w - this.paddingStart - this.paddingEnd - imageW;
            }
        }
        return 0;
    }

    private int imageY(int imageH, RSViewGroup.Gravity gravity) {
        switch (gravity) {
            case TOP_START: 
            case TOP: 
            case TOP_END: {
                return 0;
            }
            case START: 
            case CENTER: 
            case END: {
                return (this.h - this.paddingTop - this.paddingBottom - imageH) / 2;
            }
            case BOTTOM_START: 
            case BOTTOM: 
            case BOTTOM_END: {
                return this.h - this.paddingTop - this.paddingBottom - imageH;
            }
        }
        return 0;
    }

    public void setAnimatesColor(boolean animatesColor) {
        this.animatesColor = animatesColor;
    }

    public void setAnimationCycleDuration(int duration) {
        this.animationCycleMillis = (long)duration * 1000L;
    }

    @Override
    public int measureWidth(Map<RSLayoutGuide, Integer> guides) {
        int strWidth = this.fontMetrics.stringWidth(this.text);
        Integer guide = guides.get((Object)RSLayoutGuide.MAX_WIDTH);
        if (this.dimensionParams.getW() != WRAP_CONTENT) {
            if (guide != null && this.dimensionParams.getW() == MATCH_PARENT) {
                this.lineWidth = guide - this.paddingStart - this.paddingEnd;
                return this.lineWidth;
            }
            this.lineWidth = this.dimensionParams.getW() - this.paddingStart - this.paddingEnd;
        } else {
            String str = Pattern.compile("\\^\\w").matcher(this.text).replaceAll("");
            this.lineWidth = this.fontMetrics.stringWidth(str);
        }
        return this.paddingStart + this.lineWidth + this.paddingEnd;
    }

    @Override
    public int measureHeight(Map<RSLayoutGuide, Integer> guides) {
        this.lineHeight = this.fontMetrics.getHeight();
        if (this.dimensionParams.getW() == WRAP_CONTENT) {
            return this.lineHeight;
        }
        this.numLines = this.hasImage ? this.getNumLinesImage(this.lineWidth) : this.getNumLines(this.lineWidth);
        int height = this.lineHeight * this.numLines;
        return this.paddingTop + height + this.paddingBottom;
    }

    @Override
    public void render(Graphics2D graphics, Point origin) {
        super.render(graphics, origin);
        graphics.setFont(this.font);
        if (this.hasImage) {
            this.charRenderLinesImage(graphics, this.lineWidth, new Point(origin.x + this.x + this.paddingStart, origin.y + this.y + this.paddingTop));
            graphics.setColor(this.imageBgColor);
            graphics.fillRect(origin.x + this.x + this.paddingStart + this.imageX, origin.y + this.y + this.paddingTop + this.imageY, this.imageW, this.imageH);
            int offset = this.imageOffset;
            if (this.imageOffsetNegative) {
                offset *= -1;
            }
            graphics.drawImage((Image)this.image, origin.x + this.x + this.paddingStart + this.imageX, origin.y + this.y + this.paddingTop + this.imageY + offset, null);
        } else {
            this.charRenderLines(graphics, this.lineWidth, new Point(origin.x + this.x + this.paddingStart, origin.y + this.y + this.paddingTop));
        }
    }

    private void charRenderLines(Graphics2D graphics, int maxWidth, Point start) {
        char[] chars = this.text.replace("\\s+", " ").toCharArray();
        int rx = 0;
        int ry = this.lineHeight;
        int cIndex = 0;
        int rIndex = 0;
        int spaceWidth = this.fontMetrics.stringWidth(" ");
        StringBuilder sb = new StringBuilder();
        boolean readColor = false;
        HashMap<Integer, Color> colorPositions = new HashMap<Integer, Color>();
        this.setColor(this.textColor);
        for (int i = 0; i < chars.length; ++i) {
            String word;
            int sw;
            boolean lastChar;
            char c = chars[i];
            boolean bl = lastChar = i == chars.length - 1;
            if (readColor) {
                colorPositions.put(cIndex, this.getColor(c));
                readColor = false;
                continue;
            }
            if (c != ' ' && !lastChar) {
                if (c == '^') {
                    readColor = true;
                    continue;
                }
                sb.append(c);
                ++cIndex;
                continue;
            }
            if (c != ' ') {
                sb.append(c);
                ++cIndex;
            }
            if (rx + (sw = this.fontMetrics.stringWidth(word = sb.toString())) > maxWidth) {
                rx = 0;
                ry += this.lineHeight;
            }
            for (char sc : word.toCharArray()) {
                Color color = (Color)colorPositions.get(rIndex);
                if (color != null) {
                    this.setColor(color);
                }
                this.textComponent.setPosition(new Point(start.x + rx, start.y + ry));
                this.textComponent.setText(String.valueOf(sc));
                this.textComponent.render(graphics);
                rx += this.fontMetrics.stringWidth(String.valueOf(sc));
                ++rIndex;
            }
            rx += spaceWidth;
            Color color = (Color)colorPositions.get(rIndex);
            if (color != null) {
                this.setColor(color);
            }
            ++cIndex;
            ++rIndex;
            sb = new StringBuilder();
        }
    }

    private void charRenderLinesImage(Graphics2D graphics, int maxWidth, Point start) {
        char[] chars = this.text.replace("\\s+", " ").toCharArray();
        int rx = 0;
        int ry = this.lineHeight;
        int cIndex = 0;
        int rIndex = 0;
        int spaceWidth = this.fontMetrics.stringWidth(" ");
        StringBuilder sb = new StringBuilder();
        boolean readColor = false;
        HashMap<Integer, Color> colorPositions = new HashMap<Integer, Color>();
        RSViewGroup.Gravity horizontalGravity = this.getHorizontalGravity(this.imageGravity);
        int imageStart = (maxWidth - this.imageW) / 2;
        this.imageX = this.imageX(this.imageW, this.imageGravity);
        this.imageY = this.imageY(this.imageH, this.imageGravity);
        this.setColor(this.textColor);
        for (int i = 0; i < chars.length; ++i) {
            boolean lastChar;
            char c = chars[i];
            boolean bl = lastChar = i == chars.length - 1;
            if (readColor) {
                colorPositions.put(cIndex, this.getColor(c));
                readColor = false;
                continue;
            }
            if (c != ' ' && !lastChar) {
                if (c == '^') {
                    readColor = true;
                    continue;
                }
                sb.append(c);
                ++cIndex;
                continue;
            }
            if (c != ' ') {
                sb.append(c);
                ++cIndex;
            }
            String word = sb.toString();
            int sw = this.fontMetrics.stringWidth(word);
            boolean isHeightRange = this.isImageHeightRange(ry - this.lineHeight);
            if (isHeightRange) {
                if (horizontalGravity == RSViewGroup.Gravity.START) {
                    if (rx < this.imageW) {
                        rx = this.imageW + 3;
                    }
                } else if (horizontalGravity == RSViewGroup.Gravity.CENTER) {
                    if (rx + sw > imageStart - 3) {
                        rx = this.imageX + this.imageW + 3;
                    }
                } else if (horizontalGravity == RSViewGroup.Gravity.END && rx + sw > maxWidth - this.imageW - 3) {
                    rx = 0;
                    ry += this.lineHeight;
                }
            }
            if (rx + sw > maxWidth) {
                isHeightRange = this.isImageHeightRange((ry += this.lineHeight) - this.lineHeight);
                rx = 0;
                if (isHeightRange && horizontalGravity == RSViewGroup.Gravity.START) {
                    rx = this.imageW + 3;
                }
            }
            for (char sc : word.toCharArray()) {
                Color color = (Color)colorPositions.get(rIndex);
                if (color != null) {
                    this.setColor(color);
                }
                this.textComponent.setPosition(new Point(start.x + rx, start.y + ry));
                this.textComponent.setText(String.valueOf(sc));
                this.textComponent.render(graphics);
                rx += this.fontMetrics.stringWidth(String.valueOf(sc));
                ++rIndex;
            }
            rx += spaceWidth;
            Color color = (Color)colorPositions.get(rIndex);
            if (color != null) {
                this.setColor(color);
            }
            ++cIndex;
            ++rIndex;
            sb = new StringBuilder();
        }
    }

    private void setColor(Color color) {
        if (color.getAlpha() < 5) {
            float percent = (float)(Instant.now().toEpochMilli() % this.animationCycleMillis) / (float)this.animationCycleMillis;
            Color[] colors = color.getAlpha() == 0 ? this.getTriadicColors(color) : new Color[]{Color.WHITE, Color.BLACK};
            Color animatedColor = this.getInterpolatedColor(this.getColorPair(colors, percent), colors.length, percent);
            this.textComponent.setColor(this.colorWithOpacity(animatedColor));
        } else {
            this.textComponent.setColor(this.colorWithOpacity(color));
        }
    }

    private boolean isImageHeightRange(int y) {
        switch (this.imageGravity) {
            case TOP_START: 
            case TOP: 
            case TOP_END: {
                return y < this.imageH;
            }
            case START: 
            case CENTER: 
            case END: {
                int imageTop = (this.h - this.paddingTop - this.paddingBottom - this.imageH) / 2;
                return y >= imageTop && y < imageTop + this.imageH;
            }
            case BOTTOM_START: 
            case BOTTOM: 
            case BOTTOM_END: {
                return y >= this.h - this.paddingTop - this.paddingBottom - this.imageH;
            }
        }
        return false;
    }

    private RSViewGroup.Gravity getHorizontalGravity(RSViewGroup.Gravity gravity) {
        switch (gravity) {
            case TOP_START: 
            case START: 
            case BOTTOM_START: {
                return RSViewGroup.Gravity.START;
            }
            case TOP: 
            case CENTER: 
            case BOTTOM: {
                return RSViewGroup.Gravity.CENTER;
            }
            case TOP_END: 
            case END: 
            case BOTTOM_END: {
                return RSViewGroup.Gravity.END;
            }
        }
        return RSViewGroup.Gravity.START;
    }

    private int getNumLines(int maxWidth) {
        String str = Pattern.compile("\\^\\w").matcher(this.text).replaceAll("");
        char[] chars = str.replace("\\s+", " ").toCharArray();
        int rx = 0;
        int lines = 1;
        int spaceWidth = this.fontMetrics.stringWidth(" ");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            String word;
            int sw;
            boolean lastChar;
            char c = chars[i];
            boolean bl = lastChar = i == chars.length - 1;
            if (c != ' ' && !lastChar) {
                sb.append(c);
                continue;
            }
            if (c != ' ') {
                sb.append(c);
            }
            if (rx + (sw = this.fontMetrics.stringWidth(word = sb.toString())) > maxWidth) {
                ++lines;
                rx = 0;
            }
            for (char sc : word.toCharArray()) {
                rx += this.fontMetrics.stringWidth(String.valueOf(sc));
            }
            rx += spaceWidth;
            sb = new StringBuilder();
        }
        return lines;
    }

    private int getNumLinesImage(int maxWidth) {
        String str = Pattern.compile("\\^\\w").matcher(this.text).replaceAll("");
        char[] chars = str.replace("\\s+", " ").toCharArray();
        int rx = 0;
        int ry = this.lineHeight;
        int spaceWidth = this.fontMetrics.stringWidth(" ");
        StringBuilder sb = new StringBuilder();
        RSViewGroup.Gravity horizontalGravity = this.getHorizontalGravity(this.imageGravity);
        int imageStart = (maxWidth - this.imageW) / 2;
        this.imageX = this.imageX(this.imageW, this.imageGravity);
        this.imageY = this.imageY(this.imageH, this.imageGravity);
        for (int i = 0; i < chars.length; ++i) {
            boolean lastChar;
            char c = chars[i];
            boolean bl = lastChar = i == chars.length - 1;
            if (c != ' ' && !lastChar) {
                sb.append(c);
                continue;
            }
            if (c != ' ') {
                sb.append(c);
            }
            String word = sb.toString();
            int sw = this.fontMetrics.stringWidth(word);
            boolean isHeightRange = this.isImageHeightRange(ry - this.lineHeight);
            if (isHeightRange) {
                if (horizontalGravity == RSViewGroup.Gravity.START) {
                    if (rx < this.imageW) {
                        rx = this.imageW + 3;
                    }
                } else if (horizontalGravity == RSViewGroup.Gravity.CENTER) {
                    if (rx + sw > imageStart - 3) {
                        rx = this.imageX + this.imageW + 3;
                    }
                } else if (horizontalGravity == RSViewGroup.Gravity.END && rx + sw > maxWidth - this.imageW - 3) {
                    rx = 0;
                    ry += this.lineHeight;
                }
            }
            if (rx + sw > maxWidth) {
                isHeightRange = this.isImageHeightRange((ry += this.lineHeight) - this.lineHeight);
                rx = 0;
                if (isHeightRange && horizontalGravity == RSViewGroup.Gravity.START) {
                    rx = this.imageW + 3;
                }
            }
            for (char sc : word.toCharArray()) {
                rx += this.fontMetrics.stringWidth(String.valueOf(sc));
            }
            rx += spaceWidth;
            sb = new StringBuilder();
        }
        if (this.hasImage) {
            return Math.max(ry / this.lineHeight, 2);
        }
        return ry / this.lineHeight;
    }

    Color getColor(char c) {
        if (c == 'w') {
            return Color.WHITE;
        }
        if (c == 'b') {
            return Color.BLACK;
        }
        if (c == 'g') {
            return Color.GREEN;
        }
        if (c == 'p') {
            return Color.PINK;
        }
        if (c == 'u') {
            return Color.BLUE;
        }
        if (c == 'c') {
            return Color.CYAN;
        }
        if (c == 'm') {
            return Color.MAGENTA;
        }
        if (c == 'y') {
            return Color.YELLOW;
        }
        if (c == 'r') {
            return Color.RED;
        }
        if (c == 'o') {
            return new Color(252, 154, 78);
        }
        if (c == '0') {
            return this.textColor;
        }
        if (c == 'a') {
            return new Color(255, 0, 0, 0);
        }
        if (c == 'l') {
            return new Color(107, 242, 73);
        }
        if (c == 'd') {
            return new Color(107, 41, 242);
        }
        if (c == 'e') {
            return new Color(122, 75, 28);
        }
        if (c == 'f') {
            return new Color(35, 94, 49);
        }
        if (c == 'h') {
            return new Color(177, 184, 222);
        }
        if (c == 'i') {
            return new Color(255, 191, 135);
        }
        if (c == 'j') {
            return new Color(165, 11, 94);
        }
        if (c == 'k') {
            return new Color(66, 12, 3);
        }
        if (c == 'n') {
            return new Color(226, 255, 167);
        }
        if (c == 'q') {
            return new Color(0, 0, 0, 1);
        }
        return Color.WHITE;
    }

    private Color[] getTriadicColors(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float hue = hsb[0];
        float triHue = (hue + 120.0f) % 360.0f;
        float triHue2 = (hue + 240.0f) % 360.0f;
        Color triColor = Color.getHSBColor(triHue / 360.0f, hsb[1], hsb[2]);
        Color triColor2 = Color.getHSBColor(triHue2 / 360.0f, hsb[1], hsb[2]);
        return new Color[]{color, triColor, triColor2};
    }

    private Color[] getColorPair(Color[] colors, float percent) {
        int count = colors.length;
        int index = (int)(percent / (1.0f / (float)colors.length));
        int index2 = (index + 1) % count;
        return new Color[]{colors[index], colors[index2]};
    }

    private Color getInterpolatedColor(Color[] colorPair, int colorCount, float percent) {
        float t = percent % (1.0f / (float)colorCount) / (1.0f / (float)colorCount);
        Color sColor = colorPair[0];
        Color eColor = colorPair[1];
        int r = (int)((float)sColor.getRed() * (1.0f - t) + (float)eColor.getRed() * t);
        int g = (int)((float)sColor.getGreen() * (1.0f - t) + (float)eColor.getGreen() * t);
        int b = (int)((float)sColor.getBlue() * (1.0f - t) + (float)eColor.getBlue() * t);
        return new Color(r, g, b);
    }
}

