/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import java.util.HashMap;
import java.util.Map;

public enum RSLayoutGuide {
    MAX_WIDTH,
    MAX_HEIGHT,
    START,
    TOP,
    END,
    BOTTOM;


    static class Builder {
        private Map<RSLayoutGuide, Integer> guides = new HashMap<RSLayoutGuide, Integer>();

        Builder() {
        }

        public Builder maxWidth(int w) {
            this.guides.put(MAX_WIDTH, w);
            return this;
        }

        public Builder maxHeight(int h) {
            this.guides.put(MAX_HEIGHT, h);
            return this;
        }

        public Builder start(int s) {
            this.guides.put(START, s);
            return this;
        }

        public Builder top(int t) {
            this.guides.put(TOP, t);
            return this;
        }

        public Builder end(int e) {
            this.guides.put(END, e);
            return this;
        }

        public Builder bottom(int b) {
            this.guides.put(BOTTOM, b);
            return this;
        }

        public Map<RSLayoutGuide, Integer> build() {
            return this.guides;
        }
    }
}

