/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSLayoutGuide;
import com.ericversteeg.frosthprun.view.RSView;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Map;

public class RSImageView
extends RSView {
    private BufferedImage image;
    private int offset;
    private boolean offsetNegative = false;

    public RSImageView(int w, int h) {
        super(0, 0, w, h);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setOffset(int offset, boolean negative) {
        this.offset = offset;
        this.offsetNegative = negative;
    }

    @Override
    public int measureWidth(Map<RSLayoutGuide, Integer> guides) {
        if (this.image == null) {
            return 0;
        }
        return this.paddingStart + this.image.getWidth() + this.paddingEnd;
    }

    @Override
    public int measureHeight(Map<RSLayoutGuide, Integer> guides) {
        if (this.image == null) {
            return 0;
        }
        return this.paddingTop + this.image.getHeight() + this.paddingBottom;
    }

    @Override
    public void render(Graphics2D graphics, Point origin) {
        super.render(graphics, origin);
        int signedOffset = this.offset;
        if (this.offsetNegative) {
            signedOffset *= -1;
        }
        graphics.drawImage((Image)this.image, origin.x + this.x + this.paddingStart, origin.y + this.y + this.paddingTop + signedOffset, null);
    }
}

