/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSAnimation;
import com.ericversteeg.frosthprun.view.RSView;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Point;

public class RSBar
extends RSView {
    private Color topColorOuter = Color.decode("#0d8f0f");
    private Color topColorInner = Color.decode("#11D614");
    private Color darkColor = Color.decode("#0B780D");
    private Color bottomColor = Color.decode("#0F7311");
    private float[] stops = new float[]{0.0f, 0.275f, 0.55f, 0.65f, 1.0f};
    private Color[] colors = new Color[]{this.topColorOuter, this.topColorInner, this.topColorOuter, this.darkColor, this.bottomColor};
    private Color overlayStart = new Color(150, 150, 150, 0);
    private Color overlayEnd = new Color(247, 247, 143, 30);
    private float[] overlayStops = new float[]{0.0f, 1.0f};
    private Color[] overlayColors = new Color[]{this.overlayStart, this.overlayEnd};
    private float maxValue;
    private int value;

    public RSBar(int w, int h, int maxValue) {
        super(0, 0, w, h);
        this.maxValue = maxValue;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        float pixelsPerValue;
        float pixels;
        int oldValue = this.value;
        this.value = value;
        if (oldValue != value && (pixels = Math.abs((float)(oldValue - value) * (pixelsPerValue = (float)this.w / this.maxValue))) >= 5.0f) {
            this.animate().interpolate(oldValue, value).duration(0.2f).easeOut().start();
        }
    }

    public int getMaxValue() {
        return (int)this.maxValue;
    }

    public void setHue(float hue) {
        this.topColorOuter = this.hueColor(this.topColorOuter, hue);
        this.topColorInner = this.hueColor(this.topColorInner, hue);
        this.darkColor = this.hueColor(this.darkColor, hue);
        this.bottomColor = this.hueColor(this.bottomColor, hue);
    }

    @Override
    public void render(Graphics2D graphics, Point origin) {
        super.render(graphics, origin);
        if (this.maxValue == 0.0f) {
            return;
        }
        this.colors = new Color[]{this.colorWithOpacity(this.topColorOuter), this.colorWithOpacity(this.topColorInner), this.colorWithOpacity(this.topColorOuter), this.colorWithOpacity(this.darkColor), this.colorWithOpacity(this.bottomColor)};
        graphics.setPaint(this.colorWithOpacity(new Color(0, 0, 0, 156)));
        graphics.fillRect(origin.x + this.x, origin.y + this.y, this.w, this.h);
        LinearGradientPaint gradientPaint = new LinearGradientPaint(origin.x + this.x, origin.y + this.y, origin.x + this.x, origin.y + this.y + this.h, this.stops, this.colors);
        graphics.setPaint(gradientPaint);
        int barSize = (int)((float)this.w * ((float)this.value / this.maxValue));
        RSAnimation animation = (RSAnimation)this.animations.get((Object)RSAnimation.Type.INTERPOLATE);
        if (animation != null) {
            barSize = (int)((float)this.w * (animation.getValue() / this.maxValue));
        }
        graphics.fillRect(origin.x + this.x, origin.y + this.y, barSize, this.h);
        gradientPaint = new LinearGradientPaint(origin.x + this.x, this.h, origin.x + this.x + this.w, this.h, this.overlayStops, this.overlayColors);
        graphics.setPaint(gradientPaint);
        graphics.fillRect(origin.x + this.x, origin.y + this.y, barSize, this.h);
    }

    private Color hueColor(Color color, float hue) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(hue / 360.0f, hsb[1], hsb[2]);
    }
}

