/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun.view;

import com.ericversteeg.frosthprun.view.RSView;
import java.time.Instant;

public class RSAnimation {
    private RSView view;
    private Type type;
    private float duration;
    private long start;
    private float startOpacity;
    private float from;
    private float to;
    private OnComplete onComplete;
    private boolean easeOut = false;

    public RSAnimation(RSView view) {
        this.view = view;
    }

    public RSAnimation fadeIn() {
        this.type = Type.FADE_IN;
        this.startOpacity = this.view.opacity;
        return this;
    }

    public RSAnimation fadeOut() {
        this.type = Type.FADE_OUT;
        this.startOpacity = this.view.opacity;
        return this;
    }

    public RSAnimation interpolate(float from, float to) {
        this.type = Type.INTERPOLATE;
        this.from = from;
        this.to = to;
        return this;
    }

    public RSAnimation duration(float duration) {
        this.duration = duration;
        return this;
    }

    public RSAnimation easeOut() {
        this.easeOut = true;
        return this;
    }

    public RSAnimation start() {
        this.view.addAnimation(this.type, this);
        this.start = Instant.now().toEpochMilli();
        return this;
    }

    public RSAnimation onComplete(OnComplete onComplete) {
        this.onComplete = onComplete;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public float getValue() {
        float t = Math.min((float)(Instant.now().toEpochMilli() - this.start) / 1000.0f / this.duration, 1.0f);
        if (this.easeOut) {
            t = this.easeOut(t);
        }
        float value = 0.0f;
        switch (this.type) {
            case FADE_IN: {
                value = t * this.startOpacity;
                break;
            }
            case FADE_OUT: {
                value = (1.0f - t) * this.startOpacity;
                break;
            }
            case INTERPOLATE: {
                value = (this.to - this.from) * t + this.from;
            }
        }
        if (t >= 1.0f) {
            this.view.removeAnimation(this.type);
            if (this.onComplete != null) {
                this.onComplete.onComplete();
            }
        }
        return value;
    }

    private float easeOut(float t) {
        return (float)(1.0 - Math.pow(1.0f - t, 3.0));
    }

    public static interface OnComplete {
        public void onComplete();
    }

    static enum Type {
        FADE_IN,
        FADE_OUT,
        INTERPOLATE;

    }
}

