/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun;

import com.ericversteeg.frosthprun.FrostHpRunConfig;
import com.ericversteeg.frosthprun.FrostHpRunOverlay;
import com.ericversteeg.frosthprun.config.BarInfo;
import com.ericversteeg.frosthprun.config.BarType;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;

@PluginDescriptor(name="Frost HP & Run", description="Hitpoints and run bar overlays.")
public class FrostHpRunPlugin
extends Plugin {
    @Inject
    private FrostHpRunOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private FrostHpRunConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    private static final int VENOM_THRESHOLD = 1000000;
    private long lastHpChange = 0L;
    private int lastHp = -1;
    private long lastPrayerChange = 0L;
    private int lastPrayer = -1;
    private boolean fromActivePrayer = false;
    private long lastRunChange = 0L;
    private int lastRun = -1;
    private boolean fromRunIncrease = false;
    private long lastCombatChange = 0L;
    boolean isStaminaActive = false;
    private boolean lastStaminaActive = false;
    private boolean isPoisoned = false;
    private boolean isEnvenomed = false;
    private boolean isDiseased = false;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    FrostHpRunConfig provideConfig(ConfigManager configManager) {
        return (FrostHpRunConfig)configManager.getConfig(FrostHpRunConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("hpbar")) {
            this.overlay.clearHpViewInfo();
            this.overlay.clearRunViewInfo();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        if (skill.ordinal() == Skill.HITPOINTS.ordinal()) {
            int hp = statChanged.getBoostedLevel();
            if (this.lastHp >= 0 && (hp - this.lastHp < 0 || hp - this.lastHp > 1)) {
                this.lastHpChange = Instant.now().toEpochMilli();
            }
            this.lastHp = hp;
        } else if (skill.ordinal() == Skill.PRAYER.ordinal()) {
            int prayer = statChanged.getBoostedLevel();
            if (this.lastPrayer >= 0 && this.lastPrayer != prayer) {
                this.lastPrayerChange = Instant.now().toEpochMilli();
                this.fromActivePrayer = false;
            }
            this.lastPrayer = prayer;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        WorldPoint worldDestination;
        WorldPoint worldLocation;
        int distance;
        Actor interacting;
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != null && ((interacting = localPlayer.getInteracting()) instanceof NPC && ArrayUtils.contains((Object[])((NPC)interacting).getComposition().getActions(), (Object)"Attack") || interacting instanceof Player && this.client.getVarbitValue(8121) == 1)) {
            this.lastCombatChange = Instant.now().toEpochMilli();
        }
        if (this.isPrayerActive()) {
            this.lastPrayerChange = Instant.now().toEpochMilli();
            this.fromActivePrayer = true;
        }
        LocalPoint currentLocation = this.client.getLocalPlayer().getLocalLocation();
        LocalPoint destinationLocation = this.client.getLocalDestinationLocation();
        if (currentLocation != null && destinationLocation != null && (distance = (worldLocation = WorldPoint.fromLocal((Client)this.client, (LocalPoint)currentLocation)).distanceTo(worldDestination = WorldPoint.fromLocal((Client)this.client, (LocalPoint)destinationLocation))) > 2) {
            this.lastRunChange = Instant.now().toEpochMilli();
            this.fromRunIncrease = false;
        }
        int run = this.client.getEnergy() / 100;
        int runDiff = run - this.lastRun;
        if (this.lastRun != -1 && runDiff != 0 && runDiff != 1 && runDiff > 0) {
            this.fromRunIncrease = true;
            this.lastRunChange = Instant.now().toEpochMilli();
        }
        this.lastRun = run;
        int poison = this.client.getVarpValue(102);
        if (poison >= 1000000) {
            this.isPoisoned = false;
            this.isEnvenomed = true;
        } else if (poison > 0) {
            this.isPoisoned = true;
            this.isEnvenomed = false;
        } else {
            this.isPoisoned = false;
            this.isEnvenomed = false;
        }
        this.isDiseased = this.client.getVarpValue(456) > 0;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == 25 || event.getVarbitId() == 24 || event.getVarbitId() == 10385) {
            int staminaEffectActive = this.client.getVarbitValue(25);
            int staminaPotionEffectVarb = this.client.getVarbitValue(24);
            int enduranceRingEffectVarb = this.client.getVarbitValue(10385);
            int totalStaminaEffect = staminaPotionEffectVarb + enduranceRingEffectVarb;
            if (staminaEffectActive == 1) {
                boolean bl = this.isStaminaActive = totalStaminaEffect != 0;
                if (!this.lastStaminaActive && this.isStaminaActive) {
                    this.lastRunChange = Instant.now().toEpochMilli();
                    this.fromRunIncrease = true;
                }
                this.lastStaminaActive = this.isStaminaActive;
            }
        }
    }

    public boolean isActive() {
        long lastActive = this.getLastActive();
        long delay = 1800L;
        if (lastActive == this.lastHpChange || lastActive == this.lastPrayerChange && !this.fromActivePrayer || !this.config.showRunBar() && lastActive == this.lastRunChange && this.fromRunIncrease) {
            delay = 3600L;
        } else if (lastActive == this.lastCombatChange) {
            delay = (long)(this.config.combatHideDelay() + 2) * 600L;
        } else if (lastActive == this.lastPrayerChange && this.fromActivePrayer) {
            delay = 1200L;
        }
        return Instant.now().toEpochMilli() - lastActive <= delay;
    }

    public long getLastActive() {
        long lastActive = this.lastCombatChange;
        if (this.overlay.hasBarType(BarType.HITPOINTS) && this.lastHpChange > lastActive) {
            lastActive = this.lastHpChange;
        }
        if (this.overlay.hasBarType(BarType.PRAYER) && this.lastPrayerChange > lastActive) {
            lastActive = this.lastPrayerChange;
        }
        if (!this.config.showRunBar() && this.overlay.hasBarType(BarType.RUN_ENERGY) && this.lastRunChange > lastActive) {
            lastActive = this.lastRunChange;
        }
        return lastActive;
    }

    public boolean isRun() {
        long delay = 1800L;
        if (this.fromRunIncrease) {
            delay = 3600L;
        }
        return Instant.now().toEpochMilli() - this.lastRunChange <= delay;
    }

    private boolean isPrayerActive() {
        Prayer[] prayers;
        for (Prayer prayer : prayers = Prayer.values()) {
            if (!this.client.isPrayerActive(prayer)) continue;
            return true;
        }
        return false;
    }

    public Map<BarType, BarInfo> barInfo() {
        int hpHue = 0;
        if (this.isEnvenomed) {
            hpHue = 145;
        } else if (this.isPoisoned) {
            hpHue = 95;
        } else if (this.isDiseased) {
            hpHue = 75;
        }
        BarInfo hitpoints = new BarInfo(this.client.getBoostedSkillLevel(Skill.HITPOINTS), this.client.getRealSkillLevel(Skill.HITPOINTS), hpHue);
        int prayerHue = 175;
        if (this.isPrayerActive()) {
            prayerHue = 155;
        }
        BarInfo prayer = new BarInfo(this.client.getBoostedSkillLevel(Skill.PRAYER), this.client.getRealSkillLevel(Skill.PRAYER), prayerHue);
        BarInfo attack = new BarInfo(this.client.getVarpValue(300) / 10, 100, 121);
        int runHue = 50;
        if (this.isStaminaActive) {
            runHue = 25;
        }
        BarInfo run = new BarInfo(this.client.getEnergy() / 100, 100, runHue);
        HashMap<BarType, BarInfo> barInfo = new HashMap<BarType, BarInfo>();
        barInfo.put(BarType.HITPOINTS, hitpoints);
        barInfo.put(BarType.PRAYER, prayer);
        barInfo.put(BarType.SPECIAL_ATTACK, attack);
        barInfo.put(BarType.RUN_ENERGY, run);
        return barInfo;
    }
}

