/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun;

import com.ericversteeg.frosthprun.FrostHpRunConfig;
import com.ericversteeg.frosthprun.FrostHpRunPlugin;
import com.ericversteeg.frosthprun.config.BarInfo;
import com.ericversteeg.frosthprun.config.BarType;
import com.ericversteeg.frosthprun.view.RSBar;
import com.ericversteeg.frosthprun.view.RSBox;
import com.ericversteeg.frosthprun.view.RSColumn;
import com.ericversteeg.frosthprun.view.RSTextView;
import com.ericversteeg.frosthprun.view.RSView;
import com.ericversteeg.frosthprun.view.RSViewGroup;
import com.ericversteeg.frosthprun.view.RSViewOverlay;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

class FrostHpRunOverlay
extends RSViewOverlay {
    private final Client client;
    private final ItemManager itemManager;
    private final FrostHpRunPlugin plugin;
    private final FrostHpRunConfig config;
    private Font primaryFont;
    private Font secondaryFont;
    private Font smallFont;
    List<BarType> types;
    private RSColumn hpColumn;
    private RSColumn runColumn;
    private RSBar primaryBar;
    private RSTextView primaryTextView;
    private RSBar secondaryBar;
    private RSTextView secondaryTextView;
    private RSBar tertiaryBar;
    private RSTextView tertiaryTextView;
    private RSBar quaternaryBar;
    private RSTextView quaternaryTextView;
    private RSBar runBar;
    private RSTextView runTextView;
    private String hpViewName = "hp_view";
    private String runViewName = "run_view";
    private boolean isFadeOut = false;
    private boolean isFadeOutRun = false;

    @Inject
    private FrostHpRunOverlay(Client client, ItemManager itemManager, FrostHpRunPlugin plugin, FrostHpRunConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    void setupHpBar(boolean animate) {
        this.clearHpViewInfo();
        Map<BarType, BarInfo> barInfo = this.plugin.barInfo();
        int width = Math.min(800, Math.max(this.config.width(), 40));
        int height = Math.min(150, Math.max(this.config.height(), 20));
        this.setFonts(height);
        boolean hasSecondaryText = this.config.hasSecondaryText();
        this.hpColumn = new RSColumn(0, 0, width, RSView.WRAP_CONTENT);
        this.types = this.types();
        Collections.reverse(this.types);
        for (int i = 0; i < this.types.size(); ++i) {
            RSTextView text;
            RSBar bar;
            RSBox container;
            BarInfo info = barInfo.get((Object)this.types.get(i));
            if (i < this.types.size() - 1) {
                container = new RSBox(0, 0, RSView.MATCH_PARENT, height / 3);
                if (i == this.types.size() - 2 && this.config.isLargeSecondary()) {
                    container = new RSBox(0, 0, RSView.MATCH_PARENT, height / 2);
                }
                bar = new RSBar(RSView.MATCH_PARENT, RSView.MATCH_PARENT, info.maxValue);
                bar.setHue(info.hue);
                bar.setValue(info.value);
                text = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.smallFont);
                if (i == this.types.size() - 2 && this.config.isLargeSecondary()) {
                    text = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.smallFont);
                    text.setLayoutGravity(RSViewGroup.Gravity.START);
                }
                text.setText(String.valueOf(bar.getValue()));
                text.setMarginStart(1);
                text.setMarginTop(-1);
                container.addView(bar);
                if (hasSecondaryText) {
                    container.addView(text);
                }
                this.hpColumn.addView(container);
                if (i == this.types.size() - 2) {
                    this.secondaryBar = bar;
                    this.secondaryTextView = text;
                    continue;
                }
                if (i == this.types.size() - 3) {
                    this.tertiaryBar = bar;
                    this.tertiaryTextView = text;
                    continue;
                }
                if (i != this.types.size() - 4) continue;
                this.quaternaryBar = bar;
                this.quaternaryTextView = text;
                continue;
            }
            container = new RSBox(0, 0, RSView.MATCH_PARENT, height);
            bar = new RSBar(RSView.MATCH_PARENT, height, info.maxValue);
            text = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.primaryFont);
            bar.setValue(info.value);
            bar.setHue(info.hue);
            text.setText(String.format("%d", bar.getValue()));
            text.setLayoutGravity(RSViewGroup.Gravity.TOP);
            text.setMarginTop(height / 8);
            container.addView(bar);
            if (this.config.hasPrimaryText()) {
                container.addView(text);
            }
            this.hpColumn.addView(container);
            this.primaryBar = bar;
            this.primaryTextView = text;
        }
        this.hpColumn.setRenderReverse(true);
        this.hpColumn.setOpacity((float)Math.max(20, Math.min(100, this.config.barOpacity())) / 100.0f);
        if (animate) {
            this.hpColumn.animate().duration(0.1f).fadeIn().start();
        }
        RSViewOverlay.ViewInfo hpViewInfo = new RSViewOverlay.ViewInfo(this.client, this.hpColumn, this.config.anchorType(), this.config.anchorX(), this.config.anchorY());
        this.addViewInfo(this.hpViewName, hpViewInfo);
    }

    private void updateHpBar() {
        Map<BarType, BarInfo> barInfo = this.plugin.barInfo();
        for (int i = 0; i < this.types.size(); ++i) {
            BarInfo info = barInfo.get((Object)this.types.get(i));
            if (i < this.types.size() - 1) {
                if (i == this.types.size() - 2) {
                    this.secondaryBar.setValue(info.value);
                    this.secondaryBar.setHue(info.hue);
                    this.secondaryTextView.setText(String.valueOf(this.secondaryBar.getValue()));
                    continue;
                }
                if (i == this.types.size() - 3) {
                    this.tertiaryBar.setValue(info.value);
                    this.tertiaryBar.setHue(info.hue);
                    this.tertiaryTextView.setText(String.valueOf(this.tertiaryBar.getValue()));
                    continue;
                }
                if (i != this.types.size() - 4) continue;
                this.quaternaryBar.setValue(info.value);
                this.quaternaryBar.setHue(info.hue);
                this.quaternaryTextView.setText(String.valueOf(this.quaternaryBar.getValue()));
                continue;
            }
            this.primaryBar.setValue(info.value);
            this.primaryBar.setHue(info.hue);
            this.primaryTextView.setText(String.valueOf(this.primaryBar.getValue()));
        }
    }

    void setupRunBar(boolean animate) {
        this.clearRunViewInfo();
        Map<BarType, BarInfo> barInfo = this.plugin.barInfo();
        int width = Math.min(800, Math.max(this.config.runWidth(), 40));
        int height = Math.min(150, Math.max(this.config.runHeight(), 20));
        this.setFonts(height);
        this.runColumn = new RSColumn(0, 0, width, RSView.WRAP_CONTENT);
        BarInfo info = barInfo.get((Object)BarType.RUN_ENERGY);
        RSBox container = new RSBox(0, 0, RSView.MATCH_PARENT, height);
        RSBar bar = new RSBar(RSView.MATCH_PARENT, height, info.maxValue);
        RSTextView text = new RSTextView(0, 0, RSView.WRAP_CONTENT, RSView.WRAP_CONTENT, this.primaryFont);
        bar.setValue(info.value);
        bar.setHue(info.hue);
        text.setText(String.format("%d", bar.getValue()));
        text.setLayoutGravity(RSViewGroup.Gravity.TOP);
        text.setMarginTop(height / 8);
        container.addView(bar);
        if (this.config.hasRunPrimaryText()) {
            container.addView(text);
        }
        this.runColumn.addView(container);
        this.runBar = bar;
        this.runTextView = text;
        this.runColumn.setOpacity((float)Math.max(20, Math.min(100, this.config.runBarOpacity())) / 100.0f);
        if (animate) {
            this.runColumn.animate().duration(0.1f).fadeIn().start();
        }
        RSViewOverlay.ViewInfo runViewInfo = new RSViewOverlay.ViewInfo(this.client, this.runColumn, this.config.runAnchorType(), this.config.runAnchorX(), this.config.runAnchorY());
        this.addViewInfo(this.runViewName, runViewInfo);
    }

    private void updateRunBar() {
        Map<BarType, BarInfo> barInfo = this.plugin.barInfo();
        BarInfo info = barInfo.get((Object)BarType.RUN_ENERGY);
        this.runBar.setValue(info.value);
        this.runBar.setHue(info.hue);
        this.runTextView.setText(String.valueOf(this.runBar.getValue()));
    }

    private void setFonts(int height) {
        Font font;
        InputStream inputStream;
        GraphicsEnvironment ge;
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            inputStream = FontManager.class.getResourceAsStream("runescape_bold.ttf");
            font = Font.createFont(0, inputStream).deriveFont(0, (int)Math.ceil((double)height * (double)0.55f));
            ge.registerFont(font);
            this.primaryFont = font;
        }
        catch (Exception e) {
            this.primaryFont = FontManager.getRunescapeBoldFont();
        }
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            inputStream = FontManager.class.getResourceAsStream("runescape_bold.ttf");
            font = Font.createFont(0, inputStream).deriveFont(0, (int)Math.ceil((double)height / 3.0));
            ge.registerFont(font);
            this.secondaryFont = font;
        }
        catch (Exception e) {
            this.secondaryFont = FontManager.getRunescapeSmallFont();
        }
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            inputStream = FontManager.class.getResourceAsStream("runescape_bold.ttf");
            font = Font.createFont(0, inputStream).deriveFont(0, (int)Math.ceil((double)height / 3.0));
            ge.registerFont(font);
            this.smallFont = font;
        }
        catch (Exception e) {
            this.smallFont = FontManager.getRunescapeSmallFont();
        }
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        if (this.config.isAlwaysVisible() && this.config.showHpBar() && !this.containsViewInfo(this.hpViewName)) {
            this.setupHpBar(false);
        } else if (this.config.isAlwaysVisible() && this.config.showHpBar()) {
            this.updateHpBar();
        } else if (this.config.showHpBar()) {
            if (this.plugin.isActive() && !this.containsViewInfo(this.hpViewName)) {
                this.setupHpBar(true);
            } else if (this.plugin.isActive()) {
                this.updateHpBar();
            } else if (this.containsViewInfo(this.hpViewName) && !this.isFadeOut) {
                this.hpColumn.animate().fadeOut().duration(0.1f).onComplete(() -> {
                    this.removeViewInfo(this.hpViewName, false);
                    this.isFadeOut = false;
                }).start();
                this.isFadeOut = true;
            }
        }
        if (this.config.isRunAlwaysVisible() && this.config.showRunBar() && !this.containsViewInfo(this.runViewName)) {
            this.setupRunBar(false);
        } else if (this.config.isRunAlwaysVisible() && this.config.showRunBar()) {
            this.updateRunBar();
        } else if (this.config.showRunBar()) {
            if (this.plugin.isRun() && !this.containsViewInfo(this.runViewName)) {
                this.setupRunBar(true);
            } else if (this.plugin.isRun()) {
                this.updateRunBar();
            } else if (this.containsViewInfo(this.runViewName) && !this.isFadeOutRun) {
                this.runColumn.animate().fadeOut().duration(0.1f).onComplete(() -> {
                    this.removeViewInfo(this.runViewName, false);
                    this.isFadeOutRun = false;
                }).start();
                this.isFadeOutRun = true;
            }
        }
        return super.render(graphics);
    }

    private List<BarType> types() {
        BarType primary = this.config.primaryBarType();
        BarType secondary = this.config.secondaryBarType();
        BarType tertiary = this.config.tertiaryBarType();
        BarType quaternary = this.config.quaternaryBarType();
        ArrayList<BarType> barTypes = new ArrayList<BarType>();
        if (primary != BarType.NONE) {
            barTypes.add(primary);
        }
        if (!barTypes.contains((Object)secondary) && secondary != BarType.NONE) {
            barTypes.add(secondary);
        }
        if (!barTypes.contains((Object)tertiary) && tertiary != BarType.NONE) {
            barTypes.add(tertiary);
        }
        if (!barTypes.contains((Object)quaternary) && quaternary != BarType.NONE) {
            barTypes.add(quaternary);
        }
        return barTypes;
    }

    boolean hasBarType(BarType barType) {
        for (BarType type : this.types()) {
            if (barType != type) continue;
            return true;
        }
        return false;
    }

    public void clearHpViewInfo() {
        this.removeViewInfo(this.hpViewName, true);
        this.isFadeOut = false;
    }

    public void clearRunViewInfo() {
        this.removeViewInfo(this.runViewName, true);
        this.isFadeOutRun = false;
    }
}

