/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.frosthprun;

import com.ericversteeg.frosthprun.config.BarType;
import com.ericversteeg.frosthprun.view.RSAnchorType;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="hpbar")
public interface FrostHpRunConfig
extends Config {
    public static final String GROUP = "hpbar";
    @ConfigSection(position=0, name="Hp Bar", description="Hp and associated bars.")
    public static final String hpBarSection = "hpBar";
    @ConfigSection(position=1, name="Run Bar", description="Run bar.")
    public static final String runBarSection = "runBar";

    @ConfigItem(position=0, keyName="primaryBar", name="Primary", description="Configures what the primary bar is.", section="hpBar")
    default public BarType primaryBarType() {
        return BarType.HITPOINTS;
    }

    @ConfigItem(position=1, keyName="secondaryBar", name="Secondary", description="Configures what the secondary bar is.", section="hpBar")
    default public BarType secondaryBarType() {
        return BarType.PRAYER;
    }

    @ConfigItem(position=2, keyName="tertiaryBar", name="Tertiary", description="Configures what the tertiary bar is.", section="hpBar")
    default public BarType tertiaryBarType() {
        return BarType.SPECIAL_ATTACK;
    }

    @ConfigItem(position=3, keyName="quaternaryBar", name="Quaternary", description="Configures what the quaternary bar is.", section="hpBar")
    default public BarType quaternaryBarType() {
        return BarType.RUN_ENERGY;
    }

    @ConfigItem(position=4, keyName="enableHp", name="Enable", description="Configures whether to enable.", section="hpBar")
    default public boolean showHpBar() {
        return true;
    }

    @ConfigItem(position=5, keyName="alwaysVisible", name="Always On", description="Configures whether or not bars are always on.", section="hpBar")
    default public boolean isAlwaysVisible() {
        return true;
    }

    @ConfigItem(position=5, keyName="combatDelay", name="Combat Hide Delay", description="Configures how many ticks after combat the bar hides.", section="hpBar")
    default public int combatHideDelay() {
        return 0;
    }

    @ConfigItem(position=5, keyName="barOpacity", name="Opacity", description="Configures the opacity of the bar (20-100).", section="hpBar")
    default public int barOpacity() {
        return 100;
    }

    @ConfigItem(position=6, keyName="largeSecondary", name="Large Secondary", description="Configures whether or not the secondary bar is large.", section="hpBar")
    default public boolean isLargeSecondary() {
        return false;
    }

    @ConfigItem(position=7, keyName="primaryText", name="Text", description="Configures whether or not to show text.", section="hpBar")
    default public boolean hasPrimaryText() {
        return true;
    }

    @ConfigItem(position=8, keyName="smallText", name="Small Text", description="Configures whether or not to show small text.", section="hpBar")
    default public boolean hasSecondaryText() {
        return true;
    }

    @ConfigItem(position=9, keyName="anchorType", name="Anchor", description="Configures view anchor.", section="hpBar")
    default public RSAnchorType anchorType() {
        return RSAnchorType.TOP_CENTER;
    }

    @ConfigItem(position=10, keyName="anchorX", name="Offset X", description="Configures x offset.", section="hpBar")
    default public int anchorX() {
        return 0;
    }

    @ConfigItem(position=11, keyName="anchorY", name="Offset Y", description="Configures y offset.", section="hpBar")
    default public int anchorY() {
        return 100;
    }

    @ConfigItem(position=12, keyName="width", name="Width", description="Configures the width.", section="hpBar")
    default public int width() {
        return 145;
    }

    @ConfigItem(position=13, keyName="height", name="Height", description="Configures the height.", section="hpBar")
    default public int height() {
        return 20;
    }

    @ConfigItem(position=14, keyName="enableRun", name="Enable", description="Configures whether or not to enable.", section="runBar")
    default public boolean showRunBar() {
        return true;
    }

    @ConfigItem(position=15, keyName="runAlwaysVisible", name="Always On", description="Configures whether or not bar is always on.", section="runBar")
    default public boolean isRunAlwaysVisible() {
        return true;
    }

    @ConfigItem(position=15, keyName="runBarOpacity", name="Opacity", description="Configures the opacity of the bar (20-100).", section="runBar")
    default public int runBarOpacity() {
        return 100;
    }

    @ConfigItem(position=15, keyName="runPrimaryText", name="Text", description="Configures whether or not to show text.", section="runBar")
    default public boolean hasRunPrimaryText() {
        return true;
    }

    @ConfigItem(position=16, keyName="runAnchorType", name="Anchor", description="Configures view anchor.", section="runBar")
    default public RSAnchorType runAnchorType() {
        return RSAnchorType.TOP_CENTER;
    }

    @ConfigItem(position=17, keyName="runAnchorX", name="Offset X", description="Configure x offset.", section="runBar")
    default public int runAnchorX() {
        return 0;
    }

    @ConfigItem(position=18, keyName="runAnchorY", name="Offset Y", description="Configures y offset.", section="runBar")
    default public int runAnchorY() {
        return 150;
    }

    @ConfigItem(position=19, keyName="runWidth", name="Width", description="Configures width.", section="runBar")
    default public int runWidth() {
        return 145;
    }

    @ConfigItem(position=20, keyName="runHeight", name="Height", description="Configures height.", section="runBar")
    default public int runHeight() {
        return 20;
    }
}

