/*
 * Decompiled with CFR 0.152.
 */
package com.attacksound;

import com.attacksound.AnimationData;
import com.attacksound.AttackSoundConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Attack Sound")
public class AttackSoundPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AttackSoundPlugin.class);
    private long previousSoundTime = 0L;
    private boolean newAttackPossible = true;
    private boolean isFocused = true;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private AttackSoundConfig config;

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(() -> {
                this.previousSoundTime = System.currentTimeMillis() + 1000L;
            });
        }
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChanged) {
        if ("AttackSound".equals(configChanged.getGroup()) && "soundID".equals(configChanged.getKey())) {
            this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.soundID(), this.config.volume()));
        }
    }

    @Subscribe
    protected void onStatChanged(StatChanged event) {
        if (event.getSkill() == Skill.HITPOINTS) {
            this.playSound();
        }
    }

    @Subscribe
    public void onFocusChanged(FocusChanged event) {
        this.isFocused = event.isFocused();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.newAttackPossible && AnimationData.fromId(this.client.getLocalPlayer().getAnimation()) != null) {
            this.playSound();
            this.newAttackPossible = false;
        }
        if (!this.newAttackPossible && AnimationData.fromId(this.client.getLocalPlayer().getAnimation()) == null) {
            this.newAttackPossible = true;
        }
    }

    public void playSound() {
        if (this.config.soundsOnlyWhileFocused() && !this.isFocused) {
            return;
        }
        if (System.currentTimeMillis() - this.previousSoundTime > (long)this.config.muteDuration()) {
            this.client.playSoundEffect(this.config.soundID(), this.config.volume());
            this.previousSoundTime = System.currentTimeMillis();
        }
    }

    @Provides
    AttackSoundConfig provideConfig(ConfigManager configManager) {
        return (AttackSoundConfig)configManager.getConfig(AttackSoundConfig.class);
    }
}

