/*
 * Decompiled with CFR 0.152.
 */
package com.runecraftingtracker;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.runecraftingtracker.PanelItemData;
import com.runecraftingtracker.RunecraftingTrackerPanel;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Runecrafting Tracker", description="Track your total profit and the amount of runes you have crafted", tags={"rc", "rune", "craft", "runecraft", "runecrafting", "track", "tracker", "zmi", "ourania", "altar"})
public class RunecraftingTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RunecraftingTrackerPlugin.class);
    private static final int RUNECRAFTING_ANIMATION_ID = 791;
    private RunecraftingTrackerPanel uiPanel;
    private int[] runeIDs = new int[]{556, 558, 555, 557, 554, 559, 564, 562, 9075, 561, 563, 560, 565, 566, 21880, 4695, 4696, 4698, 4697, 4694, 4699};
    private NavigationButton uiNavigationButton;
    private LinkedList<PanelItemData> runeTracker = new LinkedList();
    private Multiset<Integer> inventorySnapshot;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager manager;

    protected void startUp() throws Exception {
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.uiPanel = new RunecraftingTrackerPanel(this.manager, this.runeTracker);
        this.uiNavigationButton = NavigationButton.builder().tooltip("Runecrafting Tracker").icon(icon).priority(10).panel((PluginPanel)this.uiPanel).build();
        this.clientToolbar.addNavigation(this.uiNavigationButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
    }

    private void init() {
        for (int i = 0; i < Runes.values().length; ++i) {
            this.runeTracker.add(new PanelItemData(Runes.values()[i].name(), this.runeIDs[i], false, 0, this.manager.getItemPrice(this.runeIDs[i])));
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN && this.runeTracker.size() == 0) {
            this.clientThread.invokeLater(this::init);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        String actorName;
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        String playerName = this.client.getLocalPlayer().getName();
        if (playerName.equals(actorName = event.getActor().getName())) {
            int animId = event.getActor().getAnimation();
            if (animId == 791) {
                this.takeInventorySnapshot();
            } else {
                this.inventorySnapshot = null;
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        this.processChange(event.getItemContainer());
    }

    private void processChange(ItemContainer current) {
        if (this.inventorySnapshot != null) {
            HashMultiset currentInventory = HashMultiset.create();
            Arrays.stream(current.getItems()).forEach(arg_0 -> RunecraftingTrackerPlugin.lambda$processChange$0((Multiset)currentInventory, arg_0));
            Multiset diff = Multisets.difference((Multiset)currentInventory, this.inventorySnapshot);
            List items = diff.entrySet().stream().map(e -> new ItemStack(((Integer)e.getElement()).intValue(), e.getCount(), this.client.getLocalPlayer().getLocalLocation())).collect(Collectors.toList());
            LinkedList<PanelItemData> panels = this.uiPanel.getRuneTracker();
            if (items.size() > 0) {
                for (ItemStack stack : items) {
                    for (PanelItemData item : panels) {
                        if (item.getId() != stack.getId()) continue;
                        if (!item.isVisible()) {
                            item.setVisible(true);
                        }
                        item.setCrafted(item.getCrafted() + stack.getQuantity());
                    }
                }
                this.inventorySnapshot = currentInventory;
                try {
                    SwingUtilities.invokeAndWait(this.uiPanel::pack);
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
                this.uiPanel.refresh();
            }
        }
    }

    private void takeInventorySnapshot() {
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer != null) {
            this.inventorySnapshot = HashMultiset.create();
            Arrays.stream(itemContainer.getItems()).forEach(item -> this.inventorySnapshot.add((Object)item.getId(), item.getQuantity()));
        }
    }

    protected LinkedList<PanelItemData> getRuneTracker() {
        return this.runeTracker;
    }

    private static /* synthetic */ void lambda$processChange$0(Multiset currentInventory, Item item) {
        currentInventory.add((Object)item.getId(), item.getQuantity());
    }

    static enum Runes {
        AIR,
        MIND,
        WATER,
        EARTH,
        FIRE,
        BODY,
        COSMIC,
        CHAOS,
        ASTRAL,
        NATURE,
        LAW,
        DEATH,
        BLOOD,
        SOUL,
        WRATH,
        MIST,
        DUST,
        MUD,
        SMOKE,
        STEAM,
        LAVA;

    }
}

