/*
 * Decompiled with CFR 0.152.
 */
package com.runecraftingtracker;

import com.runecraftingtracker.PanelItemData;
import com.runecraftingtracker.RunecraftingTrackerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;

public class RunecraftingTrackerPanel
extends PluginPanel {
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final JPanel layoutContainer;
    private ItemManager itemManager;
    private LinkedList<PanelItemData> runeTracker;
    private final ImageIcon COIN_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(RunecraftingTrackerPlugin.class, (String)"COIN.png"));
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";

    RunecraftingTrackerPanel(ItemManager itemManager, LinkedList<PanelItemData> runeTracker) {
        this.itemManager = itemManager;
        this.runeTracker = runeTracker;
        this.setBorder(new EmptyBorder(10, 5, 5, 5));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.layoutContainer = new JPanel();
        this.layoutContainer.setLayout(new GridLayout(0, 1, 0, 2));
        this.add(this.layoutContainer, "North");
        this.errorPanel.setContent("Runecrafting Tracker", "You have not crafted any runes yet.");
        this.pack();
    }

    protected void pack() {
        this.layoutContainer.removeAll();
        AtomicInteger totalProfit = new AtomicInteger(0);
        this.runeTracker.forEach(temp -> totalProfit.addAndGet(temp.getCrafted() * temp.getCostPerRune()));
        if (this.runeTracker.size() == 0) {
            this.layoutContainer.add((Component)this.errorPanel);
        } else {
            this.layoutContainer.add(this.topPanelItem(this.COIN_ICON, totalProfit));
            this.runeTracker.forEach(temp -> {
                if (temp.isVisible()) {
                    JPanel runePanelItem = this.runePanelItem(temp.getId(), temp.getCrafted(), temp.getCrafted() * temp.getCostPerRune());
                    this.layoutContainer.add(runePanelItem);
                }
            });
        }
    }

    protected void refresh() {
        this.revalidate();
    }

    protected LinkedList<PanelItemData> getRuneTracker() {
        return this.runeTracker;
    }

    private static String createLabel(String label, long value) {
        return RunecraftingTrackerPanel.createLabel(label, value, "");
    }

    private static String createLabel(String label, long value, String valueSuffix) {
        String valueStr = QuantityFormatter.quantityToStackSize((long)value);
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), label, valueStr + valueSuffix);
    }

    private JPanel runePanelItem(int itemId, int textTop_crafted, int textBottom_profit) {
        JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setLayout(new BorderLayout());
        container.setBorder(new EmptyBorder(4, 10, 4, 10));
        JLabel iconLabel = new JLabel();
        this.itemManager.getImage(itemId, textTop_crafted, true).addTo(iconLabel);
        container.add((Component)iconLabel, "West");
        JPanel textContainer = new JPanel();
        textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        textContainer.setLayout(new GridLayout(2, 1));
        textContainer.setBorder(new EmptyBorder(5, 5, 5, 10));
        JLabel topLine = new JLabel(RunecraftingTrackerPanel.createLabel("Crafted: ", textTop_crafted));
        topLine.setForeground(Color.WHITE);
        topLine.setFont(FontManager.getRunescapeSmallFont());
        JLabel bottomLine = new JLabel(RunecraftingTrackerPanel.createLabel("Profit: ", textBottom_profit, " gp"));
        bottomLine.setForeground(Color.WHITE);
        bottomLine.setFont(FontManager.getRunescapeSmallFont());
        textContainer.add(topLine);
        textContainer.add(bottomLine);
        container.add((Component)textContainer, "Center");
        return container;
    }

    private JPanel topPanelItem(ImageIcon icon, AtomicInteger totalProfit) {
        JPanel panelContainer = new JPanel();
        panelContainer.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        panelContainer.setLayout(new BorderLayout());
        panelContainer.setBorder(new EmptyBorder(5, 10, 5, 10));
        JLabel iconLabel = new JLabel(icon);
        panelContainer.add((Component)iconLabel, "West");
        JLabel middleLine = new JLabel(RunecraftingTrackerPanel.createLabel("Total profit: ", totalProfit.longValue(), " gp"));
        middleLine.setForeground(Color.WHITE);
        middleLine.setFont(FontManager.getRunescapeSmallFont());
        JPanel textContainer = new JPanel();
        textContainer.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        textContainer.setLayout(new GridLayout(1, 1));
        textContainer.setBorder(new EmptyBorder(0, 10, 0, 10));
        textContainer.add(middleLine);
        panelContainer.add((Component)textContainer, "Center");
        JMenuItem resetAll = new JMenuItem("Reset All");
        resetAll.addActionListener(e -> {
            int result = JOptionPane.showOptionDialog(panelContainer, String.format("<html>This will permanently delete <b>all</b> crafted runes.</html>", new Object[0]), "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
            if (result != 0) {
                return;
            }
            for (PanelItemData item : this.runeTracker) {
                item.setCrafted(0);
                item.setVisible(false);
            }
            this.layoutContainer.removeAll();
            this.layoutContainer.add((Component)this.errorPanel);
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(resetAll);
        panelContainer.setComponentPopupMenu(popupMenu);
        return panelContainer;
    }
}

