/*
 * Decompiled with CFR 0.152.
 */
package dekvall.emojimadness;

import com.google.common.base.Joiner;
import com.google.inject.Provides;
import dekvall.emojimadness.Emoji;
import dekvall.emojimadness.EmojiMadnessConfig;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Emoji Madness", description="Use emojis instead of words")
public class EmojiMadnessPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EmojiMadnessPlugin.class);
    private static final Pattern TAG_REGEXP = Pattern.compile("<[^>]*>");
    private static final Pattern WHITESPACE_REGEXP = Pattern.compile("[\\s\\u00A0]");
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private EmojiMadnessConfig config;
    private int modIconsStart = -1;

    @Provides
    EmojiMadnessConfig provideConfig(ConfigManager configManager) {
        return (EmojiMadnessConfig)configManager.getConfig(EmojiMadnessConfig.class);
    }

    protected void startUp() {
        this.loadEmojiIcons();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadEmojiIcons();
        }
    }

    private void loadEmojiIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.modIconsStart != -1 || modIcons == null) {
            return;
        }
        Emoji[] emojis = Emoji.values();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + emojis.length);
        this.modIconsStart = modIcons.length;
        for (int i = 0; i < emojis.length; ++i) {
            Emoji emoji = emojis[i];
            try {
                IndexedSprite sprite;
                BufferedImage image = emoji.loadImage();
                newModIcons[this.modIconsStart + i] = sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
                continue;
            }
            catch (Exception ex) {
                log.warn("Failed to load the sprite for emoji " + emoji, (Throwable)ex);
            }
        }
        log.debug("Adding emoji icons");
        this.client.setModIcons(newModIcons);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.modIconsStart == -1) {
            return;
        }
        switch (chatMessage.getType()) {
            case PUBLICCHAT: 
            case MODCHAT: 
            case FRIENDSCHAT: 
            case PRIVATECHAT: 
            case PRIVATECHATOUT: 
            case MODPRIVATECHAT: {
                break;
            }
            default: {
                return;
            }
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        String message = messageNode.getValue();
        String updatedMessage = this.updateMessage(message);
        if (updatedMessage == null) {
            return;
        }
        messageNode.setRuneLiteFormatMessage(updatedMessage);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        String message = event.getOverheadText();
        String updatedMessage = this.updateMessage(message);
        if (updatedMessage == null) {
            return;
        }
        event.getActor().setOverheadText(updatedMessage);
    }

    @Nullable
    String updateMessage(String message) {
        String[] messageWords = WHITESPACE_REGEXP.split(message);
        ArrayList<Object> newMessageWords = new ArrayList<Object>();
        boolean editedMessage = false;
        for (int i = 0; i < messageWords.length; ++i) {
            String trigger = EmojiMadnessPlugin.removeTags(messageWords[i]);
            List<List<String>> phrases = Emoji.getTriggers(trigger.toLowerCase());
            newMessageWords.add(messageWords[i]);
            if (phrases == null) continue;
            List<String> splitTrigger = null;
            block1: for (List<String> words : phrases) {
                if (i + words.size() > messageWords.length) continue;
                for (int j = 0; j < words.size(); ++j) {
                    if (!words.get(j).equals(messageWords[i + j].toLowerCase())) continue block1;
                }
                splitTrigger = words;
                break;
            }
            if (splitTrigger == null) continue;
            String triggerPhrase = Joiner.on((String)" ").join(splitTrigger);
            Emoji emoji = Emoji.getEmoji(triggerPhrase);
            int emojiId = this.modIconsStart + emoji.ordinal();
            newMessageWords.remove(newMessageWords.lastIndexOf(messageWords[i]));
            if (this.config.appendMode()) {
                newMessageWords.addAll(splitTrigger);
                newMessageWords.add("[<img=" + emojiId + ">]");
            } else {
                newMessageWords.add("<img=" + emojiId + ">");
            }
            i += splitTrigger.size() - 1;
            editedMessage = true;
        }
        if (!editedMessage) {
            return null;
        }
        return Joiner.on((String)" ").join(newMessageWords);
    }

    private static String removeTags(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = TAG_REGEXP.matcher(str);
        while (matcher.find()) {
            String match;
            matcher.appendReplacement(stringBuffer, "");
            switch (match = matcher.group(0)) {
                case "<lt>": 
                case "<gt>": {
                    stringBuffer.append(match);
                }
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

