/*
 * Decompiled with CFR 0.152.
 */
package com.instantnotify;

import com.google.inject.Provides;
import com.instantnotify.InstantNotifyConfig;
import com.instantnotify.NotificationType;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Instant Idle Notify")
public class InstantNotifyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InstantNotifyPlugin.class);
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private InstantNotifyConfig config;
    @Inject
    private ClientThread clientThread;
    private Map<Integer, Integer> itemAmounts;
    private Map<Integer, Integer> changedItems = new HashMap<Integer, Integer>();
    private int lastTickDelay;
    private int lastTick;
    private int cyclesRepeated;

    protected void startUp() throws Exception {
        log.info("Instant Idle Notify started!");
        this.lastTickDelay = -1;
        this.cyclesRepeated = 0;
    }

    protected void shutDown() throws Exception {
        log.info("Instant Idle Notify stopped!");
        this.itemAmounts = null;
        this.changedItems.clear();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.invChange(itemContainerChanged);
        }
    }

    private void loadInv() {
        this.itemAmounts = new HashMap<Integer, Integer>();
        ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
        if (itemContainer == null) {
            return;
        }
        for (Item item : itemContainer.getItems()) {
            if (item.getId() < 0) continue;
            this.itemAmounts.merge(item.getId(), item.getQuantity(), Integer::sum);
        }
    }

    private void invChange(ItemContainerChanged itemContainerChanged) {
        if (this.itemAmounts == null) {
            this.loadInv();
            return;
        }
        if (this.client.getWidget(WidgetInfo.BANK_CONTAINER) != null) {
            return;
        }
        HashMap<Integer, Integer> newItemAmounts = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> newChangedItems = new HashMap<Integer, Integer>();
        for (Item item : itemContainerChanged.getItemContainer().getItems()) {
            if (item.getId() < 0) continue;
            newItemAmounts.merge(item.getId(), item.getQuantity(), Integer::sum);
        }
        newItemAmounts.forEach((key, value) -> {
            int dif = value - this.itemAmounts.getOrDefault(key, 0);
            if (dif != 0) {
                newChangedItems.put((Integer)key, dif);
            }
        });
        this.itemAmounts.forEach((key, value) -> {
            int dif;
            if (!newItemAmounts.containsKey(key) && (dif = newItemAmounts.getOrDefault(key, 0) - value) != 0) {
                newChangedItems.put((Integer)key, dif);
            }
        });
        int tickDelay = this.client.getTickCount() - this.lastTick;
        if (this.changedItems.equals(newChangedItems) && this.lastTickDelay == tickDelay) {
            ++this.cyclesRepeated;
            for (Map.Entry entry : newChangedItems.entrySet()) {
                int id = (Integer)entry.getKey();
                int amount = (Integer)entry.getValue();
                if (amount >= 0 || newItemAmounts.getOrDefault(id, 0) >= -amount) continue;
                this.playNotification();
            }
        } else {
            this.cyclesRepeated = 0;
        }
        this.lastTickDelay = tickDelay;
        this.lastTick = this.client.getTickCount();
        this.itemAmounts = newItemAmounts;
        this.changedItems = newChangedItems;
    }

    private void playNotification() {
        NotificationType type = this.config.notificationType();
        if (type == NotificationType.RUNELITE || type == NotificationType.BOTH) {
            this.notifier.notify("Instant Idle Notify");
        }
        if (type == NotificationType.SOUND || type == NotificationType.BOTH) {
            this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.soundId(), this.config.volume()));
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        String menuOption = menuOptionClicked.getMenuOption();
        if (menuOption.equals("Drop") || menuOption.startsWith("Withdraw") || menuOption.startsWith("Deposit") || menuOption.equals("Eat") || menuOption.equals("Scatter") || menuOption.equals("Bury") || menuOption.equals("Drink")) {
            this.lastTickDelay = -1;
        }
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChanged) {
        if (!"InstantIdleNotify".equals(configChanged.getGroup())) {
            return;
        }
        if ("soundId".equals(configChanged.getKey())) {
            this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.soundId(), this.config.volume()));
        }
    }

    @Provides
    InstantNotifyConfig provideConfig(ConfigManager configManager) {
        return (InstantNotifyConfig)configManager.getConfig(InstantNotifyConfig.class);
    }
}

