/*
 * Decompiled with CFR 0.152.
 */
package com.github.gmoley;

import com.github.gmoley.GameEvent;
import com.github.gmoley.SseAddressBuilder;
import com.github.gmoley.StatRegister;
import com.github.gmoley.TrackedStats;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.OSType;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Steelseries Gamesense")
public class GamesensePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GamesensePlugin.class);
    private String sse3Address;
    public static final String game = "RUNELITE";
    private int lastXp = 0;
    private int currentHp = 0;
    private int currentPrayer = 0;
    @Inject
    private Client client;
    @Inject
    private OkHttpClient okHttpClient;

    protected void startUp() throws Exception {
        log.info("Example started!");
        this.FindSSE3Port();
        this.initGamesense();
    }

    protected void shutDown() throws Exception {
        log.info("Example stopped!");
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        GameEvent event;
        int percent;
        int max;
        int lvl;
        if (statChanged.getSkill() == Skill.HITPOINTS) {
            lvl = statChanged.getBoostedLevel();
            max = statChanged.getLevel();
            percent = lvl * 100 / max;
            this.currentHp = lvl;
            event = new GameEvent(TrackedStats.HEALTH, percent);
            this.executePost("game_event ", event.buildJson());
        }
        if (statChanged.getSkill() == Skill.PRAYER) {
            lvl = statChanged.getBoostedLevel();
            max = statChanged.getLevel();
            percent = lvl * 100 / max;
            this.currentPrayer = lvl;
            event = new GameEvent(TrackedStats.PRAYER, percent);
            this.executePost("game_event ", event.buildJson());
        }
        if (!(statChanged.getXp() == this.lastXp || statChanged.getSkill() == Skill.PRAYER && this.currentPrayer == statChanged.getBoostedLevel() || statChanged.getSkill() == Skill.HITPOINTS && this.currentHp == statChanged.getBoostedLevel())) {
            int currentXP = this.client.getSkillExperience(statChanged.getSkill());
            int currentLevel = Experience.getLevelForXp((int)currentXP);
            int currentLevelXP = Experience.getXpForLevel((int)currentLevel);
            int nextLevelXP = currentLevel >= 126 ? 200000000 : Experience.getXpForLevel((int)(currentLevel + 1));
            int percent2 = (int)(Math.min(1.0, (double)(currentXP - currentLevelXP) / (double)(nextLevelXP - currentLevelXP)) * 100.0);
            GameEvent event2 = new GameEvent(TrackedStats.CURRENTSKILL, percent2);
            this.executePost("game_event ", event2.buildJson());
        }
    }

    private void sendEnergy() {
        GameEvent event = new GameEvent(TrackedStats.RUN_ENERGY, this.client.getEnergy());
        this.executePost("game_event ", event.buildJson());
    }

    private void sendSpecialAttackPercent() {
        GameEvent event = new GameEvent(TrackedStats.SPECIAL_ATTACK, this.client.getVar(300) / 10);
        this.executePost("game_event ", event.buildJson());
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.sendEnergy();
        this.sendSpecialAttackPercent();
    }

    private void FindSSE3Port() {
        String jsonAddressStr = "";
        Object corePropsFileName = OSType.getOSType().equals((Object)OSType.Windows) ? System.getenv("PROGRAMDATA") + "\\SteelSeries\\SteelSeries Engine 3\\coreProps.json" : "/Library/Application Support/SteelSeries Engine 3/coreProps.json";
        try {
            BufferedReader coreProps = new BufferedReader(new FileReader((String)corePropsFileName));
            jsonAddressStr = coreProps.readLine();
            System.out.println("Opened coreProps.json and read: " + jsonAddressStr);
            coreProps.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("coreProps.json not found");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Unhandled exception.");
        }
        if (!jsonAddressStr.equals("")) {
            SseAddressBuilder urlBuilder = new SseAddressBuilder(jsonAddressStr);
            this.sse3Address = urlBuilder.getUrl();
        }
    }

    private void gameRegister() {
        JsonObject object = new JsonObject();
        object.addProperty("game", game);
        object.addProperty("game_display_name", "Old School Runescape");
        object.addProperty("developer", "Gmoley");
        this.executePost("game_metadata", object);
    }

    private void registerStat(TrackedStats event, int IconId) {
        StatRegister statRegister = new StatRegister(event, 0, 100, IconId);
        this.executePost("register_game_event", statRegister.buildJson());
    }

    private void initGamesense() {
        this.gameRegister();
        this.registerStat(TrackedStats.HEALTH, 38);
        this.registerStat(TrackedStats.PRAYER, 40);
        this.registerStat(TrackedStats.CURRENTSKILL, 13);
        this.registerStat(TrackedStats.RUN_ENERGY, 16);
        this.registerStat(TrackedStats.SPECIAL_ATTACK, 0);
    }

    public void executePost(String extraAddress, JsonObject jsonData) {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonData.toString());
        Request request = new Request.Builder().url(this.sse3Address + "/" + extraAddress).post(body).build();
        Call call = this.okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            response.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

