/*
 * Decompiled with CFR 0.152.
 */
package com.GreatGuardianHider;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Renderable;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.Hooks;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Great Guardian Hider")
public class GreatGuardianHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GreatGuardianHiderPlugin.class);
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    private boolean hideNPCs;
    @Inject
    private Client client;
    @Inject
    private Hooks hooks;

    protected void startUp() {
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.hideNPCs = false;
    }

    protected void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        this.hideNPCs = inventory != null && (inventory.contains(26880) || inventory.contains(26881) || inventory.contains(26941));
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean Draw) {
        if (renderable instanceof NPC) {
            NPC npc = (NPC)renderable;
            int npcIdToHide = 11403;
            if (!this.hideNPCs && npc.getId() == npcIdToHide) {
                return false;
            }
        }
        return true;
    }
}

