/*
 * Decompiled with CFR 0.152.
 */
package com.aeimo.camdozaalfishing;

import com.aeimo.camdozaalfishing.CamdozaalFishingConfig;
import com.aeimo.camdozaalfishing.CamdozaalFishingOverlay;
import com.aeimo.camdozaalfishing.ColorTileObject;
import com.aeimo.camdozaalfishing.ObjectIndicatorsUtil;
import com.aeimo.camdozaalfishing.ObjectPoint;
import com.google.inject.Provides;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Camdozaal Fishing Helper", description="Visual indicators and alerts to simplify Camdozaal fishing", tags={"afk", "camdozaal", "f2p", "fishing", "prayer"})
public class CamdozaalFishingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CamdozaalFishingPlugin.class);
    private static final List<Integer> CAMDOZAAL_REGION_IDS = List.of(Integer.valueOf(11610), Integer.valueOf(11866), Integer.valueOf(12122));
    private static final int CAMDOZAAL_PLANE = 0;
    private static final int PREPARATION_TABLE_OBJECT_ID = 41545;
    private static final int OFFERING_TABLE_OBJECT_ID = 41546;
    static final ObjectPoint PREPARATION_TABLE = new ObjectPoint(41545, "Preparation Table", 11610, 56, 14, 0, Color.YELLOW);
    static final ObjectPoint ALTAR = new ObjectPoint(41546, "Altar", 11610, 58, 12, 0, Color.YELLOW);
    private static final int ANIMATION_ID_PREPARING = 896;
    private static final int ANIMATION_ID_OFFERING = 3705;
    private static final int ANIMATION_ID_FISHING = 621;
    private static final Integer[] ANIMATION_POSE_IDS_IDLE = new Integer[]{808, 813};
    private static final int TICKS_PER_PREPARE = 4;
    private static final int TICKS_PER_OFFER = 3;
    private static final int RAW_GUPPY = 25652;
    private static final int GUPPY = 25654;
    private static final int RAW_CAVEFISH = 25658;
    private static final int CAVEFISH = 25660;
    private static final int RAW_TETRA = 25664;
    private static final int TETRA = 25666;
    private static final Integer[] RAW_FISH = new Integer[]{25652, 25658, 25664};
    private static final Integer[] PREPARED_FISH = new Integer[]{25654, 25660, 25666};
    @Inject
    private CamdozaalFishingConfig config;
    @Inject
    private CamdozaalFishingOverlay overlay;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    private ObjectIndicatorsUtil objectIndicatorsUtil;
    private boolean withinCamdozaal;
    private CamdozaalFishingState currentPlayerState;
    private CamdozaalFishingState goalPlayerState;
    private PreviousAndCurrent<LocalPoint> playerLocationMemory;
    private final Map<Integer, PreviousAndCurrentInt> itemCountMemory = new HashMap<Integer, PreviousAndCurrentInt>();
    private Integer lastItemIncrease;
    private Integer lastItemDecrease;
    private int ticksSinceLastItemChange = 0;
    private final List<TrackedNPC> fishingSpots = new ArrayList<TrackedNPC>();
    private TrackedNPC closestFishingSpot;

    @Provides
    CamdozaalFishingConfig getConfig(ConfigManager configManager) {
        return (CamdozaalFishingConfig)configManager.getConfig(CamdozaalFishingConfig.class);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clearState();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.CONNECTION_LOST || gameState == GameState.LOGIN_SCREEN || gameState == GameState.HOPPING) {
            this.fishingSpots.clear();
        }
        this.objectIndicatorsUtil.onGameStateChanged(gameStateChanged);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        boolean nowWithinCamdozaal = this.checkWithinCamdozaal();
        if (this.withinCamdozaal && !nowWithinCamdozaal) {
            this.clearState();
        }
        this.withinCamdozaal = nowWithinCamdozaal;
        if (!this.withinCamdozaal) {
            return;
        }
        this.updateCountsOfItems();
        this.updatePlayerLocation();
        this.currentPlayerState = this.establishCurrentState();
        this.goalPlayerState = this.establishGoalState();
        this.pruneDeadAndProcessFishingSpots();
        this.recalculateClosestFishingSpot();
        this.isDoAlertFull();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (npc.getName() != null && !npc.getName().contains("Fishing spot")) {
            return;
        }
        this.fishingSpots.add(new TrackedNPC(npc, LocalDateTime.now(), npc.getWorldLocation(), LocalDateTime.now()));
        this.recalculateClosestFishingSpot();
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.fishingSpots.remove(npc);
        this.recalculateClosestFishingSpot();
    }

    public ColorTileObject getPreparationTable() {
        return this.objectIndicatorsUtil.getObjects().stream().filter(o -> o.getName().equals(PREPARATION_TABLE.getName())).findFirst().orElse(null);
    }

    public ColorTileObject getAltar() {
        return this.objectIndicatorsUtil.getObjects().stream().filter(o -> o.getName().equals(ALTAR.getName())).findFirst().orElse(null);
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.objectIndicatorsUtil.onWallObjectSpawned(event);
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.objectIndicatorsUtil.onWallObjectDespawned(event);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.objectIndicatorsUtil.onGameObjectSpawned(event);
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.objectIndicatorsUtil.onDecorativeObjectSpawned(event);
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.objectIndicatorsUtil.onGameObjectDespawned(event);
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.objectIndicatorsUtil.onDecorativeObjectDespawned(event);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.objectIndicatorsUtil.onGroundObjectSpawned(event);
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.objectIndicatorsUtil.onGroundObjectDespawned(event);
    }

    protected void startUp() {
        this.objectIndicatorsUtil = new ObjectIndicatorsUtil(this.client);
        this.overlayManager.add((Overlay)this.overlay);
        this.updatePlayerLocation();
    }

    protected boolean checkWithinCamdozaal() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        WorldPoint worldLocation = player.getWorldLocation();
        return CAMDOZAAL_REGION_IDS.contains(worldLocation.getRegionID()) && worldLocation.getPlane() == 0;
    }

    private void clearState() {
        this.fishingSpots.clear();
        this.itemCountMemory.clear();
        this.closestFishingSpot = null;
        this.currentPlayerState = null;
        this.goalPlayerState = null;
        this.playerLocationMemory = null;
        this.lastItemDecrease = null;
        this.lastItemIncrease = null;
        this.ticksSinceLastItemChange = 0;
    }

    protected boolean isDoAlertWeak() {
        if (!this.config.usePreEmptiveAlerts()) {
            return false;
        }
        if (this.userInteractingWithClient()) {
            return false;
        }
        int thresholdTicks = CamdozaalFishingPlugin.secondsToTicksRoundNearest((float)this.config.preEmptiveDelayMs() / 1000.0f);
        if (Arrays.asList(RAW_FISH).contains(this.lastItemDecrease) && (this.goalPlayerState == CamdozaalFishingState.PREPARE || this.goalPlayerState == CamdozaalFishingState.OFFER_PREEMPT) && this.meetsThresholdWithRemainderDelayOrExceeds(this.getItemCount(this.lastItemDecrease), thresholdTicks, 4)) {
            return true;
        }
        return Arrays.asList(PREPARED_FISH).contains(this.lastItemDecrease) && (this.goalPlayerState == CamdozaalFishingState.OFFER || this.goalPlayerState == CamdozaalFishingState.FISH_PREEMPT) && this.meetsThresholdWithRemainderDelayOrExceeds(this.getItemCount(this.lastItemDecrease), thresholdTicks, 3);
    }

    private boolean meetsThresholdWithRemainderDelayOrExceeds(int subject, int thresholdTicks, int actionTicks) {
        int ticksSinceLastAction = this.ticksSinceLastItemChange % actionTicks;
        int estimatedTicksLeft = actionTicks * subject - ticksSinceLastAction;
        return thresholdTicks >= estimatedTicksLeft;
    }

    protected boolean isDoAlertFull() {
        if (this.userInteractingWithClient()) {
            return false;
        }
        if (this.currentPlayerState != this.goalPlayerState && this.currentPlayerState != CamdozaalFishingState.MOVING) {
            return true;
        }
        return this.currentPlayerState == CamdozaalFishingState.INACTIVE;
    }

    protected boolean isHighlightPreparationTable() {
        return this.goalPlayerState == CamdozaalFishingState.PREPARE;
    }

    protected boolean isHighlightAltar() {
        return this.goalPlayerState == CamdozaalFishingState.OFFER || this.goalPlayerState == CamdozaalFishingState.OFFER_PREEMPT;
    }

    protected boolean isHighlightFishingSpot() {
        return this.goalPlayerState == CamdozaalFishingState.FISH || this.goalPlayerState == CamdozaalFishingState.FISH_PREEMPT;
    }

    private void updateCountsOfItems() {
        this.updateCountOfItem(25652);
        this.updateCountOfItem(25658);
        this.updateCountOfItem(25664);
        this.updateCountOfItem(25654);
        this.updateCountOfItem(25660);
        this.updateCountOfItem(25666);
        Integer maybeItemIncreased = this.determineLastItemChange(xva$0 -> this.anyItemsIncreased(xva$0));
        Integer maybeItemDecreased = this.determineLastItemChange(xva$0 -> this.anyItemsDecreased(xva$0));
        this.ticksSinceLastItemChange = maybeItemIncreased == null && maybeItemDecreased == null ? ++this.ticksSinceLastItemChange : 0;
        this.lastItemIncrease = this.orDefault(maybeItemIncreased, this.lastItemIncrease);
        this.lastItemDecrease = this.orDefault(maybeItemDecreased, this.lastItemDecrease);
    }

    private <T> T orDefault(T maybe, T defaultValue) {
        return maybe == null ? defaultValue : maybe;
    }

    private Integer determineLastItemChange(IntPredicate handler) {
        List decreasedItems = Stream.concat(Arrays.stream(RAW_FISH), Arrays.stream(PREPARED_FISH)).filter(handler::test).collect(Collectors.toList());
        if (!decreasedItems.isEmpty()) {
            if (decreasedItems.size() > 1) {
                log.error("Multiple tracked items changed in the same way: {}", decreasedItems);
            } else {
                return (Integer)decreasedItems.get(0);
            }
        }
        return null;
    }

    private void updatePlayerLocation() {
        LocalPoint playerLocation = this.client.getLocalDestinationLocation();
        if (this.playerLocationMemory == null) {
            this.playerLocationMemory = new PreviousAndCurrent<LocalPoint>(playerLocation);
        } else {
            this.playerLocationMemory.newData(playerLocation);
        }
    }

    private CamdozaalFishingState establishCurrentState() {
        Player player = this.client.getLocalPlayer();
        int animationId = player.getAnimation();
        LocalPoint playerLocation = player.getLocalLocation();
        if (animationId == 896 && playerLocation.distanceTo(this.getPreparationTable().getTileObject().getLocalLocation()) <= 143) {
            return CamdozaalFishingState.PREPARE;
        }
        if (animationId == 3705 && playerLocation.distanceTo(this.getPreparationTable().getTileObject().getLocalLocation()) <= 271) {
            return CamdozaalFishingState.OFFER;
        }
        if (animationId == 621 && playerLocation.distanceTo(this.getClosestFishingSpot().getNpc().getLocalLocation()) <= 128) {
            return CamdozaalFishingState.FISH;
        }
        if (this.playerLocationMemory.changed() || animationId != -1 || !this.arrayContains(ANIMATION_POSE_IDS_IDLE, player.getPoseAnimation())) {
            return CamdozaalFishingState.MOVING;
        }
        return CamdozaalFishingState.INACTIVE;
    }

    private <T> boolean arrayContains(T[] array, T item) {
        return Arrays.asList(array).contains(item);
    }

    private CamdozaalFishingState establishGoalState() {
        if (this.itemCountMemory.values().stream().filter(PreviousAndCurrent::changed).count() > 2L) {
            return CamdozaalFishingState.UNKNOWN;
        }
        if (this.getItemsCount(this.primIntArray(RAW_FISH)) == 0) {
            if (this.getItemsCount(this.primIntArray(PREPARED_FISH)) > 0) {
                if (this.isDoAlertWeak() && this.onlyOneItemTypeRemaining(this.primIntArray(PREPARED_FISH)) && this.getItemsCount(this.lastItemDecrease) > 0) {
                    return CamdozaalFishingState.FISH_PREEMPT;
                }
                return CamdozaalFishingState.OFFER;
            }
            return CamdozaalFishingState.FISH;
        }
        if (this.emptyInventorySlots() == 0 || this.getItemsCount(this.primIntArray(PREPARED_FISH)) > 0) {
            if (this.isDoAlertWeak() && this.onlyOneItemTypeRemaining(this.primIntArray(RAW_FISH)) && this.getItemsCount(this.lastItemDecrease) > 0) {
                return CamdozaalFishingState.OFFER_PREEMPT;
            }
            return CamdozaalFishingState.PREPARE;
        }
        return CamdozaalFishingState.FISH;
    }

    private boolean onlyOneItemTypeRemaining(int ... itemIds) {
        return Arrays.stream(itemIds).filter(i -> this.getItemsCount(i) > 0).boxed().count() <= 1L;
    }

    private int[] primIntArray(Integer[] objectArray) {
        return Arrays.stream(objectArray).mapToInt(obj -> obj).toArray();
    }

    private boolean userInteractingWithClient() {
        return this.client.getGameState() != GameState.LOGGED_IN || this.client.getLocalPlayer() == null || System.currentTimeMillis() - this.client.getMouseLastPressedMillis() < 1000L || this.client.getKeyboardIdleTicks() < 10;
    }

    private int getItemCount(int itemId) {
        return (Integer)this.itemCountMemory.get((Object)Integer.valueOf((int)itemId)).current;
    }

    private static int secondsToTicksRoundNearest(float seconds) {
        return (int)Math.round((double)seconds / 0.6);
    }

    public int getGlowBreathePeriod() {
        return this.config.glowSpeedMs();
    }

    public int getMaxBreatheIntensityPercent() {
        return this.config.maxBreatheIntensityPercent();
    }

    public Color getGlowColor() {
        return this.config.glowColor();
    }

    public Color getWeakGlowColor() {
        return this.config.weakGlowColor();
    }

    private int countOfItem(int itemId) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            return 0;
        }
        return (int)Arrays.stream(inventory.getItems()).filter(Objects::nonNull).filter(i -> i.getId() == itemId).count();
    }

    private int emptyInventorySlots() {
        return this.countOfItem(-1);
    }

    private void updateCountOfItem(int itemId) {
        int count = this.countOfItem(itemId);
        if (this.itemCountMemory.containsKey(itemId)) {
            this.itemCountMemory.get(itemId).newData(count);
        } else {
            this.itemCountMemory.put(itemId, new PreviousAndCurrentInt(count));
        }
    }

    private boolean anyItemsIncreased(int ... itemIds) {
        return Arrays.stream(itemIds).mapToObj(this.itemCountMemory::get).anyMatch(PreviousAndCurrentInt::increased);
    }

    private boolean anyItemsDecreased(int ... itemIds) {
        return Arrays.stream(itemIds).mapToObj(this.itemCountMemory::get).anyMatch(PreviousAndCurrentInt::decreased);
    }

    private int getItemsCount(int ... itemIds) {
        if (itemIds == null) {
            return 0;
        }
        return Arrays.stream(itemIds).mapToObj(this.itemCountMemory::get).mapToInt(PreviousAndCurrent::current).sum();
    }

    private void recalculateClosestFishingSpot() {
        this.closestFishingSpot = this.findClosestGameObject(this.fishingSpots, trackedNpc -> trackedNpc.getNpc().getLocalLocation());
    }

    private void pruneDeadAndProcessFishingSpots() {
        List toRemove = this.fishingSpots.stream().filter(trackedSpot -> {
            int[] models;
            NPC spot = trackedSpot.getNpc();
            boolean oddState = false;
            if (spot.isDead()) {
                oddState = true;
                System.out.println("Dead fishing spot");
            }
            if (spot.getComposition() != null && !spot.getComposition().isInteractible()) {
                oddState = true;
                System.out.println("Not interactible spot");
            }
            if (spot.getTransformedComposition() != null && !Arrays.equals(models = spot.getTransformedComposition().getModels(), new int[]{41967})) {
                System.out.printf("====== id: %s =====%n", spot.getLocalLocation());
                System.out.println("TX.C models: " + Arrays.toString(models));
            }
            if (spot.getComposition() != null && !Arrays.equals(models = spot.getComposition().getModels(), new int[]{41967})) {
                System.out.printf("====== id: %s =====%n", spot.getLocalLocation());
                System.out.println("C models: " + Arrays.toString(models));
            }
            if (spot.getOrientation() != 0 || spot.getCurrentOrientation() != 0) {
                System.out.printf("====== id: %s =====%n", spot.getLocalLocation());
                System.out.printf("Orientation: %s (C: %s)%n", spot.getOrientation(), spot.getCurrentOrientation());
            }
            return oddState;
        }).collect(Collectors.toList());
        this.fishingSpots.removeAll(toRemove);
        this.fishingSpots.forEach(spot -> {
            if (spot.getNpc().getWorldLocation() == null) {
                log.warn("Null world location on: {}", (Object)spot.getNpc());
            }
            if (!Objects.equals(spot.getLastLocation(), spot.getNpc().getWorldLocation())) {
                spot.setLastMoveDate(LocalDateTime.now());
                spot.setLastLocation(spot.getNpc().getWorldLocation());
            }
        });
    }

    private <T> T findClosestGameObject(List<T> gameObjects, Function<T, LocalPoint> locationHandler) {
        LocalPoint playerLoc = this.client.getLocalPlayer().getLocalLocation();
        return gameObjects.stream().min(Comparator.comparingInt(o -> ((LocalPoint)locationHandler.apply(o)).distanceTo(playerLoc))).orElse(null);
    }

    public boolean isWithinCamdozaal() {
        return this.withinCamdozaal;
    }

    public List<TrackedNPC> getFishingSpots() {
        return this.fishingSpots;
    }

    public TrackedNPC getClosestFishingSpot() {
        return this.closestFishingSpot;
    }

    static class PreviousAndCurrentInt
    extends PreviousAndCurrent<Integer> {
        PreviousAndCurrentInt(Integer initialValue) {
            super(initialValue);
        }

        boolean increased() {
            return this.current != null && this.previous != null && (Integer)this.current > (Integer)this.previous;
        }

        boolean decreased() {
            return this.current != null && this.previous != null && (Integer)this.previous > (Integer)this.current;
        }
    }

    static class PreviousAndCurrent<T> {
        T previous;
        T current;

        PreviousAndCurrent(T initialValue) {
            this.current = initialValue;
        }

        T current() {
            return this.current;
        }

        void newData(T data) {
            this.previous = this.current;
            this.current = data;
        }

        boolean changed() {
            return !Objects.equals(this.previous, this.current);
        }
    }

    static enum CamdozaalFishingState {
        FISH,
        FISH_PREEMPT,
        PREPARE,
        OFFER,
        OFFER_PREEMPT,
        MOVING,
        INACTIVE,
        UNKNOWN;

    }

    static class TrackedNPC {
        NPC npc;
        LocalDateTime instantiationDate;
        WorldPoint lastLocation;
        LocalDateTime lastMoveDate;

        public NPC getNpc() {
            return this.npc;
        }

        public LocalDateTime getInstantiationDate() {
            return this.instantiationDate;
        }

        public WorldPoint getLastLocation() {
            return this.lastLocation;
        }

        public LocalDateTime getLastMoveDate() {
            return this.lastMoveDate;
        }

        public void setNpc(NPC npc) {
            this.npc = npc;
        }

        public void setInstantiationDate(LocalDateTime instantiationDate) {
            this.instantiationDate = instantiationDate;
        }

        public void setLastLocation(WorldPoint lastLocation) {
            this.lastLocation = lastLocation;
        }

        public void setLastMoveDate(LocalDateTime lastMoveDate) {
            this.lastMoveDate = lastMoveDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrackedNPC)) {
                return false;
            }
            TrackedNPC other = (TrackedNPC)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NPC this$npc = this.getNpc();
            NPC other$npc = other.getNpc();
            if (this$npc == null ? other$npc != null : !this$npc.equals(other$npc)) {
                return false;
            }
            LocalDateTime this$instantiationDate = this.getInstantiationDate();
            LocalDateTime other$instantiationDate = other.getInstantiationDate();
            if (this$instantiationDate == null ? other$instantiationDate != null : !((Object)this$instantiationDate).equals(other$instantiationDate)) {
                return false;
            }
            WorldPoint this$lastLocation = this.getLastLocation();
            WorldPoint other$lastLocation = other.getLastLocation();
            if (this$lastLocation == null ? other$lastLocation != null : !this$lastLocation.equals(other$lastLocation)) {
                return false;
            }
            LocalDateTime this$lastMoveDate = this.getLastMoveDate();
            LocalDateTime other$lastMoveDate = other.getLastMoveDate();
            return !(this$lastMoveDate == null ? other$lastMoveDate != null : !((Object)this$lastMoveDate).equals(other$lastMoveDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TrackedNPC;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NPC $npc = this.getNpc();
            result = result * 59 + ($npc == null ? 43 : $npc.hashCode());
            LocalDateTime $instantiationDate = this.getInstantiationDate();
            result = result * 59 + ($instantiationDate == null ? 43 : ((Object)$instantiationDate).hashCode());
            WorldPoint $lastLocation = this.getLastLocation();
            result = result * 59 + ($lastLocation == null ? 43 : $lastLocation.hashCode());
            LocalDateTime $lastMoveDate = this.getLastMoveDate();
            result = result * 59 + ($lastMoveDate == null ? 43 : ((Object)$lastMoveDate).hashCode());
            return result;
        }

        public String toString() {
            return "CamdozaalFishingPlugin.TrackedNPC(npc=" + this.getNpc() + ", instantiationDate=" + this.getInstantiationDate() + ", lastLocation=" + this.getLastLocation() + ", lastMoveDate=" + this.getLastMoveDate() + ")";
        }

        public TrackedNPC(NPC npc, LocalDateTime instantiationDate, WorldPoint lastLocation, LocalDateTime lastMoveDate) {
            this.npc = npc;
            this.instantiationDate = instantiationDate;
            this.lastLocation = lastLocation;
            this.lastMoveDate = lastMoveDate;
        }
    }
}

