/*
 * Decompiled with CFR 0.152.
 */
package com.aeimo.camdozaalfishing;

import com.aeimo.camdozaalfishing.CamdozaalFishingPlugin;
import com.aeimo.camdozaalfishing.ColorTileObject;
import com.google.common.base.Strings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.TileObject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

public class CamdozaalFishingOverlay
extends Overlay {
    private static final int MAX_BRIGHTNESS_ALPHA_LEVEL = 255;
    @Inject
    private CamdozaalFishingPlugin plugin;
    @Inject
    private Client client;
    private boolean isRenderingAlertAnimation = false;
    private static final Integer BORDER_WIDTH = 8;

    @Inject
    private CamdozaalFishingOverlay(Client client, CamdozaalFishingPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isWithinCamdozaal()) {
            return null;
        }
        BasicStroke stroke = new BasicStroke(BORDER_WIDTH.intValue());
        if (this.plugin.isHighlightAltar()) {
            this.renderColorTileObject(graphics, this.plugin.getAltar(), stroke);
        }
        if (this.plugin.isHighlightPreparationTable()) {
            this.renderColorTileObject(graphics, this.plugin.getPreparationTable(), stroke);
        }
        CamdozaalFishingPlugin.TrackedNPC closestFishingSpot = this.plugin.getClosestFishingSpot();
        this.plugin.getFishingSpots().forEach(spot -> {
            Color closestHighlightColor = this.plugin.isHighlightFishingSpot() ? Color.YELLOW : Color.BLUE;
            this.highlightFishingSpot(graphics, (CamdozaalFishingPlugin.TrackedNPC)spot, spot == closestFishingSpot ? closestHighlightColor : Color.BLACK);
        });
        boolean fullAlert = this.plugin.isDoAlertFull();
        if (fullAlert || this.plugin.isDoAlertWeak()) {
            Color glowColor = fullAlert ? this.plugin.getGlowColor() : this.plugin.getWeakGlowColor();
            graphics.setColor(new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), this.getBreathingAlpha(this.plugin.getGlowBreathePeriod(), fullAlert ? 1.0f : 0.5f)));
            graphics.fill(this.getGameWindowRectangle());
        } else {
            this.isRenderingAlertAnimation = false;
        }
        return null;
    }

    private void highlightFishingSpot(Graphics2D graphics, CamdozaalFishingPlugin.TrackedNPC trackedFishingSpot, Color highlightColor) {
        NPC spotNPC = trackedFishingSpot.getNpc();
        Polygon poly = spotNPC.getCanvasTilePoly();
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)highlightColor);
        }
    }

    private void renderColorTileObject(Graphics2D graphics, ColorTileObject colorTileObject, Stroke stroke) {
        TileObject object = colorTileObject.getTileObject();
        Color color = colorTileObject.getColor();
        if (object.getPlane() != this.client.getPlane()) {
            return;
        }
        ObjectComposition composition = colorTileObject.getComposition();
        if (composition.getImpostorIds() != null && ((composition = composition.getImpostor()) == null || Strings.isNullOrEmpty((String)composition.getName()) || "null".equals(composition.getName()) || !composition.getName().equals(colorTileObject.getName()))) {
            return;
        }
        Shape clickBox = object.getClickbox();
        if (clickBox != null) {
            Color clickBoxColor = ColorUtil.colorWithAlpha((Color)color, (int)(color.getAlpha() / 12));
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)clickBox, (Color)color, (Color)clickBoxColor, (Stroke)stroke);
        }
    }

    private Rectangle getGameWindowRectangle() {
        Dimension clientCanvasSize = this.client.getCanvas().getSize();
        Point clientCanvasLocation = this.client.getCanvas().getLocation();
        Point adjustedLocation = new Point(clientCanvasLocation.x - 5, clientCanvasLocation.y - 20);
        return new Rectangle(adjustedLocation, clientCanvasSize);
    }

    private int getBreathingAlpha(int breathePeriodMillis, float intensityModifier) {
        double currentMillisOffset = System.currentTimeMillis() % (long)breathePeriodMillis;
        double fractionCycleComplete = currentMillisOffset / (double)breathePeriodMillis;
        int maxIntensityPc = (int)((float)this.plugin.getMaxBreatheIntensityPercent() * intensityModifier);
        double fractionAlpha = Math.sin(fractionCycleComplete * 2.0 * Math.PI);
        double fractionAlphaPositive = (fractionAlpha + 1.0) / 2.0;
        if (this.isRenderingAlertAnimation || fractionAlphaPositive < 0.025) {
            this.isRenderingAlertAnimation = true;
            return (int)(fractionAlphaPositive * 255.0 * ((double)maxIntensityPc / 100.0));
        }
        return 0;
    }
}

