/*
 * Decompiled with CFR 0.152.
 */
package com.aeimo.camdozaalfishing;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="camdozaalfishing")
public interface CamdozaalFishingConfig
extends Config {
    public static final int DEFAULT_GLOW_BREATHE_PERIOD_MS = 1000;
    public static final int DEFAULT_PRE_EMPTIVE_DELAY_MS = 1200;
    public static final int DEFAULT_MAX_GLOW_BREATHE_INTENSITY = 60;
    public static final Color DEFAULT_GLOW_COLOR = new Color(255, 0, 0);
    public static final Color DEFAULT_WEAK_GLOW_COLOR = new Color(255, 192, 0);

    @ConfigItem(name="Glow speed (ms)", keyName="glowSpeedMs", description="How long between cycles of min and max brightness of the glow effect", position=1)
    @Units(value="ms")
    default public int glowSpeedMs() {
        return 1000;
    }

    @ConfigItem(name="Max glow intensity", keyName="maxBreatheIntensityPercent", description="Max intensity of glow effect (100% is opaque)", position=2)
    @Units(value="%")
    @Range(min=10, max=100)
    default public int maxBreatheIntensityPercent() {
        return 60;
    }

    @Alpha
    @ConfigItem(position=3, keyName="glowColor", name="Glow color", description="The color of the main glow effect")
    default public Color glowColor() {
        return DEFAULT_GLOW_COLOR;
    }

    @ConfigItem(keyName="usePreEmptiveAlerts", name="Whether to use pre-emptive alerts", description="If enabled, will give a weaker alert right before a task is complete", position=4)
    default public boolean usePreEmptiveAlerts() {
        return false;
    }

    @ConfigItem(name="Pre-emptive alert advance warning (ms)", keyName="preEmptiveDelayMs", description="How long before a task is done to start the pre-emptive alert (ms)", position=5)
    @Units(value="ms")
    default public int preEmptiveDelayMs() {
        return 1200;
    }

    @Alpha
    @ConfigItem(position=6, keyName="weakGlowColor", name="Weak glow color", description="The color of the glow effect used in pre-emptive alerts")
    default public Color weakGlowColor() {
        return DEFAULT_WEAK_GLOW_COLOR;
    }
}

