/*
 * Decompiled with CFR 0.152.
 */
package de.furkan.voicescape;

import com.google.gson.Gson;
import com.google.inject.Provides;
import de.furkan.voicescape.VoiceEngine;
import de.furkan.voicescape.VoicePacket;
import de.furkan.voicescape.VoicePlaybackThread;
import de.furkan.voicescape.VoiceScapeConfig;
import de.furkan.voicescape.VoiceScapeNetworkOverlay;
import de.furkan.voicescape.VoiceScapeOverlay;
import java.awt.event.KeyEvent;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="VoiceScape")
public class VoiceScapePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VoiceScapePlugin.class);
    private final HashMap<String, String> nameHashes = new HashMap();
    @Inject
    public Client client;
    @Inject
    public Gson gson;
    @Inject
    public VoiceScapeConfig config;
    public boolean canSpeak = false;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.pushToTalkBind()){

        public void keyPressed(KeyEvent e) {
            VoiceScapePlugin.this.canSpeak = true;
        }

        public void keyReleased(KeyEvent e) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    VoiceScapePlugin.this.canSpeak = false;
                }
            }, 1000L);
        }
    };
    public boolean droppingPacket = true;
    public HashMap<String, VoicePlaybackThread> playbackThreads = new HashMap();
    public VoiceScapeOverlay voiceScapeOverlay;
    public VoiceScapeNetworkOverlay voiceScapeNetworkOverlay;
    public VoiceEngine voiceEngine;
    public List<String> registeredPlayers = new ArrayList<String>();
    public List<String> mutedPlayers = new ArrayList<String>();
    public List<String> unmutedPlayers = new ArrayList<String>();
    @Inject
    public MenuManager menuManager;
    public long pingInMs = 0L;
    @Inject
    OverlayManager overlayManager;
    @Inject
    KeyManager keyManager;
    boolean isLoggedIn = false;
    private long lastPacketReceived = 0L;

    protected void startUp() throws Exception {
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            this.initializePlugin();
        }
    }

    private void initializePlugin() {
        if (this.voiceEngine != null) {
            return;
        }
        System.out.println("Initializing VoiceScape plugin");
        this.voiceEngine = new VoiceEngine(this);
        this.voiceEngine.openConnection();
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
        this.voiceScapeOverlay = new VoiceScapeOverlay(this);
        this.overlayManager.add((Overlay)this.voiceScapeOverlay);
        this.voiceScapeNetworkOverlay = new VoiceScapeNetworkOverlay(this);
        this.overlayManager.add((Overlay)this.voiceScapeNetworkOverlay);
        System.out.println("VoiceScape plugin initialized");
    }

    private void shutdownPlugin() {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.overlayManager.remove((Overlay)this.voiceScapeOverlay);
        this.overlayManager.remove((Overlay)this.voiceScapeNetworkOverlay);
        this.playbackThreads.forEach((s, voicePlaybackThread) -> {
            voicePlaybackThread.audioDataList.clear();
            voicePlaybackThread.playbackThread.interrupt();
        });
        this.playbackThreads.clear();
        if (this.voiceEngine != null) {
            this.voiceEngine.close();
            this.voiceEngine = null;
        }
        this.registeredPlayers.clear();
        this.isLoggedIn = false;
        this.pingInMs = 0L;
        this.droppingPacket = false;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (menuOptionClicked.getMenuTarget().contains(">") && menuOptionClicked.getMenuTarget().contains("<")) {
            String playerName = menuOptionClicked.getMenuTarget().split(">")[1].split("<")[0];
            playerName = playerName.replaceAll(" ", " ");
            if (menuOptionClicked.getMenuOption().equals(" Mute") && !this.mutedPlayers.contains(this.hashWithSha256(playerName))) {
                this.mutedPlayers.add(this.hashWithSha256(playerName));
                this.unmutedPlayers.remove(this.hashWithSha256(playerName));
            } else if (menuOptionClicked.getMenuOption().equals(" Un-mute")) {
                this.mutedPlayers.remove(this.hashWithSha256(playerName));
                this.unmutedPlayers.add(this.hashWithSha256(playerName));
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && !this.isLoggedIn) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    VoiceScapePlugin.this.initializePlugin();
                }
            }, 3000L);
            this.isLoggedIn = true;
        } else if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.CONNECTION_LOST || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.shutdownPlugin();
            this.isLoggedIn = false;
        }
    }

    protected void shutDown() throws Exception {
        this.shutdownPlugin();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getKey().equals("loopback") && this.client.getGameState() == GameState.LOGGED_IN) {
            if (this.config.loopBack()) {
                this.registeredPlayers.add(this.hashWithSha256(this.client.getLocalPlayer().getName()));
            } else {
                this.registeredPlayers.remove(this.hashWithSha256(this.client.getLocalPlayer().getName()));
            }
        } else if (configChanged.getKey().equals("lowbuffer") && this.voiceEngine != null || configChanged.getKey().equals("servertype")) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "You need to re-enable the plugin for this change to take effect."));
        }
    }

    public void onRawMessageReceived(String message) {
        if (this.lastPacketReceived != 0L) {
            this.pingInMs = System.currentTimeMillis() - this.lastPacketReceived;
        }
        this.lastPacketReceived = System.currentTimeMillis();
        try {
            if (message.startsWith("delete#")) {
                if (message.split("#")[1].equals(this.client.getLocalPlayer().getName())) {
                    return;
                }
                this.registeredPlayers.remove(message.split("#")[1]);
                return;
            }
            if (message.startsWith("register#")) {
                if (message.split("#")[1].equals(this.client.getLocalPlayer().getName())) {
                    return;
                }
                this.registeredPlayers.add(message.split("#")[1]);
                return;
            }
            VoicePacket voicePacket = this.gson.fromJson(message, VoicePacket.class);
            if (voicePacket == null || voicePacket.audioData == null || voicePacket.audioData.length == 0) {
                return;
            }
            if (!this.config.loopBack() && voicePacket.senderNameHashed.equals(this.hashWithSha256(this.client.getLocalPlayer().getName()))) {
                return;
            }
            if (!this.registeredPlayers.contains(voicePacket.senderNameHashed)) {
                this.registeredPlayers.add(voicePacket.senderNameHashed);
            }
            if (this.config.muteAll() && !this.unmutedPlayers.contains(voicePacket.senderNameHashed)) {
                return;
            }
            if (this.mutedPlayers.contains(voicePacket.senderNameHashed)) {
                return;
            }
            boolean isInSurroundingArea = false;
            Player sender = null;
            for (Player player : this.client.getPlayers()) {
                String hashedName = this.hashWithSha256(player.getName());
                if (!hashedName.equals(voicePacket.senderNameHashed)) continue;
                sender = player;
                isInSurroundingArea = true;
                break;
            }
            if (isInSurroundingArea) {
                if (System.currentTimeMillis() - voicePacket.timeCreated > (long)this.config.maxPacketAge()) {
                    this.droppingPacket = true;
                    return;
                }
                this.droppingPacket = false;
                int distanceToSender = this.client.getLocalPlayer().getWorldLocation().distanceTo(sender.getWorldLocation());
                float volume = 1.0f - (float)distanceToSender / (float)this.config.minDistance();
                if (!this.playbackThreads.containsKey(voicePacket.senderNameHashed)) {
                    this.playbackThreads.put(voicePacket.senderNameHashed, new VoicePlaybackThread(this, voicePacket.senderNameHashed));
                }
                VoicePlaybackThread playbackThread = this.playbackThreads.get(voicePacket.senderNameHashed);
                if (!this.config.altPlay()) {
                    playbackThread.audioDataList.put(voicePacket.audioData, Float.valueOf(volume));
                } else {
                    playbackThread.audioDataList.clear();
                    playbackThread.playAudio(voicePacket.audioData, volume);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String hashWithSha256(String base) {
        if (base == null) {
            return "";
        }
        if (this.nameHashes.containsKey(base)) {
            return this.nameHashes.get(base);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            this.nameHashes.put(base, hexString.toString());
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Provides
    VoiceScapeConfig provideConfig(ConfigManager configManager) {
        return (VoiceScapeConfig)configManager.getConfig(VoiceScapeConfig.class);
    }
}

