/*
 * Decompiled with CFR 0.152.
 */
package de.furkan.voicescape;

import de.furkan.voicescape.VoiceScapeConfig;
import de.furkan.voicescape.VoiceScapePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class VoiceScapeOverlay
extends Overlay {
    private final VoiceScapePlugin voiceScapePlugin;
    public String currentLine = "";

    public VoiceScapeOverlay(VoiceScapePlugin voiceScapePlugin) {
        this.voiceScapePlugin = voiceScapePlugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.voiceScapePlugin.config.connectionIndicator() && this.currentLine.isEmpty()) {
            for (Player player : this.voiceScapePlugin.client.getPlayers()) {
                if (player.getName() == null || this.voiceScapePlugin.client.getLocalPlayer().getWorldLocation().distanceTo(player.getWorldLocation()) > this.voiceScapePlugin.config.indicatorDistance() || !this.voiceScapePlugin.registeredPlayers.contains(this.voiceScapePlugin.hashWithSha256(player.getName()))) continue;
                if ((this.voiceScapePlugin.mutedPlayers.contains(this.voiceScapePlugin.hashWithSha256(player.getName())) || this.voiceScapePlugin.config.muteAll() && !this.voiceScapePlugin.unmutedPlayers.contains(this.voiceScapePlugin.hashWithSha256(player.getName())) && !player.getName().equals(this.voiceScapePlugin.client.getLocalPlayer().getName())) && this.voiceScapePlugin.config.showMuteIndicator()) {
                    String a = "Muted " + player.getName();
                    int stringLength = graphics.getFontMetrics().stringWidth(a) - 40;
                    Point textLocation = player.getCanvasTextLocation(graphics, player.getName(), player.getLogicalHeight() + 50);
                    if (textLocation == null) {
                        return null;
                    }
                    textLocation = new Point(textLocation.getX() - stringLength / 2, textLocation.getY());
                    OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)a, (Color)this.voiceScapePlugin.config.indicatorColor());
                }
                if (player.getName().equals(this.voiceScapePlugin.client.getLocalPlayer().getName())) continue;
                if (this.voiceScapePlugin.config.indicatorType() == VoiceScapeConfig.INDICATION_TYPE.STRING) {
                    this.renderString(graphics, player);
                    continue;
                }
                if (this.voiceScapePlugin.config.indicatorType() == VoiceScapeConfig.INDICATION_TYPE.TILE) {
                    this.renderTile(graphics, player);
                    continue;
                }
                if (this.voiceScapePlugin.config.indicatorType() != VoiceScapeConfig.INDICATION_TYPE.BOTH) continue;
                this.renderString(graphics, player);
                this.renderTile(graphics, player);
            }
        } else if (!this.currentLine.equals("")) {
            int stringLength = graphics.getFontMetrics().stringWidth(this.currentLine) - 40;
            Point textLocation = this.voiceScapePlugin.client.getLocalPlayer().getCanvasTextLocation(graphics, this.voiceScapePlugin.client.getLocalPlayer().getName(), this.voiceScapePlugin.client.getLocalPlayer().getLogicalHeight() + 20);
            if (textLocation == null) {
                return null;
            }
            textLocation = new Point(textLocation.getX() - stringLength / 2, textLocation.getY());
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)this.currentLine, (Color)Color.YELLOW);
        }
        return null;
    }

    private void renderString(Graphics2D graphics, Player player) {
        Point textLocation = player.getCanvasTextLocation(graphics, player.getName(), player.getLogicalHeight() + 20);
        if (textLocation != null) {
            String indicatorText = this.voiceScapePlugin.config.indicatorString();
            indicatorText = indicatorText.replace("%p", player.getName());
            int stringLength = graphics.getFontMetrics().stringWidth(indicatorText) - 40;
            textLocation = new Point(textLocation.getX() - stringLength / 2, textLocation.getY());
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)indicatorText, (Color)this.voiceScapePlugin.config.indicatorColor());
        }
    }

    private void renderTile(Graphics2D graphics, Player player) {
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)player.getCanvasTilePoly(), (Color)this.voiceScapePlugin.config.indicatorColor());
    }
}

