/*
 * Decompiled with CFR 0.152.
 */
package de.furkan.voicescape;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="VoiceScape")
public interface VoiceScapeConfig
extends Config {
    @ConfigSection(name="Voice Chat", description="Voice settings", position=1)
    public static final String voiceSection = "voice";
    @ConfigSection(name="Indicator", description="Connection indicator settings", position=2, closedByDefault=true)
    public static final String indicatorSection = "indicator";
    @ConfigSection(name="Server", description="Server settings", position=0, closedByDefault=true)
    public static final String serverSection = "Server";
    @ConfigSection(name="Advanced", description="Advanced settings", position=3, closedByDefault=true)
    public static final String advancedSection = "Advanced";

    @ConfigItem(keyName="muteself", name="Mute Self", description="Mute yourself", section="voice", position=1)
    default public boolean muteSelf() {
        return false;
    }

    @ConfigItem(keyName="muteall", name="Mute Everyone", description="Mute everyone until you unmute them", section="voice", position=2)
    default public boolean muteAll() {
        return true;
    }

    @Range(min=5, max=15)
    @ConfigItem(keyName="distance", name="Min Distance", description="Minimum distance to hear other players", section="voice", position=3)
    default public int minDistance() {
        return 15;
    }

    @ConfigItem(keyName="pushtotalk", name="Push-To-Talk", description="If enabled, you have to hold a key to talk", section="voice", position=4)
    default public boolean pushToTalk() {
        return true;
    }

    @ConfigItem(keyName="pushtotalkkey", name="Push-To-Talk Keybind", description="The keybind to use for push-to-talk", section="voice", position=5)
    default public Keybind pushToTalkBind() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(keyName="loopback", name="Loopback", description="If enabled, you will hear yourself", section="voice", position=6)
    default public boolean loopBack() {
        return false;
    }

    @ConfigItem(keyName="servertype", name="Server Type", description="Use Default to connect to the official server, or Custom to connect to a custom server", section="Server", position=2)
    default public SERVER_TYPE serverType() {
        return SERVER_TYPE.NONE;
    }

    @ConfigItem(keyName=" ", name=" ", description=" ", section="Server", position=4)
    default public Long spacer() {
        return 2L;
    }

    @ConfigItem(keyName="customserveripandport", name="Custom Server (IP:Port)", description="The IP and port of the custom server", position=7, section="Server")
    default public String customServerIPAndPort() {
        return "127.0.0.1:1234";
    }

    @ConfigItem(keyName="customserverpassword", name="Custom Server Password (Optional)", description="The password of the custom server", position=10, section="Server")
    default public String customServerPassword() {
        return "";
    }

    @ConfigItem(keyName="customserverusername", name="Custom Server Username (Optional)", description="The username of the custom server", position=9, section="Server")
    default public String customServerUsername() {
        return "";
    }

    @ConfigItem(keyName="showwhoisconnected", name="Show connection indicator", description="Show who is connected to the voice chat", section="indicator", position=0)
    default public boolean connectionIndicator() {
        return true;
    }

    @ConfigItem(keyName="showmuteindicator", name="Show mute indicator", description="Show the mute indicator", section="indicator", position=2)
    default public boolean showMuteIndicator() {
        return true;
    }

    @ConfigItem(keyName="indicatortype", name="Indicator Type", description="The type of the indicator", section="indicator", position=3)
    default public INDICATION_TYPE indicatorType() {
        return INDICATION_TYPE.TILE;
    }

    @ConfigItem(keyName="indicatorstring", name="Indicator String", description="The string that will be shown as the indicator", section="indicator", position=5)
    default public String indicatorString() {
        return "Connected [%p]";
    }

    @ConfigItem(keyName="indicatorcolor", name="Indicator Color", description="The color of the indicator", section="indicator", position=6)
    default public Color indicatorColor() {
        return Color.YELLOW;
    }

    @Range(min=2, max=30)
    @ConfigItem(keyName="indicatordistance", name="Indicator Distance", description="Minimum distance to show the indicator", section="indicator", position=4)
    default public int indicatorDistance() {
        return 5;
    }

    @ConfigItem(keyName="lowbuffer", name="Low Capture Buffer", description="This will reduce latency when sending voice but can cause your voice sounding choppy.", section="Advanced", position=0)
    default public boolean lowCaptureBuffer() {
        return false;
    }

    @ConfigItem(keyName="altplay", name="Alternative Playback", description="This can cause a lot of packet loss if you have a high ping but reduces latency.", section="Advanced", position=1)
    default public boolean altPlay() {
        return false;
    }

    @Range(min=1500, max=10000)
    @Units(value="ms")
    @ConfigItem(keyName="packetage", name="Max packet age", description="The value in milliseconds a voice packet can be old before it gets dropped on receive. A lower value reduces latency but can drop every voice packet if you have a high ping.", section="Advanced", position=2)
    default public int maxPacketAge() {
        return 2000;
    }

    @ConfigItem(keyName="shownetworkovleray", name="Show network overlay", description="Shows a overlay of network information like your ping or packet drops etc.", section="Advanced", position=3)
    default public boolean showNetworkOverlay() {
        return false;
    }

    public static enum SERVER_TYPE {
        DEFAULT,
        CUSTOM,
        NONE;

    }

    public static enum INDICATION_TYPE {
        STRING,
        TILE,
        BOTH;

    }
}

