/*
 * Decompiled with CFR 0.152.
 */
package de.furkan.voicescape;

import de.furkan.voicescape.VoiceScapePlugin;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class VoicePlaybackThread
extends Thread {
    public final Thread playbackThread;
    public final HashMap<byte[], Float> audioDataList = new HashMap();
    private final String identifier;
    public VoiceScapePlugin voiceScapePlugin;
    Clip currentClip;

    public VoicePlaybackThread(VoiceScapePlugin voiceScapePlugin, String identifier) {
        this.playbackThread = new Thread((Runnable)this, "VoicePlaybackThread");
        this.voiceScapePlugin = voiceScapePlugin;
        this.identifier = identifier;
        this.playbackThread.start();
    }

    AudioFormat getAudioFormat() {
        return new AudioFormat(44100.0f, 16, 1, true, false);
    }

    public void playAudio(byte[] audioData, float volume) {
        try {
            this.currentClip = AudioSystem.getClip();
            this.currentClip.open(this.getAudioFormat(), audioData, 0, audioData.length);
            FloatControl volumeControl = (FloatControl)this.currentClip.getControl(FloatControl.Type.MASTER_GAIN);
            volumeControl.setValue(20.0f * (float)Math.log10(volume));
            this.currentClip.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            SourceDataLine line = AudioSystem.getSourceDataLine(this.getAudioFormat());
            line.open(this.getAudioFormat());
            line.start();
            while (this.playbackThread != null && !this.playbackThread.isInterrupted() && this.voiceScapePlugin.voiceEngine != null && this.voiceScapePlugin.registeredPlayers.contains(this.identifier)) {
                if (this.voiceScapePlugin.config.altPlay()) continue;
                new HashMap<byte[], Float>(this.audioDataList).forEach((bytes, aFloat) -> {
                    FloatControl volumeControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                    volumeControl.setValue(20.0f * (float)Math.log10(aFloat.floatValue()));
                    line.write((byte[])bytes, 0, ((byte[])bytes).length);
                    this.audioDataList.remove(bytes);
                });
            }
            this.audioDataList.clear();
            line.drain();
            line.close();
            this.voiceScapePlugin.playbackThreads.remove(this.identifier);
            this.playbackThread.interrupt();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

