/*
 * Decompiled with CFR 0.152.
 */
package de.furkan.voicescape;

import de.furkan.voicescape.RedisPool;
import de.furkan.voicescape.VoicePacket;
import de.furkan.voicescape.VoiceScapeConfig;
import de.furkan.voicescape.VoiceScapePlugin;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class VoiceEngine {
    private final VoiceScapePlugin voiceScapePlugin;
    public Jedis jedisSub;
    public Jedis jedisPub;
    TargetDataLine microphone;
    Thread microphoneCaptureThread;
    Thread subscribeThread;
    private JedisPubSub jedisPubSub;

    public VoiceEngine(VoiceScapePlugin voiceScapePlugin) {
        this.voiceScapePlugin = voiceScapePlugin;
    }

    AudioFormat getAudioFormat() {
        return new AudioFormat(44100.0f, 16, 1, true, false);
    }

    public void listenToChannel() {
        if (this.subscribeThread != null) {
            this.subscribeThread.interrupt();
        }
        if (this.jedisSub == null) {
            return;
        }
        if (this.jedisPubSub.isSubscribed()) {
            this.jedisPubSub.unsubscribe();
        }
        this.subscribeThread = new Thread(() -> {
            block3: {
                if (this.voiceScapePlugin.client.getGameState() != GameState.LOGGED_IN) {
                    return;
                }
                try {
                    this.jedisSub.subscribe(this.jedisPubSub, String.valueOf(this.voiceScapePlugin.client.getWorld()));
                }
                catch (Exception e) {
                    if (this.subscribeThread == null) break block3;
                    this.subscribeThread.interrupt();
                }
            }
        });
        this.subscribeThread.start();
    }

    public void openConnection() {
        String ipAndPort = "";
        String redisPassword = this.voiceScapePlugin.config.customServerPassword();
        String redisUsername = this.voiceScapePlugin.config.customServerUsername();
        if (this.voiceScapePlugin.config.serverType() == VoiceScapeConfig.SERVER_TYPE.DEFAULT) {
            ipAndPort = "containers-us-west-176.railway.app:7525";
            redisUsername = "VoiceScapeUser";
            redisPassword = "HYpKxaZs6RbrH71MQfJwzj";
        } else if (this.voiceScapePlugin.config.serverType() == VoiceScapeConfig.SERVER_TYPE.CUSTOM) {
            ipAndPort = this.voiceScapePlugin.config.customServerIPAndPort();
        } else if (this.voiceScapePlugin.config.serverType() == VoiceScapeConfig.SERVER_TYPE.NONE) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Please select a server type in the configuration!", "VoiceScape - Server type error", 0));
            return;
        }
        if (!ipAndPort.contains(":") || !ipAndPort.split(":")[1].matches("[0-9]+")) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "The server ip and port is not in the correct format! It should be \"STRING:NUMBER\". Example: \"localhost:6379\"\n\nTo Reconnect re-enable the plugin.", "VoiceScape - Format error", 0));
            return;
        }
        String redisHost = ipAndPort.split(":")[0];
        int redisPort = Integer.parseInt(ipAndPort.split(":")[1]);
        try {
            RedisPool jedisPool = redisPassword.isEmpty() && redisUsername.isEmpty() ? new RedisPool(2, redisHost, redisPort) : new RedisPool(2, redisHost, redisPort, redisUsername, redisPassword);
            this.jedisSub = jedisPool.getResource();
            this.jedisPub = jedisPool.getResource();
            this.voiceScapePlugin.menuManager.addPlayerMenuItem(" Mute");
            this.voiceScapePlugin.menuManager.addPlayerMenuItem(" Un-mute");
            if (this.jedisPubSub != null) {
                this.jedisPubSub.unsubscribe();
            }
            this.jedisPubSub = new JedisPubSub(){

                @Override
                public void onMessage(String channel, String message) {
                    if (VoiceEngine.this.voiceScapePlugin.client.getGameState() != GameState.LOGGED_IN) {
                        return;
                    }
                    if (channel.equals(String.valueOf(VoiceEngine.this.voiceScapePlugin.client.getWorld()))) {
                        VoiceEngine.this.voiceScapePlugin.onRawMessageReceived(message);
                    }
                }
            };
            if (this.voiceScapePlugin.config.loopBack()) {
                this.voiceScapePlugin.registeredPlayers.add(this.voiceScapePlugin.hashWithSha256(this.voiceScapePlugin.client.getLocalPlayer().getName()));
            }
            this.listenToChannel();
            this.startMicrophoneCapture();
            this.requestRegistration();
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Could not connect to VoiceScape servers!\nPlease check your configuration.\n\n" + e.getMessage() + "\n\nTo Reconnect re-enable the plugin.", "VoiceScape - Connection error", 0));
        }
    }

    public void sendRawMessage(String message) {
        if (this.jedisPubSub == null) {
            return;
        }
        if (this.voiceScapePlugin.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        try {
            this.jedisPub.publish(String.valueOf(this.voiceScapePlugin.client.getWorld()), message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestDeletion() {
        this.sendRawMessage("delete#" + this.voiceScapePlugin.hashWithSha256(this.voiceScapePlugin.client.getLocalPlayer().getName()));
    }

    public void requestRegistration() {
        this.sendRawMessage("register#" + this.voiceScapePlugin.hashWithSha256(this.voiceScapePlugin.client.getLocalPlayer().getName()));
    }

    public void close() {
        this.voiceScapePlugin.menuManager.removePlayerMenuItem(" Mute");
        this.voiceScapePlugin.menuManager.removePlayerMenuItem(" Un-mute");
        this.requestDeletion();
        this.stopMicrophoneCapture();
        if (this.jedisPubSub != null) {
            if (this.jedisPubSub.isSubscribed()) {
                this.jedisPubSub.unsubscribe();
            }
            this.jedisPubSub = null;
        }
        if (this.jedisSub != null) {
            this.jedisSub.disconnect();
            this.jedisSub.close();
            this.jedisSub = null;
        }
        if (this.subscribeThread != null) {
            this.subscribeThread.interrupt();
            this.subscribeThread = null;
        }
        if (this.jedisPub != null) {
            this.jedisPub.close();
            this.jedisPub = null;
        }
    }

    public void sendVoicePacket(VoicePacket voicePacket) {
        String data = this.voiceScapePlugin.gson.toJson(voicePacket);
        this.sendRawMessage(data);
    }

    public VoicePacket buildVoicePacket(byte[] voiceData) {
        return new VoicePacket(voiceData, this.voiceScapePlugin.hashWithSha256(this.voiceScapePlugin.client.getLocalPlayer().getName()));
    }

    public void startMicrophoneCapture() {
        if (this.microphoneCaptureThread != null) {
            this.microphoneCaptureThread.interrupt();
            this.microphoneCaptureThread = null;
        }
        this.microphoneCaptureThread = new Thread(() -> {
            try {
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.getAudioFormat());
                this.microphone = (TargetDataLine)AudioSystem.getLine(info);
                this.microphone.open(this.getAudioFormat());
                this.microphone.start();
                int bufferSize = this.voiceScapePlugin.config.lowCaptureBuffer() ? 20000 : (int)this.getAudioFormat().getSampleRate() * this.getAudioFormat().getFrameSize();
                byte[] buffer = new byte[bufferSize];
                while (this.microphoneCaptureThread != null && !this.microphoneCaptureThread.isInterrupted()) {
                    int count;
                    if (this.voiceScapePlugin.client.getGameState() != GameState.LOGGED_IN || this.voiceScapePlugin.client.getPlayers().isEmpty()) continue;
                    boolean isValid = false;
                    for (Player player : this.voiceScapePlugin.client.getPlayers()) {
                        if (player == null || Objects.equals(player.getName(), this.voiceScapePlugin.client.getLocalPlayer().getName()) && !this.voiceScapePlugin.config.loopBack() || !this.voiceScapePlugin.registeredPlayers.contains(this.voiceScapePlugin.hashWithSha256(player.getName()))) continue;
                        isValid = true;
                        break;
                    }
                    if (!isValid || this.voiceScapePlugin.config.pushToTalk() && !this.voiceScapePlugin.canSpeak || this.voiceScapePlugin.config.muteSelf() || (count = this.microphone.read(buffer, 0, buffer.length)) <= 0) continue;
                    byte[] tempBuffer = new byte[count];
                    System.arraycopy(buffer, 0, tempBuffer, 0, count);
                    this.sendVoicePacket(this.buildVoicePacket(tempBuffer));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.microphoneCaptureThread.start();
    }

    public void stopMicrophoneCapture() {
        if (this.microphone != null) {
            this.microphone.stop();
            this.microphone.close();
            this.microphone = null;
        }
        if (this.microphoneCaptureThread != null) {
            this.microphoneCaptureThread.interrupt();
            this.microphoneCaptureThread = null;
        }
    }
}

