/*
 * Decompiled with CFR 0.152.
 */
package de.furkan.voicescape;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisPool {
    private static final Logger log = LoggerFactory.getLogger(RedisPool.class);
    private final String redisHost;
    private final BlockingQueue<Jedis> queue;

    RedisPool(int queueSize, String redisHost, int redisPort) {
        this.redisHost = redisHost;
        this.queue = new ArrayBlockingQueue<Jedis>(queueSize);
        for (int i = 0; i < queueSize; ++i) {
            PooledJedis jedis = new PooledJedis(redisHost, redisPort);
            this.queue.offer(jedis);
        }
    }

    RedisPool(int queueSize, String redisHost, int redisPort, String username, String password) {
        this.redisHost = redisHost;
        this.queue = new ArrayBlockingQueue<Jedis>(queueSize);
        for (int i = 0; i < queueSize; ++i) {
            PooledJedis jedis = new PooledJedis(redisHost, redisPort, username, password);
            this.queue.offer(jedis);
        }
    }

    public Jedis getResource() {
        Jedis jedis;
        try {
            jedis = this.queue.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (jedis == null) {
            throw new RuntimeException("Unable to acquire connection from pool, timeout");
        }
        return jedis;
    }

    class PooledJedis
    extends Jedis {
        PooledJedis(String host, int port) {
            super(host, port);
            super.ping();
        }

        PooledJedis(String host, int port, String username, String password) {
            super(host, port);
            super.auth(username, password);
        }

        @Override
        public void close() {
            if (!this.getClient().isBroken()) {
                RedisPool.this.queue.offer(this);
                return;
            }
            try {
                super.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RedisPool.this.queue.clear();
        }
    }
}

