/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy.scripting;

import com.google.gson.Gson;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.scripting.ScriptFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;

public final class ScriptLoader {
    private static final HashMap<String, ScriptFile> scriptCache = new HashMap();

    private ScriptLoader() {
    }

    public static ScriptFile loadScript(CitizensPlugin plugin, String scriptName) {
        ScriptFile scriptFile;
        if (scriptCache.containsKey(scriptName)) {
            return scriptCache.get(scriptName);
        }
        InputStream inputStream = ((Object)((Object)plugin)).getClass().getResourceAsStream("/Scripts/" + scriptName + ".json");
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            Gson gson = plugin.gson;
            ScriptFile script = (ScriptFile)gson.fromJson((Reader)reader, ScriptFile.class);
            scriptCache.put(scriptName, script);
            script.name = scriptName;
            scriptFile = script;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.out.println("Script Loading Error: " + e.getMessage());
                return null;
            }
        }
        ((Reader)reader).close();
        return scriptFile;
    }
}

