/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.magnaboy.Citizen;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.EntityType;
import com.magnaboy.Util;
import java.time.Instant;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class WanderingCitizen
extends Citizen<WanderingCitizen> {
    public WorldArea boundingBox;
    public WorldPoint wanderRegionBL;
    public WorldPoint wanderRegionTR;
    private Instant lastWanderTime;

    public WanderingCitizen(CitizensPlugin plugin) {
        super(plugin);
        this.entityType = EntityType.WanderingCitizen;
        this.lastWanderTime = Instant.now().minusSeconds(6L);
    }

    public WanderingCitizen setBoundingBox(WorldPoint bottomLeft, WorldPoint topRight) {
        this.boundingBox = Util.calculateBoundingBox(bottomLeft, topRight);
        this.setWorldLocation(this.getRandomInBoundingBox());
        return this;
    }

    public WanderingCitizen setWanderRegionBL(WorldPoint wp) {
        this.wanderRegionBL = wp;
        return this;
    }

    public WanderingCitizen setWanderRegionTR(WorldPoint wp) {
        this.wanderRegionTR = wp;
        return this;
    }

    private WorldPoint getRandomInBoundingBox() {
        int y;
        int x;
        WorldPoint randomPoint;
        while ((randomPoint = new WorldPoint(x = Util.getRandom(this.boundingBox.getX(), this.boundingBox.getX() + this.boundingBox.getWidth()), y = Util.getRandom(this.boundingBox.getY(), this.boundingBox.getY() + this.boundingBox.getHeight()), this.getPlane())).equals((Object)this.getWorldLocation())) {
        }
        return randomPoint;
    }

    public void wander() {
        if (this.getCurrentTarget() != null || Instant.now().isBefore(this.lastWanderTime.plusSeconds(6L))) {
            return;
        }
        WorldPoint randomSpot = this.getRandomInBoundingBox();
        this.moveTo(randomSpot);
        this.lastWanderTime = Instant.now();
    }
}

