/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.magnaboy.Citizen;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.EntityType;
import com.magnaboy.Util;
import com.magnaboy.scripting.ActionType;
import com.magnaboy.scripting.ScriptAction;
import com.magnaboy.scripting.ScriptFile;
import com.magnaboy.scripting.ScriptLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class ScriptedCitizen
extends Citizen<ScriptedCitizen> {
    public ScriptAction currentAction;
    public WorldPoint baseLocation;
    private ScriptFile script;
    private ExecutorService scriptExecutor;

    public ScriptedCitizen(CitizensPlugin plugin) {
        super(plugin);
        this.entityType = EntityType.ScriptedCitizen;
    }

    private void submitAction(ScriptAction action, Runnable task) {
        this.scriptExecutor.submit(() -> {
            this.currentAction = action;
            task.run();
        });
    }

    public ScriptedCitizen setScript(String scriptName) {
        if (scriptName == null || scriptName.isEmpty()) {
            return this;
        }
        this.script = ScriptLoader.loadScript(this.plugin, scriptName);
        return this;
    }

    @Override
    public boolean despawn() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.shutdownNow();
        }
        return super.despawn();
    }

    private void refreshExecutor() {
        if (!this.isActive()) {
            return;
        }
        if (this.scriptExecutor == null || this.scriptExecutor.isShutdown()) {
            this.scriptExecutor = Executors.newSingleThreadExecutor();
            ScriptAction walkAction = new ScriptAction();
            walkAction.action = ActionType.WalkTo;
            walkAction.targetPosition = this.baseLocation;
            walkAction.secondsTilNextAction = 0.0f;
            this.addWalkAction(walkAction);
            this.buildRoutine();
        }
    }

    @Override
    public boolean spawn() {
        boolean didSpawn = super.spawn();
        if (didSpawn) {
            this.refreshExecutor();
        }
        return didSpawn;
    }

    @Override
    public void update() {
        this.refreshExecutor();
        super.update();
    }

    private void buildRoutine() {
        if (this.script == null) {
            return;
        }
        for (ScriptAction action : this.script.actions) {
            this.addAction(action);
        }
        this.scriptExecutor.submit(this::buildRoutine);
    }

    private void addAction(ScriptAction action) {
        if (action != null) {
            switch (action.action) {
                case Idle: {
                    this.submitAction(action, () -> this.setWait(Float.valueOf(action.secondsTilNextAction)));
                    break;
                }
                case Say: {
                    this.addSayAction(action);
                    break;
                }
                case WalkTo: {
                    this.addWalkAction(action);
                    break;
                }
                case Animation: {
                    this.addAnimationAction(action);
                    break;
                }
                case FaceDirection: {
                    this.addRotateAction(action);
                }
            }
        }
    }

    private void addSayAction(ScriptAction action) {
        this.submitAction(action, () -> {
            this.say(action.message);
            this.setWait(Float.valueOf(action.secondsTilNextAction));
        });
    }

    private void addWalkAction(ScriptAction action) {
        this.submitAction(action, () -> {
            int tilesToWalk = action.targetPosition.distanceTo2D(this.getWorldLocation()) + 1;
            this.sleep(tilesToWalk * 100);
            this.plugin.clientThread.invokeLater(() -> this.moveTo(action.targetPosition, action.targetRotation == null ? null : Integer.valueOf(action.targetRotation.getAngle()), false, false));
            while (!this.getWorldLocation().equals((Object)action.targetPosition) || this.getAnimationID() != this.idleAnimationId.getId().intValue() || WorldPoint.fromLocal((Client)this.plugin.client, (LocalPoint)this.getLocalLocation()).distanceTo2D(this.getWorldLocation()) > 0) {
                this.sleep();
            }
            this.setWait(Float.valueOf(action.secondsTilNextAction));
        });
    }

    private void addRotateAction(ScriptAction action) {
        this.submitAction(action, () -> {
            this.rlObject.setOrientation(action.targetRotation.getAngle());
            this.sleep(50);
            while (this.rlObject.getOrientation() != action.targetRotation.getAngle()) {
                this.sleep();
                this.rlObject.setOrientation(action.targetRotation.getAngle());
            }
            this.setWait(Float.valueOf(action.secondsTilNextAction));
        });
    }

    private void sleep() {
        this.sleep(30);
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void addAnimationAction(ScriptAction action) {
        this.submitAction(action, () -> {
            Util.AnimData animData = Util.getAnimData(action.animationId.getId());
            int loopCount = action.timesToLoop == null ? 1 : action.timesToLoop;
            for (int i = 0; i < loopCount; ++i) {
                this.setAnimation(action.animationId.getId());
                try {
                    Thread.sleep(animData.realDurationMillis);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.setAnimation(this.idleAnimationId.getId());
            this.setWait(Float.valueOf(action.secondsTilNextAction));
        });
    }

    private void setWait(Float seconds) {
        if (seconds == null) {
            return;
        }
        seconds = Float.valueOf(Math.max(0.1f, seconds.floatValue()));
        try {
            Thread.sleep((long)(seconds.floatValue() * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

