/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.magnaboy.AnimationID;
import com.magnaboy.CardinalDirection;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.EntityType;
import com.magnaboy.MergedObject;
import com.magnaboy.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.runelite.api.AABB;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.geometry.SimplePolygon;
import net.runelite.api.model.Jarvis;

public class Entity<T extends Entity<T>> {
    public Integer regionId;
    public String name;
    public String examine;
    public CitizensPlugin plugin;
    public AnimationID idleAnimationId;
    public float[] scale;
    public float[] translate;
    public List<MergedObject> mergedObjects = new ArrayList<MergedObject>();
    protected RuneLiteObject rlObject;
    protected EntityType entityType;
    protected Integer baseOrientation;
    protected UUID uuid;
    private WorldPoint worldLocation;
    private int[] modelIDs;
    private int[] recolorsToFind;
    private int[] recolorsToReplace;
    private Integer objectToRemove;

    public Entity(CitizensPlugin plugin) {
        this.plugin = plugin;
        this.rlObject = plugin.client.createRuneLiteObject();
    }

    protected static SimplePolygon calculateAABB(Client client, Model m, Integer jauOrient, int x, int y, int z, int zOff) {
        if (m == null) {
            throw new IllegalStateException("model is null");
        }
        if (jauOrient == null) {
            throw new IllegalStateException("jauOrient is null");
        }
        AABB aabb = m.getAABB(jauOrient.intValue());
        int x1 = aabb.getCenterX();
        int y1 = aabb.getCenterZ();
        int z1 = aabb.getCenterY() + zOff;
        int ex = aabb.getExtremeX();
        int ey = aabb.getExtremeZ();
        int ez = aabb.getExtremeY();
        int x2 = x1 + ex;
        int y2 = y1 + ey;
        int z2 = z1 + ez;
        int[] xa = new int[]{x1 -= ex, x2, x1, x2, x1, x2, x1, x2};
        int[] ya = new int[]{y1 -= ey, y1, y2, y2, y1, y1, y2, y2};
        int[] za = new int[]{z1 -= ez, z1, z1, z1, z2, z2, z2, z2};
        int[] x2d = new int[8];
        int[] y2d = new int[8];
        Entity.modelToCanvasCpu(client, 8, x, y, z, 0, xa, ya, za, x2d, y2d);
        return Jarvis.convexHull((int[])x2d, (int[])y2d);
    }

    private static void modelToCanvasCpu(Client client, int end, int x3dCenter, int y3dCenter, int z3dCenter, int rotate, int[] x3d, int[] y3d, int[] z3d, int[] x2d, int[] y2d) {
        int cameraPitch = client.getCameraPitch();
        int cameraYaw = client.getCameraYaw();
        int pitchSin = Perspective.SINE[cameraPitch];
        int pitchCos = Perspective.COSINE[cameraPitch];
        int yawSin = Perspective.SINE[cameraYaw];
        int yawCos = Perspective.COSINE[cameraYaw];
        int rotateSin = Perspective.SINE[rotate];
        int rotateCos = Perspective.COSINE[rotate];
        int cx = x3dCenter - client.getCameraX();
        int cy = y3dCenter - client.getCameraY();
        int cz = z3dCenter - client.getCameraZ();
        int viewportXMiddle = client.getViewportWidth() / 2;
        int viewportYMiddle = client.getViewportHeight() / 2;
        int viewportXOffset = client.getViewportXOffset();
        int viewportYOffset = client.getViewportYOffset();
        int zoom3d = client.getScale();
        for (int i = 0; i < end; ++i) {
            int viewY;
            int viewX;
            int x = x3d[i];
            int y = y3d[i];
            int z = z3d[i];
            if (rotate != 0) {
                int x0 = x;
                x = x0 * rotateCos + y * rotateSin >> 16;
                y = y * rotateCos - x0 * rotateSin >> 16;
            }
            int x1 = (x += cx) * yawCos + (y += cy) * yawSin >> 16;
            int y1 = y * yawCos - x * yawSin >> 16;
            int y2 = (z += cz) * pitchCos - y1 * pitchSin >> 16;
            int z1 = y1 * pitchCos + z * pitchSin >> 16;
            if (z1 < 50) {
                viewX = Integer.MIN_VALUE;
                viewY = Integer.MIN_VALUE;
            } else {
                viewX = viewportXMiddle + x1 * zoom3d / z1 + viewportXOffset;
                viewY = viewportYMiddle + y2 * zoom3d / z1 + viewportYOffset;
            }
            x2d[i] = viewX;
            y2d[i] = viewY;
        }
    }

    public int getAnimationID() {
        return this.rlObject.getAnimation().getId();
    }

    public boolean isCitizen() {
        return this.entityType == EntityType.StationaryCitizen || this.entityType == EntityType.WanderingCitizen || this.entityType == EntityType.ScriptedCitizen;
    }

    public SimplePolygon getClickbox() {
        LocalPoint location = this.getLocalLocation();
        int zOff = Perspective.getTileHeight((Client)this.plugin.client, (LocalPoint)location, (int)this.plugin.client.getPlane());
        return Entity.calculateAABB(this.plugin.client, this.rlObject.getModel(), this.rlObject.getOrientation(), location.getX(), location.getY(), this.plugin.client.getPlane(), zOff);
    }

    public LocalPoint getLocalLocation() {
        return this.rlObject.getLocation();
    }

    public int getOrientation() {
        return this.rlObject.getOrientation();
    }

    public void setModel(Model model) {
        this.rlObject.setModel(model);
    }

    public void setAnimation(int animationID) {
        this.plugin.clientThread.invokeLater(() -> {
            Animation anim = this.plugin.client.loadAnimation(animationID);
            this.rlObject.setAnimation(anim);
        });
    }

    public T setWorldLocation(WorldPoint location) {
        this.worldLocation = location;
        return (T)this;
    }

    public T setObjectToRemove(Integer objectToRemove) {
        this.objectToRemove = objectToRemove;
        return (T)this;
    }

    public T addMergedObject(MergedObject mergedObject) {
        this.mergedObjects.add(mergedObject);
        return (T)this;
    }

    public void update() {
        boolean inScene = this.shouldRender();
        if (inScene) {
            this.spawn();
        } else {
            this.despawn();
        }
    }

    public T setScale(float[] scale) {
        this.scale = scale;
        return (T)this;
    }

    public T setTranslate(float translateX, float translateY, float translateZ) {
        this.translate = new float[]{translateX, translateY, translateZ};
        return (T)this;
    }

    public T setTranslate(float[] translate) {
        this.translate = translate;
        return (T)this;
    }

    public T setBaseOrientation(CardinalDirection baseOrientation) {
        this.baseOrientation = baseOrientation.getAngle();
        return (T)this;
    }

    public T setBaseOrientation(Integer baseOrientation) {
        this.baseOrientation = baseOrientation;
        return (T)this;
    }

    public T setModelIDs(int[] modelIDs) {
        this.modelIDs = modelIDs;
        return (T)this;
    }

    public T setModelRecolors(int[] recolorsToFind, int[] recolorsToReplace) {
        this.recolorsToFind = recolorsToFind;
        this.recolorsToReplace = recolorsToReplace;
        return (T)this;
    }

    public T setLocation(LocalPoint location) {
        if (location == null) {
            throw new IllegalStateException("Tried to set null location");
        }
        this.rlObject.setLocation(location, this.getPlane());
        WorldPoint wp = WorldPoint.fromLocal((Client)this.plugin.client, (LocalPoint)location);
        this.setWorldLocation(wp);
        return (T)this;
    }

    public int getPlane() {
        return this.worldLocation.getPlane();
    }

    public boolean shouldRender() {
        if (this.getPlane() != this.plugin.client.getPlane()) {
            return false;
        }
        float distanceFromPlayer = this.distanceToPlayer();
        if (distanceFromPlayer > 25.0f) {
            return false;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.plugin.client, (WorldPoint)this.worldLocation);
        return lp != null;
    }

    public float distanceToPlayer() {
        Player player = this.plugin.client.getLocalPlayer();
        WorldPoint playerWorldLoc = player.getWorldLocation();
        return playerWorldLoc.distanceTo(this.getWorldLocation());
    }

    public boolean despawn() {
        if (this.rlObject == null) {
            return false;
        }
        if (!this.rlObject.isActive()) {
            return false;
        }
        this.plugin.clientThread.invokeLater(() -> this.rlObject.setActive(false));
        if (this.plugin.IS_DEVELOPMENT) {
            this.plugin.panel.update();
        }
        return true;
    }

    private void initModel() {
        if (this.rlObject.getModel() == null) {
            ArrayList<ModelData> models = new ArrayList<ModelData>();
            for (int modelID : this.modelIDs) {
                ModelData data = this.plugin.client.loadModelData(modelID);
                models.add(data);
            }
            Object object = this.mergedObjects.iterator();
            while (object.hasNext()) {
                MergedObject obj = (MergedObject)object.next();
                ModelData data = this.plugin.client.loadModelData(obj.objectID);
                for (int i = 0; i < obj.count90CCWRotations; ++i) {
                    data.cloneVertices();
                    data.rotateY90Ccw();
                }
                models.add(data);
            }
            ModelData finalModel = this.plugin.client.mergeModels(models.toArray(new ModelData[models.size()]), models.size());
            if (this.recolorsToReplace != null && this.recolorsToReplace.length > 0) {
                for (int i = 0; i < this.recolorsToReplace.length; ++i) {
                    finalModel.recolor((short)this.recolorsToFind[i], (short)this.recolorsToReplace[i]);
                }
            }
            if (this.scale != null) {
                finalModel.cloneVertices();
                finalModel.scale(-Math.round(this.scale[0] * 128.0f), -Math.round(this.scale[1] * 128.0f), -Math.round(this.scale[2] * 128.0f));
            }
            if (this.translate != null) {
                finalModel.cloneVertices();
                finalModel.translate(-Math.round(this.translate[0] * 128.0f), -Math.round(this.translate[1] * 128.0f), -Math.round(this.translate[2] * 128.0f));
            }
            this.rlObject.setModel(finalModel.light(64, 850, -30, -50, -30));
        }
        if (this.baseOrientation != null && this.rlObject.getOrientation() == 0) {
            this.rlObject.setOrientation(this.baseOrientation.intValue());
        }
        if (this.idleAnimationId != null && this.rlObject.getAnimation() == null) {
            this.setAnimation(this.idleAnimationId.getId());
        }
        this.rlObject.setShouldLoop(true);
    }

    public String debugName() {
        float dist = this.distanceToPlayer();
        return "N:" + this.name + " T:" + this.entityType + " ID:" + this.uuid.toString().substring(0, 6) + " D:" + dist;
    }

    public void validate() {
        if (this.uuid == null) {
            throw new IllegalStateException(this.debugName() + " has no uuid.");
        }
        if (this.regionId == null) {
            throw new IllegalStateException(this.debugName() + " has no regionId.");
        }
    }

    private void initLocation() {
        LocalPoint initializedLocation = LocalPoint.fromWorld((Client)this.plugin.client, (WorldPoint)this.worldLocation);
        if (initializedLocation == null) {
            throw new IllegalStateException("Tried to spawn entity with no initializedLocation: " + this.debugName());
        }
        this.setLocation(initializedLocation);
    }

    public boolean spawn() {
        if (this.isActive()) {
            return false;
        }
        this.initModel();
        this.initLocation();
        if (this.objectToRemove != null) {
            this.removeOtherObjects();
        }
        if (this.idleAnimationId != null) {
            this.setAnimation(this.idleAnimationId.getId());
        }
        this.plugin.clientThread.invokeLater(() -> this.rlObject.setActive(true));
        if (this.plugin.IS_DEVELOPMENT) {
            this.plugin.panel.update();
        }
        return true;
    }

    public boolean isActive() {
        return this.rlObject.isActive();
    }

    public boolean rotateObject(double intx, double inty) {
        int currentOrientation;
        if (intx == 0.0 && inty == 0.0) {
            return true;
        }
        int targetOrientation = Util.radToJau(Math.atan2(intx, inty));
        int dJau = (targetOrientation - (currentOrientation = this.rlObject.getOrientation())) % 2048;
        if (dJau != 0) {
            int JAU_HALF_ROTATION = 1024;
            int JAU_TURN_SPEED = 32;
            int dJauCW = Math.abs(dJau);
            if (dJauCW > 1024) {
                dJau = (currentOrientation - targetOrientation) % 2048;
            } else if (dJauCW == 1024) {
                dJau = dJauCW;
            }
            if (Math.abs(dJau) > 32) {
                dJau = Integer.signum(dJau) * 32;
            }
            int newOrientation = (2048 + this.rlObject.getOrientation() + dJau) % 2048;
            this.rlObject.setOrientation(newOrientation);
            dJau = (targetOrientation - newOrientation) % 2048;
        }
        return dJau == 0;
    }

    public T setIdleAnimation(AnimationID idleAnimationId) {
        this.idleAnimationId = idleAnimationId;
        return (T)this;
    }

    public T setUUID(UUID uuid) {
        if (this.uuid == null) {
            this.uuid = uuid;
        }
        return (T)this;
    }

    public T setRegion(int regionId) {
        this.regionId = regionId;
        return (T)this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity compare = (Entity)o;
        return this.uuid == compare.uuid;
    }

    public String getModelIDsString() {
        return Util.intArrayToString(this.modelIDs);
    }

    public String getRecolorFindString() {
        return Util.intArrayToString(this.recolorsToFind);
    }

    public String getRecolorReplaceString() {
        return Util.intArrayToString(this.recolorsToReplace);
    }

    private void removeOtherObjects() {
        Scene scene = this.plugin.client.getScene();
        Tile[][] tiles = scene.getTiles()[this.plugin.client.getPlane()];
        LocalPoint lp = LocalPoint.fromWorld((Client)this.plugin.client, (WorldPoint)this.worldLocation);
        if (lp == null) {
            return;
        }
        Tile tile = tiles[lp.getSceneX()][lp.getSceneY()];
        if (tile == null) {
            return;
        }
        for (GameObject gameObject : tile.getGameObjects()) {
            if (gameObject == null || gameObject.getId() != this.objectToRemove.intValue()) continue;
            scene.removeGameObject(gameObject);
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public WorldPoint getWorldLocation() {
        return this.worldLocation;
    }
}

