/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.magnaboy.Citizen;
import com.magnaboy.CitizenPanel;
import com.magnaboy.CitizenRegion;
import com.magnaboy.CitizensConfig;
import com.magnaboy.CitizensOverlay;
import com.magnaboy.Entity;
import com.magnaboy.EntityType;
import com.magnaboy.Util;
import com.magnaboy.WanderingCitizen;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.geometry.SimplePolygon;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Citizens", description="Adds citizens to help bring life to the world")
public class CitizensPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CitizensPlugin.class);
    public static HashMap<Integer, CitizenRegion> activeRegions = new HashMap();
    public static boolean shuttingDown;
    @Inject
    public Client client;
    @Inject
    public ClientThread clientThread;
    public CitizenPanel panel;
    public boolean IS_DEVELOPMENT = false;
    public boolean entitiesAreReady = false;
    @Inject
    public Gson gson;
    @Inject
    ChatMessageManager chatMessageManager;
    @Inject
    private CitizensConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CitizensOverlay citizensOverlay;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;

    @Provides
    CitizensConfig getConfig(ConfigManager configManager) {
        return (CitizensConfig)configManager.getConfig(CitizensConfig.class);
    }

    public boolean isReady() {
        return this.entitiesAreReady && this.client.getLocalPlayer() != null;
    }

    protected void startUp() {
        CitizenRegion.init(this);
        this.panel = (CitizenPanel)((Object)this.injector.getInstance(CitizenPanel.class));
        this.panel.init(this, this.citizensOverlay);
        this.overlayManager.add((Overlay)this.citizensOverlay);
        if (this.IS_DEVELOPMENT) {
            BufferedImage icon = ImageUtil.loadImageResource(CitizensPlugin.class, (String)"/citizens_icon.png");
            this.navButton = NavigationButton.builder().tooltip("Citizens").icon(icon).priority(7).panel((PluginPanel)this.panel).build();
            this.clientToolbar.addNavigation(this.navButton);
        }
        if (this.isReady()) {
            this.checkRegions();
        }
        CitizenRegion.updateAllEntities();
        Util.initAnimationData(this);
    }

    protected void shutDown() {
        this.cleanupAll();
        if (this.navButton != null) {
            this.clientToolbar.removeNavigation(this.navButton);
        }
    }

    void reload() {
        this.shutDown();
        this.startUp();
    }

    protected void despawnAll() {
        for (CitizenRegion r : activeRegions.values()) {
            CitizenRegion.forEachActiveEntity(Entity::despawn);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState newState = gameStateChanged.getGameState();
        if (newState == GameState.LOGGED_IN) {
            this.checkRegions();
        }
        if (newState == GameState.LOADING) {
            this.despawnAll();
            CitizenRegion.updateAllEntities();
        }
    }

    @Schedule(period=3L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void citizenBehaviourTick() {
        if (!this.isReady()) {
            return;
        }
        for (CitizenRegion r : activeRegions.values()) {
            r.runOncePerTimePeriod(10, 3, entity -> {
                if (entity instanceof WanderingCitizen) {
                    ((WanderingCitizen)entity).wander();
                }
            });
            r.runOncePerTimePeriod(60, 3, entity -> {
                if (entity.isCitizen() && entity.distanceToPlayer() < 15.0f) {
                    ((Citizen)entity).sayRandomRemark();
                }
            });
        }
        this.panel.update();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        CitizenRegion.updateAllEntities();
    }

    @Subscribe
    public void onClientTick(ClientTick ignored) {
        CitizenRegion.forEachActiveEntity(entity -> {
            if (entity.isCitizen()) {
                ((Citizen)entity).onClientTick();
            }
        });
    }

    @Subscribe
    public void onMenuOpened(MenuOpened ignored) {
        int[] firstMenuIndex = new int[]{1};
        Point mousePos = this.client.getMouseCanvasPosition();
        AtomicBoolean[] clickedCitizen = new AtomicBoolean[]{new AtomicBoolean(false)};
        CitizenRegion.forEachActiveEntity(entity -> {
            if (entity.entityType == EntityType.Scenery && !this.IS_DEVELOPMENT) {
                return;
            }
            if (entity.name != null && entity.examine != null || this.IS_DEVELOPMENT) {
                SimplePolygon clickbox;
                try {
                    clickbox = entity.getClickbox();
                }
                catch (IllegalStateException err) {
                    return;
                }
                if (clickbox == null) {
                    return;
                }
                boolean doesClickBoxContainMousePos = clickbox.contains((double)mousePos.getX(), (double)mousePos.getY());
                if (doesClickBoxContainMousePos && doesClickBoxContainMousePos) {
                    this.client.createMenuEntry(firstMenuIndex[0]).setOption("Examine").setTarget("<col=fffe00>" + entity.name + "</col>").setType(MenuAction.RUNELITE).setParam0(0).setParam1(0).setDeprioritized(true);
                }
                if (this.IS_DEVELOPMENT && doesClickBoxContainMousePos) {
                    String action = "Select";
                    if (CitizenPanel.selectedEntity == entity) {
                        action = "Deselect";
                        clickedCitizen[0].set(true);
                    }
                    int n = firstMenuIndex[0];
                    firstMenuIndex[0] = n + 1;
                    this.client.createMenuEntry(n).setOption(ColorUtil.wrapWithColorTag((String)"Citizen Editor", (Color)Color.cyan)).setTarget(action + " <col=fffe00>" + entity.name + "</col>").setType(MenuAction.RUNELITE).setDeprioritized(true).onClick(e -> {
                        this.panel.setSelectedEntity((Entity)entity);
                        this.panel.update();
                    });
                }
            }
        });
        if (this.IS_DEVELOPMENT) {
            Tile selectedSceneTile = this.client.getSelectedSceneTile();
            boolean same = CitizenPanel.selectedPosition != null && CitizenPanel.selectedPosition.equals((Object)selectedSceneTile.getWorldLocation());
            String action = same ? "Deselect" : "Select";
            int n = firstMenuIndex[0];
            firstMenuIndex[0] = n + 1;
            this.client.createMenuEntry(n).setOption(ColorUtil.wrapWithColorTag((String)"Citizen Editor", (Color)Color.cyan)).setTarget(action + " <col=fffe00>Tile</col>").setType(MenuAction.RUNELITE).setDeprioritized(true).onClick(e -> {
                CitizenPanel.selectedPosition = same ? null : selectedSceneTile.getWorldLocation();
                this.panel.update();
            });
            if (CitizenPanel.selectedEntity != null && !clickedCitizen[0].get()) {
                String name = "Scenery Object";
                if (CitizenPanel.selectedEntity instanceof Citizen) {
                    name = CitizenPanel.selectedEntity.name;
                }
                this.client.createMenuEntry(firstMenuIndex[0] - 1).setOption(ColorUtil.wrapWithColorTag((String)"Citizen Editor", (Color)Color.cyan)).setTarget("Deselect <col=fffe00>" + name + "</col>").setType(MenuAction.RUNELITE).setDeprioritized(true).onClick(e -> {
                    this.panel.setSelectedEntity(CitizenPanel.selectedEntity);
                    this.panel.update();
                });
            }
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        if (!event.getMenuOption().equals("Examine")) {
            return;
        }
        CitizenRegion.forEachActiveEntity(entity -> {
            if (event.getMenuTarget().equals("<col=fffe00>" + entity.name + "</col>")) {
                event.consume();
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(entity.examine).build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.NPC_EXAMINE).runeLiteFormattedMessage(chatMessage).timestamp((int)(System.currentTimeMillis() / 1000L)).build());
            }
        });
    }

    private void checkRegions() {
        List loaded = Arrays.stream(this.client.getMapRegions()).boxed().collect(Collectors.toList());
        Iterator iterator = loaded.iterator();
        while (iterator.hasNext()) {
            CitizenRegion region;
            int i = (Integer)iterator.next();
            if (activeRegions.containsKey(i) || (region = CitizenRegion.loadRegion(i)) == null) continue;
            activeRegions.put(i, region);
        }
        this.entitiesAreReady = true;
    }

    private void cleanupAll() {
        shuttingDown = true;
        activeRegions.clear();
        this.despawnAll();
        this.overlayManager.remove((Overlay)this.citizensOverlay);
        CitizenRegion.cleanUp();
        if (this.IS_DEVELOPMENT) {
            this.panel.cleanup();
            this.panel.update();
        }
        shuttingDown = false;
    }

    public CitizensConfig getConfig() {
        return this.config;
    }
}

