/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.magnaboy.Citizen;
import com.magnaboy.CitizenPanel;
import com.magnaboy.CitizenRegion;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.EntityType;
import com.magnaboy.ScriptedCitizen;
import com.magnaboy.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

public class CitizensOverlay
extends Overlay {
    private final CitizensPlugin plugin;
    private final ModelOutlineRenderer modelOutlineRenderer;
    Font overheadFont = FontManager.getRunescapeBoldFont();

    @Inject
    public CitizensOverlay(CitizensPlugin plugin, ModelOutlineRenderer modelOutlineRenderer) {
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
    }

    private void renderText(Graphics2D graphics, LocalPoint lp, String text) {
        if (!this.plugin.IS_DEVELOPMENT) {
            return;
        }
        this.renderText(graphics, lp, text, new Color(0, 255, 3));
    }

    private void renderText(Graphics2D graphics, LocalPoint lp, String text, Color color) {
        Font overheadFont = FontManager.getRunescapeSmallFont();
        graphics.setFont(overheadFont);
        Point p = Perspective.localToCanvas((Client)this.plugin.client, (LocalPoint)lp, (int)this.plugin.client.getPlane(), (int)0);
        if (p == null) {
            return;
        }
        FontMetrics metrics = graphics.getFontMetrics(overheadFont);
        Point shiftedP = new Point(p.getX() - metrics.stringWidth(text) / 2, p.getY());
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)shiftedP, (String)text, (Color)color);
    }

    private void highlightTile(Graphics2D graphics, LocalPoint lp, Color color) {
        if (lp == null) {
            return;
        }
        if (!this.plugin.IS_DEVELOPMENT) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.plugin.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
        }
    }

    private void highlightTile(Graphics2D graphics, WorldPoint wp, Color color) {
        if (!this.plugin.IS_DEVELOPMENT) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.plugin.client, (WorldPoint)wp);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.plugin.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
        }
    }

    private void highlightRegion(Graphics2D graphics, WorldPoint bottomLeft, WorldPoint topRight, int plane, Color color) {
        WorldArea boundingBox = Util.calculateBoundingBox(bottomLeft, topRight);
        this.highlightRegion(graphics, boundingBox, plane, color);
    }

    private void highlightRegion(Graphics2D graphics, WorldArea boundingBox, int plane, Color color) {
        int y;
        int x = boundingBox.getX();
        for (int i = y = boundingBox.getY(); i <= y + boundingBox.getHeight(); ++i) {
            for (int t = 0; t <= boundingBox.getWidth(); ++t) {
                this.highlightTile(graphics, new WorldPoint(x + t, i, plane), color);
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (CitizensPlugin.shuttingDown) {
            return null;
        }
        if (CitizenPanel.selectedPosition != null) {
            Color selectedColor = new Color(0, 255, 255, 200);
            this.highlightTile(graphics, CitizenPanel.selectedPosition, selectedColor);
            LocalPoint lp = LocalPoint.fromWorld((Client)this.plugin.client, (WorldPoint)CitizenPanel.selectedPosition);
            if (this.plugin.IS_DEVELOPMENT && lp != null) {
                this.renderText(graphics, lp, "Selected Tile", selectedColor);
            }
        }
        if (CitizenPanel.selectedEntity != null) {
            int outlineWidth = 4;
            this.modelOutlineRenderer.drawOutline(CitizenPanel.selectedEntity.rlObject, 4, Color.cyan, 2);
        }
        CitizenRegion.forEachActiveEntity(entity -> {
            Point p;
            if (!entity.isCitizen()) {
                return;
            }
            Citizen citizen = (Citizen)entity;
            LocalPoint localLocation = citizen.getLocalLocation();
            if (!citizen.shouldRender() || localLocation == null) {
                return;
            }
            if (citizen.activeRemark != null && (p = Perspective.localToCanvas((Client)this.plugin.client, (LocalPoint)citizen.getLocalLocation(), (int)this.plugin.client.getPlane(), (int)citizen.rlObject.getModelHeight())) != null) {
                graphics.setFont(this.overheadFont);
                FontMetrics metrics = graphics.getFontMetrics(this.overheadFont);
                Point shiftedP = new Point(p.getX() - metrics.stringWidth(citizen.activeRemark) / 2, p.getY());
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)shiftedP, (String)citizen.activeRemark, (Color)JagexColors.YELLOW_INTERFACE_TEXT);
            }
            if (this.plugin.IS_DEVELOPMENT && citizen.distanceToPlayer() < 15.0f) {
                Object extraString = "";
                if (citizen.entityType == EntityType.ScriptedCitizen) {
                    ScriptedCitizen scriptedCitizen = (ScriptedCitizen)citizen;
                    if (scriptedCitizen.currentAction != null && scriptedCitizen.currentAction.action != null) {
                        extraString = scriptedCitizen.currentAction.action + " ";
                    }
                }
                String debugText = citizen.debugName() + " " + (String)extraString + "H:" + citizen.rlObject.getModelHeight() + " ";
                this.renderText(graphics, localLocation, debugText, JagexColors.YELLOW_INTERFACE_TEXT);
                Citizen.Target target = citizen.getCurrentTarget();
                if (target != null) {
                    this.highlightTile(graphics, target.localDestinationPosition, new Color(235, 150, 52));
                }
            }
        });
        return null;
    }
}

