/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.magnaboy.CardinalDirection;
import com.magnaboy.Citizen;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.Entity;
import com.magnaboy.EntityType;
import com.magnaboy.Scenery;
import com.magnaboy.ScriptedCitizen;
import com.magnaboy.StationaryCitizen;
import com.magnaboy.Util;
import com.magnaboy.WanderingCitizen;
import com.magnaboy.serialization.CitizenInfo;
import com.magnaboy.serialization.EntityInfo;
import com.magnaboy.serialization.SceneryInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class CitizenRegion {
    public static final HashMap<Integer, CitizenRegion> regionCache = new HashMap();
    private static final float VALID_REGION_VERSION = 0.8f;
    private static final HashMap<Integer, CitizenRegion> dirtyRegions = new HashMap();
    private static final String REGIONDATA_DIRECTORY = new File("src/main/resources/RegionData/").getAbsolutePath();
    private static CitizensPlugin plugin;
    public transient HashMap<UUID, Entity> entities = new HashMap();
    public float version;
    public int regionId;
    public List<CitizenInfo> citizenRoster = new ArrayList<CitizenInfo>();
    public List<SceneryInfo> sceneryRoster = new ArrayList<SceneryInfo>();
    public transient ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public static void init(CitizensPlugin p) {
        plugin = p;
    }

    public static CitizenRegion loadRegion(int regionId) {
        return CitizenRegion.loadRegion(regionId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CitizenRegion loadRegion(int regionId, Boolean createIfNotExists) {
        if (regionCache.containsKey(regionId)) {
            return regionCache.get(regionId);
        }
        InputStream inputStream = ((Object)((Object)plugin)).getClass().getClassLoader().getResourceAsStream("RegionData/" + regionId + ".json");
        if (inputStream == null) {
            if (!CitizenRegion.plugin.IS_DEVELOPMENT) return null;
            if (createIfNotExists == false) return null;
            CitizenRegion region = new CitizenRegion();
            region.regionId = regionId;
            region.version = 0.8f;
            try {
                region.saveRegion();
                return CitizenRegion.loadRegion(regionId, false);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            CitizenRegion region = (CitizenRegion)CitizenRegion.plugin.gson.fromJson((Reader)reader, CitizenRegion.class);
            if (region == null) {
                CitizenRegion citizenRegion = null;
                return citizenRegion;
            }
            if (region.version != 0.8f) {
                CitizenRegion citizenRegion = null;
                return citizenRegion;
            }
            for (CitizenInfo cInfo : region.citizenRoster) {
                Citizen citizen = CitizenRegion.loadCitizen(plugin, cInfo);
                if (citizen == null) continue;
                region.entities.put(citizen.uuid, citizen);
            }
            for (SceneryInfo sInfo : region.sceneryRoster) {
                Scenery scenery = CitizenRegion.loadScenery(plugin, sInfo);
                region.entities.put(scenery.uuid, scenery);
            }
            if (CitizenRegion.plugin.IS_DEVELOPMENT) {
                region.entities.values().forEach(Entity::validate);
            }
            regionCache.put(regionId, region);
            CitizenRegion citizenRegion = region;
            return citizenRegion;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void initCitizenInfo(Citizen citizen, CitizenInfo info) {
        ((Citizen)((Citizen)citizen.setName(info.name)).setExamine(info.examineText)).setRemarks(info.remarks);
        ((Entity)((Entity)((Entity)((Entity)((Entity)((Entity)((Entity)((Entity)((Entity)citizen.setModelIDs(info.modelIds)).setObjectToRemove(info.removedObject)).setModelRecolors(info.modelRecolorFind, info.modelRecolorReplace)).setIdleAnimation(info.idleAnimation)).setScale(info.scale)).setTranslate(info.translate)).setBaseOrientation(info.baseOrientation)).setUUID(info.uuid)).setWorldLocation(info.worldLocation)).setRegion(info.regionId);
    }

    public static Citizen loadCitizen(CitizensPlugin plugin, CitizenInfo info) {
        Citizen citizen;
        switch (info.entityType) {
            case WanderingCitizen: {
                citizen = CitizenRegion.loadWanderingCitizen(plugin, info);
                break;
            }
            case ScriptedCitizen: {
                citizen = CitizenRegion.loadScriptedCitizen(plugin, info);
                break;
            }
            default: {
                citizen = CitizenRegion.loadStationaryCitizen(plugin, info);
            }
        }
        if (info.mergedObjects != null) {
            info.mergedObjects.forEach(citizen::addMergedObject);
        }
        if (info.moveAnimation != null) {
            citizen.movingAnimationId = info.moveAnimation;
        }
        return citizen;
    }

    private static StationaryCitizen loadStationaryCitizen(CitizensPlugin plugin, CitizenInfo info) {
        info.entityType = EntityType.StationaryCitizen;
        StationaryCitizen citizen = new StationaryCitizen(plugin);
        CitizenRegion.initCitizenInfo(citizen, info);
        citizen.setWorldLocation(info.worldLocation);
        return citizen;
    }

    private static WanderingCitizen loadWanderingCitizen(CitizensPlugin plugin, CitizenInfo info) {
        info.entityType = EntityType.WanderingCitizen;
        WanderingCitizen citizen = new WanderingCitizen(plugin);
        CitizenRegion.initCitizenInfo(citizen, info);
        ((WanderingCitizen)citizen.setWanderRegionBL(info.wanderBoxBL).setWanderRegionTR(info.wanderBoxTR).setWorldLocation(info.worldLocation)).setBoundingBox(info.wanderBoxBL, info.wanderBoxTR).setBaseOrientation(Util.getRandomItem(new CardinalDirection[]{CardinalDirection.North, CardinalDirection.South, CardinalDirection.East, CardinalDirection.West}));
        return citizen;
    }

    private static ScriptedCitizen loadScriptedCitizen(CitizensPlugin plugin, CitizenInfo info) {
        info.entityType = EntityType.ScriptedCitizen;
        ScriptedCitizen citizen = new ScriptedCitizen(plugin);
        CitizenRegion.initCitizenInfo(citizen, info);
        ((ScriptedCitizen)citizen.setWorldLocation(info.worldLocation)).setScript(info.startScript);
        citizen.baseLocation = info.worldLocation;
        return citizen;
    }

    public static Scenery loadScenery(CitizensPlugin plugin, SceneryInfo info) {
        Scenery scenery = (Scenery)((Scenery)((Scenery)((Scenery)((Scenery)((Scenery)((Scenery)((Scenery)((Scenery)new Scenery(plugin).setModelIDs(info.modelIds)).setModelRecolors(info.modelRecolorFind, info.modelRecolorReplace)).setIdleAnimation(info.idleAnimation)).setScale(info.scale)).setTranslate(info.translate)).setBaseOrientation(info.baseOrientation)).setUUID(info.uuid)).setWorldLocation(info.worldLocation)).setRegion(info.regionId);
        if (info.mergedObjects != null) {
            info.mergedObjects.forEach(scenery::addMergedObject);
        }
        return scenery;
    }

    public static void forEachActiveEntity(Consumer<Entity> function) {
        for (CitizenRegion r : regionCache.values()) {
            if (r == null) continue;
            for (Entity e : r.entities.values()) {
                if (e == null || !(e.distanceToPlayer() <= 25.0f)) continue;
                function.accept(e);
            }
        }
    }

    public static void forEachEntity(Consumer<Entity> function) {
        regionCache.forEach((regionId, r) -> {
            if (r != null) {
                r.entities.forEach((id, e) -> {
                    if (e != null) {
                        function.accept((Entity)e);
                    }
                });
            }
        });
    }

    public static void cleanUp() {
        CitizenRegion.forEachEntity(Entity::despawn);
        for (CitizenRegion r : regionCache.values()) {
            r.citizenRoster.clear();
            r.sceneryRoster.clear();
            r.entities.clear();
        }
        regionCache.clear();
        dirtyRegions.clear();
    }

    public static Citizen spawnCitizenFromPanel(CitizenInfo info) {
        Citizen citizen = CitizenRegion.loadCitizen(plugin, info);
        CitizenRegion region = CitizenRegion.loadRegion(info.regionId, true);
        region.entities.put(info.uuid, citizen);
        region.citizenRoster.add(info);
        CitizenRegion.dirtyRegion(region);
        CitizenRegion.updateAllEntities();
        return citizen;
    }

    public static Scenery spawnSceneryFromPanel(SceneryInfo info) {
        Scenery scenery = CitizenRegion.loadScenery(plugin, info);
        CitizenRegion region = CitizenRegion.loadRegion(info.regionId, true);
        region.entities.put(info.uuid, scenery);
        region.sceneryRoster.add(info);
        CitizenRegion.dirtyRegion(region);
        CitizenRegion.updateAllEntities();
        return scenery;
    }

    public static void updateEntity(EntityInfo info) {
        if (info.entityType == EntityType.Scenery) {
            CitizenRegion region = regionCache.get(info.regionId);
            Entity e = region.entities.get(info.uuid);
            Scenery updated = CitizenRegion.loadScenery(plugin, (SceneryInfo)info);
            CitizenRegion.addEntityToRegion(updated, info);
            CitizenRegion.removeEntityFromRegion(e);
        } else {
            CitizenRegion region = regionCache.get(info.regionId);
            Entity e = region.entities.get(info.uuid);
            Citizen updated = CitizenRegion.loadCitizen(plugin, (CitizenInfo)info);
            CitizenRegion.addEntityToRegion(updated, info);
            CitizenRegion.removeEntityFromRegion(e);
        }
    }

    public static void dirtyRegion(CitizenRegion region) {
        dirtyRegions.put(region.regionId, region);
    }

    public static void clearDirtyRegions() {
        dirtyRegions.clear();
    }

    public static void addEntityToRegion(Entity e, EntityInfo info) {
        CitizenRegion region = regionCache.get(e.regionId);
        region.entities.put(e.uuid, e);
        if (info instanceof CitizenInfo) {
            region.citizenRoster.add((CitizenInfo)info);
        }
        if (info instanceof SceneryInfo) {
            region.sceneryRoster.add((SceneryInfo)info);
        }
    }

    private static void removeEntityFromRegion(Citizen citizen, CitizenRegion region) {
        CitizenInfo info = region.citizenRoster.stream().filter(c -> c.uuid == citizen.uuid).findFirst().orElse(null);
        region.citizenRoster.remove(info);
    }

    private static void removeEntityFromRegion(Scenery scenery, CitizenRegion region) {
        SceneryInfo info = region.sceneryRoster.stream().filter(c -> c.uuid == scenery.uuid).findFirst().orElse(null);
        region.sceneryRoster.remove(info);
    }

    public static void removeEntityFromRegion(Entity e) {
        CitizenRegion region = regionCache.get(e.regionId);
        if (e instanceof Citizen) {
            CitizenRegion.removeEntityFromRegion((Citizen)e, region);
        }
        if (e instanceof Scenery) {
            CitizenRegion.removeEntityFromRegion((Scenery)e, region);
        }
        region.entities.remove(e.uuid);
        e.despawn();
        CitizenRegion.dirtyRegion(region);
    }

    public static int dirtyRegionCount() {
        return dirtyRegions.size();
    }

    public static void saveDirtyRegions() {
        for (Map.Entry<Integer, CitizenRegion> region : dirtyRegions.entrySet()) {
            try {
                region.getValue().saveRegion();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        CitizenRegion.clearDirtyRegions();
    }

    public static void updateAllEntities() {
        for (CitizenRegion region : regionCache.values()) {
            region.updateEntities();
        }
        if (CitizenRegion.plugin.IS_DEVELOPMENT) {
            CitizenRegion.plugin.panel.update();
        }
    }

    public void saveRegion() throws IOException {
        try {
            Path path = Paths.get(REGIONDATA_DIRECTORY, this.regionId + ".json");
            BufferedWriter wr = new BufferedWriter(new FileWriter(path.toString()));
            GsonBuilder gb = CitizenRegion.plugin.gson.newBuilder();
            gb.setPrettyPrinting();
            Gson gson = gb.create();
            gson.toJson((Object)this, (Appendable)wr);
            ((Writer)wr).flush();
            ((Writer)wr).close();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    public void updateEntities() {
        CitizenRegion.plugin.clientThread.invokeLater(() -> this.entities.values().forEach(Entity::update));
    }

    public void runOncePerTimePeriod(int timePeriodSeconds, int callIntervalSeconds, Consumer<Entity> callback) {
        double chance = (double)callIntervalSeconds / (double)timePeriodSeconds;
        ArrayList<Entity> entityList = new ArrayList<Entity>(this.entities.values());
        for (Entity entity : entityList) {
            if (!entity.isActive() || !(Math.random() < chance)) continue;
            int delayMs = Util.getRandom(0, callIntervalSeconds / 2 * 1000);
            this.executorService.schedule(() -> callback.accept(entity), (long)delayMs, TimeUnit.MILLISECONDS);
        }
    }
}

