/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.magnaboy.AnimationID;
import com.magnaboy.CardinalDirection;
import com.magnaboy.Citizen;
import com.magnaboy.CitizenRegion;
import com.magnaboy.CitizensOverlay;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.Entity;
import com.magnaboy.EntityType;
import com.magnaboy.Scenery;
import com.magnaboy.Util;
import com.magnaboy.WanderingCitizen;
import com.magnaboy.serialization.CitizenInfo;
import com.magnaboy.serialization.SceneryInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;

class CitizenPanel
extends PluginPanel {
    private static final String RELOAD_BUTTON_READY = "Reload All Entites";
    public static WorldPoint selectedPosition;
    public static Entity selectedEntity;
    public WorldPoint wanderRegionBL;
    public WorldPoint wanderRegionTR;
    public JLabel editingTargetLabel;
    public JButton updateButton;
    public JButton deleteButton;
    public JLabel reloadWarning;
    public JCheckBox manualFieldsToggle;
    private CitizensPlugin plugin;
    private JLabel label;
    private CitizensOverlay overlay;
    private HashSet<JComponent> allElements;
    private JButton reloadButton;
    private JButton saveChangesButton;
    private JButton spawnButton;
    private JLabel selectedPositionLbl;
    private JTextField entityNameField;
    private JComboBox<EntityType> entityTypeSelection;
    private JComboBox<AnimationID> animIdIdleSelect;
    private JComboBox<AnimationID> animIdMoveSelect;
    private JTextField modelIdsField;
    private JTextField recolorFindField;
    private JTextField recolorReplaceField;
    private JComboBox<CardinalDirection> orientationField;
    private JTextField examineTextField;
    private JTextField remarksField;
    private JTextField scaleFieldX;
    private JTextField scaleFieldY;
    private JTextField scaleFieldZ;
    private JTextField translateFieldX;
    private JTextField translateFieldY;
    private JTextField translateFieldZ;
    private JButton selectWanderBL;
    private JButton selectWanderTR;
    private JTextField manualAnimIdIdleSelect;
    private JTextField manualAnimIdMoveSelect;

    CitizenPanel() {
    }

    public void init(CitizensPlugin plugin, CitizensOverlay overlay) {
        this.plugin = plugin;
        this.overlay = overlay;
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new GridBagLayout());
        this.add(layoutPanel, "Center");
        this.label = new JLabel();
        this.label.setHorizontalAlignment(0);
        this.allElements = new HashSet();
        if (plugin.IS_DEVELOPMENT) {
            this.addEditorComponents(layoutPanel);
            this.entityTypeChanged();
        }
        this.update();
    }

    public void update() {
        if (!this.plugin.IS_DEVELOPMENT) {
            return;
        }
        this.UpdateEditorFields();
        AtomicInteger activeEntities = new AtomicInteger();
        AtomicInteger inactiveEntities = new AtomicInteger();
        CitizenRegion.forEachEntity(entity -> {
            if (entity == null) {
                return;
            }
            if (entity.isActive()) {
                activeEntities.addAndGet(1);
            } else {
                inactiveEntities.addAndGet(1);
            }
        });
        int totalEntities = activeEntities.get() + inactiveEntities.get();
        this.label.setText(activeEntities + "/" + totalEntities + " entities are active");
        this.UpdateEditorFields();
    }

    private void UpdateEditorFields() {
        GameState state = this.plugin.client.getGameState();
        if (state == GameState.LOGIN_SCREEN || state == GameState.LOGIN_SCREEN_AUTHENTICATOR) {
            selectedPosition = null;
        }
        int dirtySize = CitizenRegion.dirtyRegionCount();
        this.reloadButton.setEnabled(state == GameState.LOGGED_IN);
        this.selectedPositionLbl.setText(selectedPosition == null ? "N/A" : Util.worldPointToShortCoord(selectedPosition));
        String errorMessage = this.validateFields();
        boolean valid = errorMessage.isEmpty();
        boolean canSpawn = state == GameState.LOGGED_IN && valid;
        this.spawnButton.setEnabled(canSpawn);
        this.spawnButton.setText((String)(canSpawn ? "Spawn Entity" : "Can't Spawn: " + errorMessage));
        this.saveChangesButton.setEnabled(true);
        this.saveChangesButton.setText("Save Changes");
        if (selectedEntity != null && !selectedEntity.isActive()) {
            selectedEntity = null;
        }
        this.updateButton.setVisible(selectedEntity != null);
        if (selectedEntity instanceof Citizen) {
            this.editingTargetLabel.setText("Editing: " + CitizenPanel.selectedEntity.name);
        } else {
            this.editingTargetLabel.setText("Editing: Scenery Object");
        }
        this.editingTargetLabel.setVisible(selectedEntity != null);
        this.deleteButton.setVisible(selectedEntity != null);
        this.reloadWarning.setVisible(dirtySize > 0);
        this.selectWanderBL.setText(this.wanderRegionBL == null ? "Select BL" : Util.worldPointToShortCoord(this.wanderRegionBL));
        this.selectWanderTR.setText(this.wanderRegionTR == null ? "Select TR" : Util.worldPointToShortCoord(this.wanderRegionTR));
    }

    private String validateFields() {
        if (selectedPosition == null) {
            return "No Position Selected";
        }
        EntityType selectedType = (EntityType)((Object)this.entityTypeSelection.getSelectedItem());
        if (this.fieldEmpty(this.entityNameField) && selectedType != EntityType.Scenery) {
            return "Empty Name";
        }
        if (this.fieldEmpty(this.modelIdsField)) {
            return "No Model IDs";
        }
        if (this.csvToIntArray(this.modelIdsField.getText()).length == 0) {
            return "Invalid Model Ids";
        }
        if (this.csvToIntArray(this.recolorFindField.getText()).length != this.csvToIntArray(this.recolorReplaceField.getText()).length) {
            return "Model Color Mismatch";
        }
        if (selectedType == EntityType.WanderingCitizen && (this.wanderRegionBL == null || this.wanderRegionTR == null)) {
            return "Incomplete Wander Region";
        }
        return "";
    }

    private boolean fieldEmpty(JTextField f) {
        return f.getText() == null || f.getText().trim().isEmpty();
    }

    private void addEditorComponents(JPanel layoutPanel) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 7, 2);
        gbc.weightx = 0.5;
        gbc.gridwidth = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        layoutPanel.add((Component)this.label, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.reloadButton = new JButton();
        this.reloadButton.setText(RELOAD_BUTTON_READY);
        this.reloadButton.setHorizontalAlignment(0);
        this.reloadButton.setFocusable(false);
        this.reloadButton.addActionListener(e -> {
            selectedEntity = null;
            this.plugin.reload();
            this.UpdateEditorFields();
        });
        layoutPanel.add((Component)this.reloadButton, gbc);
        ++gbc.gridy;
        this.reloadWarning = new JLabel("Unsaved Changes Will Be Lost");
        this.reloadWarning.setFont(FontManager.getRunescapeSmallFont());
        this.reloadWarning.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.reloadWarning.setForeground(Color.ORANGE);
        this.reloadWarning.setVerticalAlignment(1);
        this.reloadWarning.setHorizontalAlignment(0);
        this.reloadWarning.setVisible(false);
        layoutPanel.add((Component)this.reloadWarning, gbc);
        ++gbc.gridy;
        this.editingTargetLabel = new JLabel();
        this.editingTargetLabel.setHorizontalAlignment(0);
        this.editingTargetLabel.setForeground(Color.orange);
        this.editingTargetLabel.setVisible(false);
        layoutPanel.add((Component)this.editingTargetLabel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.selectedPositionLbl = (JLabel)this.createLabeledComponent(new JLabel(), "Selected Position", layoutPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.entityNameField = (JTextField)this.createLabeledComponent(new JTextField(), "Entity Name", layoutPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.examineTextField = (JTextField)this.createLabeledComponent(new JTextField(), "Examine Text", layoutPanel, gbc);
        this.examineTextField.setText("A Citizen of Gielinor");
        ++gbc.gridy;
        gbc.gridx = 0;
        this.entityTypeSelection = (JComboBox)this.createLabeledComponent(new JComboBox<EntityType>(EntityType.values()), "Entity Type", layoutPanel, gbc);
        this.entityTypeSelection.setFocusable(false);
        this.entityTypeSelection.addActionListener(e -> this.entityTypeChanged());
        ++gbc.gridy;
        gbc.gridx = 0;
        this.orientationField = (JComboBox)this.createLabeledComponent(new JComboBox<CardinalDirection>(CardinalDirection.values()), "Base Orientation", layoutPanel, gbc);
        this.orientationField.setSelectedItem((Object)CardinalDirection.South);
        this.orientationField.setFocusable(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(15, 0, 0, 2);
        this.manualFieldsToggle = new JCheckBox("Manual Animation IDs");
        this.manualFieldsToggle.setFont(FontManager.getRunescapeSmallFont());
        this.manualFieldsToggle.setHorizontalAlignment(4);
        layoutPanel.add((Component)this.manualFieldsToggle, gbc);
        this.manualFieldsToggle.addItemListener(e -> {
            if (e.getStateChange() == 1 || e.getStateChange() == 2) {
                boolean checked = this.manualFieldsToggle.isSelected();
                this.animIdIdleSelect.getParent().setVisible(!checked);
                if (this.entityTypeSelection.getSelectedItem() != EntityType.Scenery) {
                    this.animIdMoveSelect.getParent().setVisible(!checked);
                }
                this.manualAnimIdIdleSelect.getParent().setVisible(checked);
                if (this.entityTypeSelection.getSelectedItem() != EntityType.Scenery) {
                    this.manualAnimIdMoveSelect.getParent().setVisible(checked);
                }
            }
        });
        AnimationID[] animIds = AnimationID.values();
        Arrays.sort(animIds, Comparator.comparing(Enum::name));
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 7, 2);
        this.animIdIdleSelect = (JComboBox)this.createLabeledComponent(new JComboBox<AnimationID>(animIds), "Idle Animation", layoutPanel, gbc);
        this.animIdIdleSelect.setSelectedItem((Object)AnimationID.HumanIdle);
        this.animIdIdleSelect.setFocusable(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.animIdMoveSelect = (JComboBox)this.createLabeledComponent(new JComboBox<AnimationID>(animIds), "Move Animation", layoutPanel, gbc);
        this.animIdMoveSelect.setSelectedItem((Object)AnimationID.HumanWalk);
        this.animIdMoveSelect.setFocusable(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.manualAnimIdIdleSelect = (JTextField)this.createLabeledComponent(new JTextField(), "Idle Animation", layoutPanel, gbc);
        this.manualAnimIdIdleSelect.setText("Not Yet Implemented");
        this.manualAnimIdIdleSelect.getParent().setVisible(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.manualAnimIdMoveSelect = (JTextField)this.createLabeledComponent(new JTextField(), "Move Animation", layoutPanel, gbc);
        this.manualAnimIdMoveSelect.setText("Not Yet Implemented");
        this.manualAnimIdMoveSelect.getParent().setVisible(false);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.modelIdsField = (JTextField)this.createLabeledComponent(new JTextField(), "Model Ids", layoutPanel, gbc);
        this.modelIdsField.setToolTipText("Integers only, separated by commas");
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.remarksField = (JTextField)this.createLabeledComponent(new JTextField(), "Remarks", layoutPanel, gbc);
        this.remarksField.setToolTipText("Phrases, separated by commas");
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.recolorFindField = (JTextField)this.createLabeledComponent(new JTextField(), "Find Model Colors", layoutPanel, gbc);
        this.recolorFindField.setToolTipText("Integers only, separated by commas");
        gbc.gridx = 1;
        this.recolorReplaceField = (JTextField)this.createLabeledComponent(new JTextField(), "Replace Model Colors", layoutPanel, gbc);
        this.recolorReplaceField.setToolTipText("Integers only, separated by commas");
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        this.scaleFieldX = new JTextField();
        this.scaleFieldY = new JTextField();
        this.scaleFieldZ = new JTextField();
        this.createLabeledMultiComponent("Scale", layoutPanel, gbc, this.scaleFieldX, this.scaleFieldY, this.scaleFieldZ);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        this.translateFieldX = new JTextField();
        this.translateFieldY = new JTextField();
        this.translateFieldZ = new JTextField();
        this.createLabeledMultiComponent("Translation", layoutPanel, gbc, this.translateFieldX, this.translateFieldY, this.translateFieldZ);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        this.selectWanderBL = new JButton();
        this.selectWanderBL.setText("Select BL");
        this.selectWanderBL.setFocusable(false);
        this.selectWanderBL.addActionListener(e -> {
            this.wanderRegionBL = selectedPosition;
            this.selectWanderBL.setText(Util.worldPointToShortCoord(selectedPosition));
        });
        this.selectWanderTR = new JButton();
        this.selectWanderTR.setText("Select TR");
        this.selectWanderTR.setFocusable(false);
        this.selectWanderTR.addActionListener(e -> {
            this.wanderRegionTR = selectedPosition;
            this.selectWanderTR.setText(Util.worldPointToShortCoord(selectedPosition));
        });
        this.createLabeledMultiComponent("Wander Region", layoutPanel, gbc, this.selectWanderBL, this.selectWanderTR);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.spawnButton = new JButton();
        this.spawnButton.setText("Spawn Entity");
        this.spawnButton.setFocusable(false);
        this.spawnButton.addActionListener(e -> {
            if (this.entityTypeSelection.getSelectedItem() == EntityType.Scenery) {
                SceneryInfo info = this.buildSceneryInfo();
                Scenery scenery = CitizenRegion.spawnSceneryFromPanel(info);
                selectedEntity = scenery;
            } else {
                CitizenInfo info = this.buildCitizenInfo(selectedPosition.getRegionID());
                Citizen citizen = CitizenRegion.spawnCitizenFromPanel(info);
                selectedEntity = citizen;
            }
            selectedPosition = null;
            this.update();
        });
        layoutPanel.add((Component)this.spawnButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.updateButton = new JButton();
        this.updateButton.setText("Update Entity");
        this.updateButton.setFocusable(false);
        this.updateButton.addActionListener(e -> {
            if (selectedEntity.isCitizen()) {
                CitizenInfo info = this.buildCitizenInfo(CitizenPanel.selectedEntity.regionId);
                if (selectedEntity != null) {
                    info.uuid = CitizenPanel.selectedEntity.uuid;
                    CitizenRegion.updateEntity(info);
                }
            } else if (CitizenPanel.selectedEntity.entityType == EntityType.Scenery) {
                SceneryInfo info = this.buildSceneryInfo();
                if (selectedEntity != null) {
                    info.uuid = CitizenPanel.selectedEntity.uuid;
                    CitizenRegion.updateEntity(info);
                }
            }
            this.update();
            this.plugin.reload();
        });
        layoutPanel.add((Component)this.updateButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.deleteButton = new JButton();
        this.deleteButton.setText("Delete Entity");
        this.deleteButton.setFocusable(false);
        this.deleteButton.setVisible(false);
        this.deleteButton.setBackground(new Color(135, 58, 58));
        this.deleteButton.addActionListener(e -> {
            CitizenRegion.removeEntityFromRegion(selectedEntity);
            selectedEntity.despawn();
        });
        layoutPanel.add((Component)this.deleteButton, gbc);
        ++gbc.gridy;
        this.saveChangesButton = new JButton();
        this.saveChangesButton.setText("Save Changes");
        this.saveChangesButton.setFocusable(false);
        this.saveChangesButton.addActionListener(e -> CitizenRegion.saveDirtyRegions());
        gbc.gridx = 0;
        layoutPanel.add((Component)this.saveChangesButton, gbc);
    }

    private int[] csvToIntArray(String csv) {
        String[] separated = csv.split(",", -1);
        int[] validInts = new int[separated.length];
        for (int i = 0; i < validInts.length; ++i) {
            try {
                validInts[i] = Integer.parseInt(separated[i].trim());
                continue;
            }
            catch (Exception e) {
                return new int[0];
            }
        }
        return validInts;
    }

    private float parseOrDefault(Object o, float defaultResult) {
        float result = defaultResult;
        String s = "";
        if (o instanceof JTextField) {
            s = ((JTextField)o).getText();
        }
        if (o instanceof String) {
            s = (String)o;
        }
        try {
            result = Float.parseFloat(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private CitizenInfo buildCitizenInfo(int regionId) {
        CitizenInfo info = new CitizenInfo();
        info.uuid = UUID.randomUUID();
        info.regionId = regionId;
        info.name = this.entityNameField.getText();
        info.examineText = this.examineTextField.getText();
        info.worldLocation = selectedPosition;
        info.entityType = (EntityType)((Object)this.entityTypeSelection.getSelectedItem());
        info.idleAnimation = (AnimationID)((Object)this.animIdIdleSelect.getSelectedItem());
        info.moveAnimation = (AnimationID)((Object)this.animIdMoveSelect.getSelectedItem());
        info.modelIds = this.csvToIntArray(this.modelIdsField.getText());
        info.modelRecolorFind = this.csvToIntArray(this.recolorFindField.getText());
        info.modelRecolorReplace = this.csvToIntArray(this.recolorReplaceField.getText());
        info.baseOrientation = ((CardinalDirection)((Object)this.orientationField.getSelectedItem())).getAngle();
        info.remarks = this.remarksField.getText().length() > 0 ? this.remarksField.getText().split(",", -1) : null;
        info.scale = (float[])(this.fieldEmpty(this.scaleFieldX) && this.fieldEmpty(this.scaleFieldY) && this.fieldEmpty(this.scaleFieldZ) ? null : new float[]{this.parseOrDefault(this.scaleFieldX, 1.0f), this.parseOrDefault(this.scaleFieldY, 1.0f), this.parseOrDefault(this.scaleFieldZ, 1.0f)});
        info.translate = (float[])(this.fieldEmpty(this.translateFieldX) && this.fieldEmpty(this.translateFieldY) && this.fieldEmpty(this.translateFieldZ) ? null : new float[]{this.parseOrDefault(this.translateFieldX, 0.0f), this.parseOrDefault(this.translateFieldY, 0.0f), this.parseOrDefault(this.translateFieldZ, 0.0f)});
        if (info.entityType == EntityType.WanderingCitizen) {
            info.wanderBoxTR = this.wanderRegionTR;
            info.wanderBoxBL = this.wanderRegionBL;
        }
        return info;
    }

    private SceneryInfo buildSceneryInfo() {
        SceneryInfo info = new SceneryInfo();
        info.uuid = UUID.randomUUID();
        info.regionId = selectedPosition.getRegionID();
        info.entityType = EntityType.Scenery;
        info.worldLocation = selectedPosition;
        info.modelIds = this.csvToIntArray(this.modelIdsField.getText());
        info.modelRecolorFind = this.csvToIntArray(this.recolorFindField.getText());
        info.modelRecolorReplace = this.csvToIntArray(this.recolorReplaceField.getText());
        info.baseOrientation = ((CardinalDirection)((Object)this.orientationField.getSelectedItem())).getAngle();
        info.idleAnimation = (AnimationID)((Object)this.animIdIdleSelect.getSelectedItem());
        info.scale = (float[])(this.fieldEmpty(this.scaleFieldX) && this.fieldEmpty(this.scaleFieldY) && this.fieldEmpty(this.scaleFieldZ) ? null : new float[]{this.parseOrDefault(this.scaleFieldX, 1.0f), this.parseOrDefault(this.scaleFieldY, 1.0f), this.parseOrDefault(this.scaleFieldZ, 1.0f)});
        info.translate = (float[])(this.fieldEmpty(this.translateFieldX) && this.fieldEmpty(this.translateFieldY) && this.fieldEmpty(this.translateFieldZ) ? null : new float[]{this.parseOrDefault(this.translateFieldX, 0.0f), this.parseOrDefault(this.translateFieldY, 0.0f), this.parseOrDefault(this.translateFieldZ, 0.0f)});
        return info;
    }

    private <T extends JComponent> T createLabeledComponent(JComponent component, String label, JPanel panel, GridBagConstraints constraints) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JLabel uiLabel = new JLabel(label);
        uiLabel.setFont(FontManager.getRunescapeSmallFont());
        uiLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        uiLabel.setForeground(Color.WHITE);
        container.add((Component)uiLabel, "North");
        container.add((Component)component, "Center");
        panel.add((Component)container, constraints);
        this.allElements.add(container);
        this.allElements.add(component);
        return (T)component;
    }

    private void createLabeledMultiComponent(String label, JPanel panel, GridBagConstraints constraints, JComponent ... comps) {
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        GridBagConstraints containerGbc = new GridBagConstraints();
        containerGbc.fill = 2;
        containerGbc.insets = new Insets(0, 0, 0, 2);
        containerGbc.weightx = 0.5;
        containerGbc.gridwidth = comps.length;
        JLabel uiLabel = new JLabel(label);
        uiLabel.setFont(FontManager.getRunescapeSmallFont());
        uiLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        uiLabel.setForeground(Color.WHITE);
        containerGbc.gridx = 0;
        container.add((Component)uiLabel, containerGbc);
        containerGbc.weightx = 0.5;
        containerGbc.gridwidth = 1;
        int i = 0;
        for (JComponent comp : comps) {
            containerGbc.gridx = i++;
            container.add((Component)comp, containerGbc);
            this.allElements.add(comp);
        }
        panel.add((Component)container, constraints);
    }

    private void entityTypeChanged() {
        for (JComponent jc : this.allElements) {
            jc.setVisible(true);
            jc.getParent().setVisible(true);
        }
        EntityType type = (EntityType)((Object)this.entityTypeSelection.getSelectedItem());
        boolean checked = this.manualFieldsToggle.isSelected();
        switch (type) {
            case StationaryCitizen: 
            case ScriptedCitizen: {
                this.selectWanderTR.getParent().setVisible(false);
                this.selectWanderBL.getParent().setVisible(false);
                this.animIdIdleSelect.getParent().setVisible(!checked);
                this.animIdMoveSelect.getParent().setVisible(!checked);
                this.manualAnimIdIdleSelect.getParent().setVisible(checked);
                this.manualAnimIdMoveSelect.getParent().setVisible(checked);
                break;
            }
            case Scenery: {
                this.entityNameField.getParent().setVisible(false);
                this.examineTextField.getParent().setVisible(false);
                this.manualAnimIdMoveSelect.getParent().setVisible(false);
                this.animIdIdleSelect.getParent().setVisible(!checked);
                this.manualAnimIdIdleSelect.getParent().setVisible(checked);
                this.remarksField.getParent().setVisible(false);
                this.selectWanderTR.getParent().setVisible(false);
                this.selectWanderBL.getParent().setVisible(false);
            }
        }
        if (type == EntityType.StationaryCitizen || type == EntityType.Scenery) {
            this.animIdMoveSelect.getParent().setVisible(false);
        }
    }

    public void setSelectedEntity(Entity e) {
        if (selectedEntity == e) {
            selectedEntity = null;
        } else {
            selectedEntity = e;
            selectedPosition = e.getWorldLocation();
        }
        this.entityTypeSelection.setSelectedItem((Object)e.entityType);
        this.orientationField.setSelectedItem((Object)CardinalDirection.fromInteger(e.baseOrientation));
        this.animIdIdleSelect.setSelectedItem((Object)e.idleAnimationId);
        this.modelIdsField.setText(e.getModelIDsString());
        this.recolorFindField.setText(e.getRecolorFindString());
        this.recolorReplaceField.setText(e.getRecolorReplaceString());
        if (e.translate != null) {
            this.translateFieldX.setText(String.valueOf(e.translate[0]));
            this.translateFieldY.setText(String.valueOf(e.translate[1]));
            this.translateFieldZ.setText(String.valueOf(e.translate[2]));
        }
        if (e.scale != null) {
            this.scaleFieldX.setText(String.valueOf(e.scale[0]));
            this.scaleFieldY.setText(String.valueOf(e.scale[1]));
            this.scaleFieldZ.setText(String.valueOf(e.scale[2]));
        }
        if (e.isCitizen()) {
            Citizen c = (Citizen)e;
            this.entityNameField.setText(c.name);
            this.examineTextField.setText(c.examine);
            this.animIdMoveSelect.setSelectedItem((Object)c.movingAnimationId);
            if (c.remarks != null) {
                this.remarksField.setText(String.join((CharSequence)",", c.remarks));
            }
        }
        if (e.entityType == EntityType.WanderingCitizen) {
            WanderingCitizen w = (WanderingCitizen)e;
            this.wanderRegionBL = w.wanderRegionBL;
            this.wanderRegionTR = w.wanderRegionTR;
        }
        this.update();
    }

    public void cleanup() {
        selectedPosition = null;
        selectedEntity = null;
    }
}

