/*
 * Decompiled with CFR 0.152.
 */
package com.magnaboy;

import com.magnaboy.AnimationID;
import com.magnaboy.CitizensPlugin;
import com.magnaboy.Entity;
import com.magnaboy.EntityType;
import com.magnaboy.Util;
import com.magnaboy.WanderingCitizen;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class Citizen<T extends Citizen<T>>
extends Entity<T> {
    private static final int[][] BLOCKING_DIRECTIONS_5x5 = new int[][]{{16, 16, 32, 64, 64}, {16, 16, 32, 64, 64}, {8, 8, 0, 128, 128}, {4, 4, 2, 1, 1}, {4, 4, 2, 1, 1}};
    private static final int[][] JAU_DIRECTIONS_5X5 = new int[][]{{768, 768, 1024, 1280, 1280}, {768, 768, 1024, 1280, 1280}, {512, 512, 0, 1536, 1536}, {256, 256, 0, 1792, 1792}, {256, 256, 0, 1792, 1792}};
    private static final int CENTER_INDEX_5X5 = 2;
    public final CitizensPlugin plugin;
    private final Client client;
    private final List<Target> targetQueue = new ArrayList<Target>();
    @Nullable
    public String activeRemark = null;
    public String[] remarks;
    @Nullable
    public AnimationID movingAnimationId = AnimationID.HumanWalk;
    private int remarkTimer = 0;

    public Citizen(CitizensPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
        this.client = plugin.client;
        this.rlObject = this.client.createRuneLiteObject();
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    public T setExamine(String examine) {
        this.examine = examine;
        return (T)this;
    }

    public T setRemarks(String[] remarks) {
        this.remarks = remarks;
        return (T)this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.name == null) {
            throw new IllegalStateException(this.debugName() + " has no name.");
        }
        if (this.examine == null) {
            throw new IllegalStateException(this.debugName() + " has no examine.");
        }
        if (this.entityType == EntityType.WanderingCitizen) {
            WanderingCitizen casted = (WanderingCitizen)this;
            if (casted.boundingBox == null) {
                throw new IllegalStateException(this.debugName() + " has no boundingBox.");
            }
            if (casted.wanderRegionBL == null) {
                throw new IllegalStateException(this.debugName() + " has no wanderRegionBL.");
            }
            if (casted.wanderRegionTR == null) {
                throw new IllegalStateException(this.debugName() + " has no wanderRegionTR.");
            }
        }
        for (String remark : this.remarks) {
            if (!remark.isEmpty()) continue;
            throw new IllegalStateException(this.debugName() + " has empty remark.");
        }
    }

    @Override
    public boolean despawn() {
        this.targetQueue.clear();
        this.activeRemark = null;
        this.remarkTimer = 0;
        return super.despawn();
    }

    public Target getCurrentTarget() {
        if (this.targetQueue.isEmpty()) {
            return null;
        }
        return this.targetQueue.get(0);
    }

    @Override
    public WorldPoint getWorldLocation() {
        Target currentTarget = this.getCurrentTarget();
        if (currentTarget != null) {
            return currentTarget.worldDestinationPosition;
        }
        return super.getWorldLocation();
    }

    public void say(String message) {
        if (this.distanceToPlayer() > 25.0f) {
            return;
        }
        this.activeRemark = message;
        this.remarkTimer = 120;
    }

    public void sayRandomRemark() {
        if (this.activeRemark == null && this.remarks != null && this.remarks.length > 0) {
            this.say(Util.getRandomItem(this.remarks));
        }
    }

    public void moveTo(WorldPoint worldPosition) {
        this.moveTo(worldPosition, 0, false, false);
    }

    public void moveTo(WorldPoint worldPosition, Integer jauOrientation, boolean isInteracting, boolean isPoseAnimation) {
        if (this.entityType == EntityType.StationaryCitizen) {
            throw new IllegalStateException(this.debugName() + " is a stationary citizen and cannot move.");
        }
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPosition);
        if (localPosition == null) {
            return;
        }
        WorldPoint prevWorldPosition = this.getWorldLocation();
        int distance = prevWorldPosition.distanceTo(worldPosition);
        if (distance > 0 && distance <= 2) {
            int dx = worldPosition.getX() - prevWorldPosition.getX();
            int dy = worldPosition.getY() - prevWorldPosition.getY();
            if (distance == 1 && dx != 0 && dy != 0) {
                int[][] colliders = this.client.getCollisionMaps()[worldPosition.getPlane()].getFlags();
                int diagonalTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2 + dx];
                int axisXTest = BLOCKING_DIRECTIONS_5x5[2][2 + dx] | BLOCKING_DIRECTIONS_5x5[2 + dy][2] | 0x240100;
                int axisYTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2] | BLOCKING_DIRECTIONS_5x5[2][2 - dx] | 0x240100;
                int diagonalFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY()];
                int axisXFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY() - dy];
                int axisYFlag = colliders[localPosition.getSceneX() - dx][localPosition.getSceneY()];
                if ((axisXFlag & axisXTest) != 0 || (axisYFlag & axisYTest) != 0 || (diagonalFlag & diagonalTest) != 0) {
                    distance = 2;
                    if ((axisXFlag & axisXTest) == 0) {
                        dy = 0;
                    } else {
                        dx = 0;
                    }
                }
            } else if (distance == 2 && Math.abs(Math.abs(dy) - Math.abs(dx)) == 1) {
                int[][] colliders = this.client.getCollisionMaps()[worldPosition.getPlane()].getFlags();
                int diagonalTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2 + dx];
                int axisXTest = BLOCKING_DIRECTIONS_5x5[2][2 + dx] | BLOCKING_DIRECTIONS_5x5[2 + dy][2] | 0x240100;
                int axisYTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2] | BLOCKING_DIRECTIONS_5x5[2][2 - dx] | 0x240100;
                int dxSign = Integer.signum(dx);
                int dySign = Integer.signum(dy);
                int diagonalFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY()];
                int axisXFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY() - Integer.signum(dySign)];
                int axisYFlag = colliders[localPosition.getSceneX() - Integer.signum(dxSign)][localPosition.getSceneY()];
                if ((axisXFlag & axisXTest) == 0 && (axisYFlag & axisYTest) == 0 && (diagonalFlag & diagonalTest) == 0) {
                    if (Math.abs(dx) == 2) {
                        dx = dxSign;
                        dy = 0;
                    } else {
                        dx = 0;
                        dy = dySign;
                    }
                } else if (Math.abs(dx) == 2) {
                    dx = dxSign;
                } else {
                    dy = dySign;
                }
            }
            if (!isInteracting || jauOrientation == null) {
                dx = worldPosition.getX() - prevWorldPosition.getX();
                dy = worldPosition.getY() - prevWorldPosition.getY();
                jauOrientation = JAU_DIRECTIONS_5X5[2 - dy][2 + dx];
            }
        }
        Target newTarget = new Target();
        newTarget.worldDestinationPosition = worldPosition;
        newTarget.localDestinationPosition = localPosition;
        newTarget.jauDestinationOrientation = jauOrientation == null ? 0 : jauOrientation;
        newTarget.isInteracting = isInteracting;
        newTarget.isPoseAnimation = isPoseAnimation;
        this.targetQueue.add(newTarget);
    }

    public void onClientTick() {
        if (this.remarkTimer > 0) {
            --this.remarkTimer;
        }
        if (this.remarkTimer == 0) {
            this.activeRemark = null;
        }
        if (!this.rlObject.isActive()) {
            return;
        }
        if (this.entityType != EntityType.ScriptedCitizen && this.entityType != EntityType.WanderingCitizen) {
            return;
        }
        Target nextTarget = this.getCurrentTarget();
        if (nextTarget != null) {
            int targetPlane = nextTarget.worldDestinationPosition.getPlane();
            LocalPoint targetPosition = nextTarget.localDestinationPosition;
            int targetOrientation = nextTarget.jauDestinationOrientation;
            if (this.client.getPlane() != targetPlane || targetPosition == null || !targetPosition.isInScene() || targetOrientation < 0) {
                this.despawn();
                return;
            }
            LocalPoint currentPosition = this.getLocalLocation();
            int dx = targetPosition.getX() - currentPosition.getX();
            int dy = targetPosition.getY() - currentPosition.getY();
            if (dx != 0 || dy != 0) {
                if (this.rlObject.getAnimation().getId() != this.movingAnimationId.getId().intValue()) {
                    this.setAnimation(this.movingAnimationId.getId());
                }
                int speed = 4;
                if (Math.abs(dx) > speed) {
                    dx = Integer.signum(dx) * speed;
                }
                if (Math.abs(dy) > speed) {
                    dy = Integer.signum(dy) * speed;
                }
                LocalPoint newLocation = new LocalPoint(currentPosition.getX() + dx, currentPosition.getY() + dy);
                this.setLocation(newLocation);
            } else {
                this.targetQueue.remove(0);
            }
            LocalPoint localLoc = this.getLocalLocation();
            double intx = localLoc.getX() - targetPosition.getX();
            double inty = localLoc.getY() - targetPosition.getY();
            this.rotateObject(intx, inty);
            if (this.targetQueue.isEmpty()) {
                this.stopMoving();
            }
        }
    }

    public void stopMoving() {
        this.setAnimation(this.idleAnimationId.getId());
    }

    public static class Target {
        public WorldPoint worldDestinationPosition;
        public LocalPoint localDestinationPosition;
        public int jauDestinationOrientation;
        public boolean isPoseAnimation;
        public boolean isInteracting;

        public String toString() {
            return "Target{worldDestinationPosition=" + this.worldDestinationPosition + ", localDestinationPosition=" + this.localDestinationPosition + ", jauDestinationOrientation=" + this.jauDestinationOrientation + ", isPoseAnimation=" + this.isPoseAnimation + ", isInteracting=" + this.isInteracting + "}";
        }
    }
}

