/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import com.maxhitcalc.AttackStyle;
import com.maxhitcalc.CombatSpell;
import com.maxhitcalc.EquipmentItems;
import com.maxhitcalc.MaxHit;
import com.maxhitcalc.MaxHitCalcConfig;
import com.maxhitcalc.WeaponType;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;

public class PredictNextMax
extends MaxHit {
    private static List<Object> predictNextMeleeMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle, int attackStyleID) {
        Object weaponName;
        double bonus2;
        double predictedMaxHit;
        List<Double> specialBonusMultipliers;
        double flooredBaseDamage;
        double baseDamage;
        double strengthBonus;
        double effectiveStrength;
        double voidBonus;
        int styleBonus;
        double prayerBonus;
        int strengthLevel;
        int i;
        int nextStrengthLevel = 0;
        int nextStrengthBonus = 0;
        double nextPrayerBonus = 0.0;
        double currentMaxHit = PredictNextMax.calculateMeleeMaxHit(client, itemManager, playerEquipment, weaponAttackStyle, attackStyleID);
        for (i = 1; i <= 20; ++i) {
            strengthLevel = client.getBoostedSkillLevel(Skill.STRENGTH);
            prayerBonus = PredictNextMax.getPrayerBonus(client, weaponAttackStyle) + (double)i * 0.01;
            styleBonus = PredictNextMax.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
            voidBonus = PredictNextMax.getVoidMeleeBonus(client, playerEquipment);
            effectiveStrength = Math.floor((Math.floor((double)strengthLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
            strengthBonus = PredictNextMax.getMeleeStrengthBonus(client, itemManager, playerEquipment);
            baseDamage = 0.5 + effectiveStrength * ((strengthBonus + 64.0) / 640.0);
            flooredBaseDamage = Math.floor(baseDamage);
            specialBonusMultipliers = PredictNextMax.getMeleeSpecialBonusMultiplier(client, playerEquipment);
            predictedMaxHit = flooredBaseDamage;
            if (!specialBonusMultipliers.isEmpty()) {
                for (double bonus2 : specialBonusMultipliers) {
                    predictedMaxHit += Math.floor(predictedMaxHit * bonus2);
                }
            }
            if (((String)(weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON))).contains("Osmumten's fang")) {
                predictedMaxHit = predictedMaxHit * 0.85 + 1.0;
            }
            if (((String)weaponName).contains("Colossal blade")) {
                predictedMaxHit += 2.0;
            }
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextPrayerBonus = (double)i * 0.01;
            break;
        }
        for (i = 1; i <= 20; ++i) {
            strengthLevel = client.getBoostedSkillLevel(Skill.STRENGTH);
            prayerBonus = PredictNextMax.getPrayerBonus(client, weaponAttackStyle);
            styleBonus = PredictNextMax.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
            voidBonus = PredictNextMax.getVoidMeleeBonus(client, playerEquipment);
            effectiveStrength = Math.floor((Math.floor((double)strengthLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
            strengthBonus = PredictNextMax.getMeleeStrengthBonus(client, itemManager, playerEquipment) + (double)i;
            baseDamage = 0.5 + effectiveStrength * ((strengthBonus + 64.0) / 640.0);
            flooredBaseDamage = Math.floor(baseDamage);
            specialBonusMultipliers = PredictNextMax.getMeleeSpecialBonusMultiplier(client, playerEquipment);
            predictedMaxHit = flooredBaseDamage;
            if (!specialBonusMultipliers.isEmpty()) {
                weaponName = specialBonusMultipliers.iterator();
                while (weaponName.hasNext()) {
                    bonus2 = weaponName.next();
                    predictedMaxHit += Math.floor(predictedMaxHit * bonus2);
                }
            }
            if (((String)(weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON))).contains("Osmumten's fang")) {
                predictedMaxHit = predictedMaxHit * 0.85 + 1.0;
            }
            if (((String)weaponName).contains("Colossal blade")) {
                predictedMaxHit += 2.0;
            }
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextStrengthBonus = i;
            break;
        }
        for (i = 1; i <= 20; ++i) {
            strengthLevel = client.getBoostedSkillLevel(Skill.STRENGTH) + i;
            prayerBonus = PredictNextMax.getPrayerBonus(client, weaponAttackStyle);
            styleBonus = PredictNextMax.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
            voidBonus = PredictNextMax.getVoidMeleeBonus(client, playerEquipment);
            effectiveStrength = Math.floor((Math.floor((double)strengthLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
            strengthBonus = PredictNextMax.getMeleeStrengthBonus(client, itemManager, playerEquipment);
            baseDamage = 0.5 + effectiveStrength * ((strengthBonus + 64.0) / 640.0);
            flooredBaseDamage = Math.floor(baseDamage);
            specialBonusMultipliers = PredictNextMax.getMeleeSpecialBonusMultiplier(client, playerEquipment);
            predictedMaxHit = flooredBaseDamage;
            if (!specialBonusMultipliers.isEmpty()) {
                weaponName = specialBonusMultipliers.iterator();
                while (weaponName.hasNext()) {
                    bonus2 = (Double)weaponName.next();
                    predictedMaxHit += Math.floor(predictedMaxHit * bonus2);
                }
            }
            if (((String)(weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON))).contains("Osmumten's fang")) {
                predictedMaxHit = predictedMaxHit * 0.85 + 1.0;
            }
            if (((String)weaponName).contains("Colossal blade")) {
                predictedMaxHit += 2.0;
            }
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextStrengthLevel = i;
            break;
        }
        List<Object> results = Arrays.asList("melee", nextStrengthLevel, nextStrengthBonus, nextPrayerBonus);
        return results;
    }

    private static List<Object> predictNextRangeMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle, int attackStyleID, MaxHitCalcConfig.BlowpipeDartType dartType) {
        double predictedMaxHit;
        double gearBonus;
        double equipmentRangedStrength;
        double effectiveRangedStrength;
        double voidBonus;
        int styleBonus;
        double prayerBonus;
        int rangedLevel;
        int i;
        int nextRangedLevel = 0;
        int nextRangeEquipmentBonus = 0;
        double nextPrayerBonus = 0.0;
        double currentMaxHit = PredictNextMax.calculateRangedMaxHit(client, itemManager, playerEquipment, weaponAttackStyle, attackStyleID, dartType);
        for (i = 1; i <= 20; ++i) {
            rangedLevel = client.getBoostedSkillLevel(Skill.RANGED) + i;
            prayerBonus = PredictNextMax.getPrayerBonus(client, weaponAttackStyle);
            styleBonus = PredictNextMax.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
            voidBonus = PredictNextMax.getVoidRangedBonus(client, playerEquipment);
            effectiveRangedStrength = Math.floor((Math.floor((double)rangedLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
            predictedMaxHit = 0.5 + effectiveRangedStrength * ((equipmentRangedStrength = PredictNextMax.getRangedStrengthBonus(client, itemManager, playerEquipment, dartType)) + 64.0) / 640.0 * (gearBonus = PredictNextMax.getRangeGearBoost(client, playerEquipment));
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextRangedLevel = i;
            break;
        }
        for (i = 1; i <= 20; ++i) {
            rangedLevel = client.getBoostedSkillLevel(Skill.RANGED);
            prayerBonus = PredictNextMax.getPrayerBonus(client, weaponAttackStyle) + (double)i * 0.01;
            styleBonus = PredictNextMax.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
            voidBonus = PredictNextMax.getVoidRangedBonus(client, playerEquipment);
            effectiveRangedStrength = Math.floor((Math.floor((double)rangedLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
            predictedMaxHit = 0.5 + effectiveRangedStrength * ((equipmentRangedStrength = PredictNextMax.getRangedStrengthBonus(client, itemManager, playerEquipment, dartType)) + 64.0) / 640.0 * (gearBonus = PredictNextMax.getRangeGearBoost(client, playerEquipment));
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextPrayerBonus = (double)i * 0.01;
            break;
        }
        for (i = 1; i <= 20; ++i) {
            rangedLevel = client.getBoostedSkillLevel(Skill.RANGED);
            prayerBonus = PredictNextMax.getPrayerBonus(client, weaponAttackStyle);
            styleBonus = PredictNextMax.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
            voidBonus = PredictNextMax.getVoidRangedBonus(client, playerEquipment);
            effectiveRangedStrength = Math.floor((Math.floor((double)rangedLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
            predictedMaxHit = 0.5 + effectiveRangedStrength * ((equipmentRangedStrength = PredictNextMax.getRangedStrengthBonus(client, itemManager, playerEquipment, dartType) + (double)i) + 64.0) / 640.0 * (gearBonus = PredictNextMax.getRangeGearBoost(client, playerEquipment));
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextRangeEquipmentBonus = i;
            break;
        }
        List<Object> results = Arrays.asList("ranged", nextRangedLevel, nextRangeEquipmentBonus, nextPrayerBonus);
        return results;
    }

    private static List<Object> predictNextMageMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle, int attackStyleID) {
        double correctTomeSpellBonus;
        double predictedMaxHit;
        double magicDmgBonus;
        double spellBaseMaxHit;
        int i;
        int nextMagicLevel = 0;
        double nextMagicDamageBonus = 0.0;
        double currentMaxHit = PredictNextMax.calculateMagicMaxHit(client, itemManager, playerEquipment, weaponAttackStyle);
        CombatSpell spell = PredictNextMax.getSpell(client);
        if (spell == null || spell.getName().toLowerCase().contains("magic dart")) {
            for (i = 1; i <= 20; ++i) {
                spellBaseMaxHit = PredictNextMax.getSpellBaseHit(client, playerEquipment, weaponAttackStyle, client.getBoostedSkillLevel(Skill.MAGIC) + i);
                magicDmgBonus = PredictNextMax.getMagicEquipmentBoost(client, itemManager, playerEquipment) + (double)i * 0.01;
                predictedMaxHit = spellBaseMaxHit * magicDmgBonus;
                correctTomeSpellBonus = PredictNextMax.getTomeSpellBonus(client, playerEquipment, weaponAttackStyle);
                if (!(Math.floor(predictedMaxHit *= correctTomeSpellBonus) > currentMaxHit)) continue;
                nextMagicLevel = i;
                break;
            }
        }
        for (i = 1; i <= 50; ++i) {
            spellBaseMaxHit = PredictNextMax.getSpellBaseHit(client, playerEquipment, weaponAttackStyle, client.getBoostedSkillLevel(Skill.MAGIC));
            magicDmgBonus = PredictNextMax.getMagicEquipmentBoost(client, itemManager, playerEquipment) + (double)i * 0.01;
            predictedMaxHit = spellBaseMaxHit * magicDmgBonus;
            correctTomeSpellBonus = PredictNextMax.getTomeSpellBonus(client, playerEquipment, weaponAttackStyle);
            predictedMaxHit *= correctTomeSpellBonus;
            String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
            if ((weaponItemName.toLowerCase().contains("smoke battlestaff") || weaponItemName.toLowerCase().contains("smoke staff")) && spell != null && spell.getSpellbook().contains("standard")) {
                double SmokeStandardSpellsBonus = predictedMaxHit * (double)0.1f;
                predictedMaxHit += SmokeStandardSpellsBonus;
            }
            if (!(Math.floor(predictedMaxHit) > currentMaxHit)) continue;
            nextMagicDamageBonus = (double)i * 0.01;
            break;
        }
        List<Object> results = Arrays.asList("magic", nextMagicLevel, nextMagicDamageBonus);
        return results;
    }

    public static List<Object> predict(Client client, ItemManager itemManager, MaxHitCalcConfig config) {
        int attackStyleID = client.getVarpValue(43);
        int weaponTypeID = client.getVarbitValue(357);
        WeaponType weaponType = WeaponType.getWeaponType(weaponTypeID);
        AttackStyle[] weaponAttackStyles = weaponType.getAttackStyles();
        AttackStyle attackStyle = weaponAttackStyles[attackStyleID];
        Item[] playerEquipment = EquipmentItems.getCurrentlyEquipped(client);
        if (attackStyle.equals((Object)AttackStyle.ACCURATE) || attackStyle.equals((Object)AttackStyle.AGGRESSIVE) || attackStyle.equals((Object)AttackStyle.CONTROLLED) || attackStyle.equals((Object)AttackStyle.DEFENSIVE)) {
            List<Object> meleeResults = PredictNextMax.predictNextMeleeMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID);
            return meleeResults;
        }
        if (attackStyle.equals((Object)AttackStyle.RANGING) || attackStyle.equals((Object)AttackStyle.LONGRANGE)) {
            List<Object> rangedResults = PredictNextMax.predictNextRangeMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID, config.blowpipeDartType());
            return rangedResults;
        }
        if (attackStyle.equals((Object)AttackStyle.CASTING) || attackStyle.equals((Object)AttackStyle.DEFENSIVE_CASTING)) {
            List<Object> mageResults = PredictNextMax.predictNextMageMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID);
            return mageResults;
        }
        return null;
    }
}

