/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import com.maxhitcalc.EquipmentItems;
import com.maxhitcalc.MaxHit;
import com.maxhitcalc.MaxHitCalcConfig;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;

public class MaxSpec {
    static double getSpecWeaponStat(Client client, Item[] playerEquipment) {
        String weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        String ammoItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.AMMO);
        if (weaponName.contains("Armadyl godsword")) {
            return 1.375;
        }
        if (weaponName.contains("Ancient godsword")) {
            return 1.1;
        }
        if (weaponName.contains("Bandos godsword")) {
            return 1.21;
        }
        if (weaponName.contains("Saradomin godsword")) {
            return 1.1;
        }
        if (weaponName.contains("Zamorak godsword")) {
            return 1.1;
        }
        if (weaponName.contains("Saradomin sword")) {
            return 1.1;
        }
        if (weaponName.contains("Dragon dagger")) {
            return 1.15;
        }
        if (weaponName.contains("Dragon sword")) {
            return 1.25;
        }
        if (weaponName.contains("Dragon halberd")) {
            return 1.1;
        }
        if (weaponName.contains("Crystal halberd") && !weaponName.contains("(basic)") && !weaponName.contains("(attuned)") && !weaponName.contains("(perfected)")) {
            return 1.1;
        }
        if (weaponName.contains("Barrelchest")) {
            return 1.1;
        }
        if (weaponName.contains("Dragon hasta")) {
            return 1.0 + 0.5 * ((double)client.getVarpValue(300) / 1000.0);
        }
        if (weaponName.contains("Dragon longsword")) {
            return 1.25;
        }
        if (weaponName.contains("Dragon mace")) {
            return 1.5;
        }
        if (weaponName.contains("Dragon warhammer")) {
            return 1.5;
        }
        if (weaponName.contains("Rune claws")) {
            return 1.1;
        }
        if (weaponName.contains("Abyssal dagger")) {
            return 0.85;
        }
        if (weaponName.contains("Abyssal bludgeon")) {
            double currentPrayer = client.getBoostedSkillLevel(Skill.PRAYER);
            double totalPrayer = client.getRealSkillLevel(Skill.PRAYER);
            return 1.0 + 0.005 * (totalPrayer - currentPrayer);
        }
        if (weaponName.contains("Saradomin's blessed sword")) {
            return 1.25;
        }
        if (weaponName.contains("Osmumten's fang")) {
            return 1.16666667;
        }
        if (weaponName.contains("Voidwaker")) {
            return 1.5;
        }
        if (weaponName.contains("Vesta's longsword")) {
            return 1.2;
        }
        if (weaponName.contains("Statius's warhammer")) {
            return 1.25;
        }
        if (weaponName.contains("Dark bow")) {
            if (ammoItemName.contains("Dragon arrow")) {
                return 1.5;
            }
            if (ammoItemName.contains("arrow")) {
                return 1.3;
            }
        }
        if (weaponName.contains("Zaryte crossbow") && ammoItemName.contains("bolts (e)")) {
            return 1.1;
        }
        if (weaponName.contains("crossbow")) {
            if (ammoItemName.contains("Diamond bolts (e)")) {
                return 1.15;
            }
            if (ammoItemName.contains("Dragonstone bolts (e)")) {
                return 1.45;
            }
            if (ammoItemName.contains("Onyx bolts (e)")) {
                return 1.15;
            }
            if (ammoItemName.contains("Opal bolts (e)")) {
                return 1.25;
            }
        }
        if (weaponName.contains("Morrigan's throwing axe")) {
            return 1.25;
        }
        if (weaponName.contains("Webweaver bow")) {
            return 0.4;
        }
        if (weaponName.contains("Toxic blowpipe")) {
            return 1.5;
        }
        return 0.0;
    }

    public static int getSpecMultiHit(Client client, int hit) {
        Item[] playerEquipment = EquipmentItems.getCurrentlyEquipped(client);
        String weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        if (weaponName.contains("Dragon dagger")) {
            return hit * 2;
        }
        if (weaponName.contains("Dragon claws")) {
            int first = hit - 1;
            int second = hit - hit / 2 - 1;
            int third = hit - hit * 3 / 4 - 1;
            int fourth = third + 1;
            return first + second + third + fourth;
        }
        if (weaponName.contains("Abyssal dagger")) {
            return hit * 2;
        }
        if (weaponName.contains("Saradomin sword")) {
            return hit + 16;
        }
        if (weaponName.contains("Magic shortbow")) {
            return hit * 2;
        }
        if (weaponName.contains("Dragon knife")) {
            return hit * 2;
        }
        if (weaponName.contains("Webweaver bow")) {
            return hit * 4;
        }
        return 0;
    }

    public static double calculate(Client client, ItemManager itemManager, MaxHitCalcConfig config) {
        Item[] playerEquipment = EquipmentItems.getCurrentlyEquipped(client);
        boolean doubleHitSetting = config.displayMultiHitWeaponsAsOneHit();
        double specialAttackWeapon = MaxSpec.getSpecWeaponStat(client, playerEquipment);
        double maxHit = MaxHit.calculate(client, itemManager, config);
        if (specialAttackWeapon != 0.0) {
            double maxSpecHit = Math.floor(maxHit) * specialAttackWeapon;
            return maxSpecHit;
        }
        if (doubleHitSetting && MaxSpec.getSpecMultiHit(client, (int)Math.floor(maxHit)) != 0) {
            return maxHit;
        }
        return 0.0;
    }
}

