/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import com.google.inject.Provides;
import com.maxhitcalc.MaxAgainstType;
import com.maxhitcalc.MaxHit;
import com.maxhitcalc.MaxHitCalcConfig;
import com.maxhitcalc.MaxHitCalcOverlay;
import com.maxhitcalc.MaxSpec;
import com.maxhitcalc.MaxSpecAgainstType;
import com.maxhitcalc.RelicMaxHit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Skill;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Max Hit Calculator", description="Calculates Max Hit stats for the current equipment setup.", tags={"max hit, combat, stats, helpful, melee, ranged, magic"})
public class MaxHitCalcPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MaxHitCalcPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MaxHitCalcOverlay pluginOverlay;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MaxHitCalcConfig config;
    @Inject
    private ItemManager itemManager;
    public int maxHit = 0;
    public int maxSpec = 0;
    public int maxVsType = 0;
    public int maxSpecVsType = 0;
    public int relicMaxHit = 0;
    private boolean gameReady;

    @Provides
    MaxHitCalcConfig provideConfig(ConfigManager configManager) {
        return (MaxHitCalcConfig)configManager.getConfig(MaxHitCalcConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.pluginOverlay);
        this.gameReady = this.client.getGameState().equals((Object)GameState.LOGGED_IN);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.pluginOverlay);
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widget) {
        if (widget.getGroupId() == 378) {
            this.gameReady = true;
            this.calculateMaxes();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.gameReady = false;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.calculateMaxes();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (!this.gameReady) {
            return;
        }
        if (event.getVarpId() == 83 || event.getVarpId() == 3780) {
            this.calculateMaxes();
        }
        if (event.getVarpId() == 43) {
            this.calculateMaxes();
        }
        if (event.getVarbitId() == 276) {
            this.calculateMaxes();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if (event.getSkill() == Skill.STRENGTH) {
            this.calculateMaxes();
        }
        if (event.getSkill() == Skill.RANGED) {
            this.calculateMaxes();
        }
        if (event.getSkill() == Skill.MAGIC) {
            this.calculateMaxes();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().contains("MaxHitCalc") && this.gameReady) {
            this.clientThread.invoke(this::calculateMaxes);
        }
    }

    public void calculateMaxes() {
        int multiHitSpec;
        this.maxHit = (int)Math.floor(MaxHit.calculate(this.client, this.itemManager, this.config));
        this.maxSpec = (int)Math.floor(MaxSpec.calculate(this.client, this.itemManager, this.config));
        if (this.config.displayMultiHitWeaponsAsOneHit() && (multiHitSpec = MaxSpec.getSpecMultiHit(this.client, this.maxSpec)) != 0) {
            this.maxSpec = multiHitSpec;
        }
        this.maxVsType = (int)Math.floor(MaxAgainstType.calculate(this.client, this.itemManager, this.config));
        this.maxSpecVsType = (int)Math.floor(MaxSpecAgainstType.calculate(this.client, this.itemManager, this.config));
        if (this.config.displayMultiHitWeaponsAsOneHit() && (multiHitSpec = MaxSpec.getSpecMultiHit(this.client, this.maxSpecVsType)) != 0) {
            this.maxSpecVsType = multiHitSpec;
        }
        this.relicMaxHit = (int)Math.floor(RelicMaxHit.calculate(this.client, this.itemManager, this.config, this.maxHit));
    }
}

