/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import com.maxhitcalc.CombatSpell;
import com.maxhitcalc.InventoryItemMaxHit;
import com.maxhitcalc.MaxHitCalcConfig;
import com.maxhitcalc.MaxHitCalcPlugin;
import com.maxhitcalc.PredictNextMax;
import com.maxhitcalc.SpellbookSpellMaxHit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.http.api.item.ItemStats;

public class MaxHitCalcOverlay
extends OverlayPanel {
    private final MaxHitCalcPlugin plugin;
    private final MaxHitCalcConfig config;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;

    @Inject
    MaxHitCalcOverlay(MaxHitCalcPlugin plugin, MaxHitCalcConfig config) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        String tooltipString;
        this.panelComponent.getChildren().clear();
        if (this.plugin.maxHit > 0 && this.config.showMaxHit()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max Hit:").right(Integer.toString(this.plugin.maxHit)).build());
        }
        if (this.plugin.relicMaxHit > 0 && this.plugin.relicMaxHit > this.plugin.maxHit && this.config.showLeaguesMaxHit()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Relic Max Hit:").right(Integer.toString(this.plugin.relicMaxHit)).build());
        }
        if (this.plugin.maxSpec > 0 && this.config.showSpec()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max Spec Hit:").right(Integer.toString(this.plugin.maxSpec)).build());
        }
        if (this.plugin.maxVsType > 0 && this.config.showType()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max Hit vs Type:").right(Integer.toString(this.plugin.maxVsType)).build());
        }
        if (this.plugin.maxSpecVsType > 0 && this.config.showSpecVsType()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max Spec vs Type:").right(Integer.toString(this.plugin.maxSpecVsType)).build());
        }
        if (this.config.showPredictionTooltip() && this.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY()) && (tooltipString = this.predictedMaxHitTooltip()) != null) {
            this.tooltipManager.add(new Tooltip(tooltipString));
        }
        if (this.config.showInventoryTooltip()) {
            this.getInventoryMaxHitTooltip(this.plugin.maxHit);
        }
        if (this.config.showSpellbookTooltip()) {
            this.getSpellbookMaxHitTooltip();
        }
        if (this.config.showAutocastSelectionTooltip()) {
            this.getAutocastSelectionMaxHitTooltip();
        }
        return super.render(graphics);
    }

    private String predictedMaxHitTooltip() {
        List<Object> prediction = PredictNextMax.predict(this.client, this.itemManager, this.config);
        Object result = "Next Max Hit at: </br>";
        if (prediction.get(0).equals("melee")) {
            result = (String)result + prediction.get(1) + " Strength Levels </br>" + prediction.get(2) + " Strength Bonus </br>" + (int)((Double)prediction.get(3) * 100.0) + "% Prayer Bonus";
            return result;
        }
        if (prediction.get(0).equals("ranged")) {
            result = (String)result + prediction.get(1) + " Ranged Levels </br>" + prediction.get(2) + " Ranged Strength Bonus </br>" + (int)((Double)prediction.get(3) * 100.0) + "% Prayer Bonus";
            return result;
        }
        if (prediction.get(0).equals("magic")) {
            if (!prediction.get(1).equals(0)) {
                result = (String)result + prediction.get(1) + " Magic Levels </br>";
            }
            result = (String)result + (int)((Double)prediction.get(2) * 100.0) + "% Magic Damage Bonus";
            return result;
        }
        return null;
    }

    private void getInventoryMaxHitTooltip(int maxHit) {
        int slotID;
        int maxWithItem;
        ItemStats stats;
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize == 0) {
            return;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        if (widget == null) {
            return;
        }
        int itemID = -1;
        if (WidgetUtil.componentToInterface((int)widget.getId()) == 149) {
            itemID = widget.getItemId();
        }
        if (itemID != -1 && (stats = this.itemManager.getItemStats(itemID, false)) != null && stats.getEquipment() != null && (maxWithItem = (int)InventoryItemMaxHit.predict(this.client, this.itemManager, this.config, itemID, slotID = stats.getEquipment().getSlot())) != -1) {
            int deltaMax = maxWithItem - maxHit;
            Object tooltip = "";
            if (deltaMax < 0) {
                tooltip = "Max hit: " + ColorUtil.wrapWithColorTag((String)("-" + Math.abs(deltaMax)), (Color)Color.RED);
            } else if (deltaMax > 0) {
                tooltip = "Max hit: " + ColorUtil.wrapWithColorTag((String)("+" + deltaMax), (Color)Color.GREEN);
            } else {
                return;
            }
            this.tooltipManager.add(new Tooltip((String)tooltip));
        }
    }

    private void getSpellbookMaxHitTooltip() {
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize == 0) {
            return;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        if (widget == null) {
            return;
        }
        int group = WidgetUtil.componentToInterface((int)widget.getId());
        int spellSpriteID = -1;
        if (group == 218) {
            spellSpriteID = widget.getSpriteId();
        }
        if (spellSpriteID != -1) {
            Item[] playerEquipment;
            int spellbookMaxHit;
            CombatSpell spell = CombatSpell.getSpellBySpriteID(spellSpriteID);
            if (spell == null && this.config.showTooltipOnDisabledSpells()) {
                spell = CombatSpell.getSpellByDisabledSpriteID(spellSpriteID);
            }
            if (spell != null && (spellbookMaxHit = (int)SpellbookSpellMaxHit.calculateMagicMaxHit(this.client, this.itemManager, playerEquipment = this.client.getItemContainer(InventoryID.EQUIPMENT) != null ? this.client.getItemContainer(InventoryID.EQUIPMENT).getItems() : null, spell)) > 0) {
                String tooltip = "Max hit: " + spellbookMaxHit;
                this.tooltipManager.add(new Tooltip(tooltip));
            }
        }
    }

    private void getAutocastSelectionMaxHitTooltip() {
        MenuEntry[] menu = this.client.getMenuEntries();
        int menuSize = menu.length;
        if (menuSize == 0) {
            return;
        }
        MenuEntry entry = menu[menuSize - 1];
        Widget widget = entry.getWidget();
        if (widget == null) {
            return;
        }
        int group = WidgetUtil.componentToInterface((int)widget.getId());
        int spellSpriteID = -1;
        if (group == 201) {
            spellSpriteID = widget.getSpriteId();
        }
        if (spellSpriteID != -1) {
            Item[] playerEquipment;
            int spellbookMaxHit;
            CombatSpell spell = CombatSpell.getSpellBySpriteID(spellSpriteID);
            if (spell == null && this.config.showTooltipOnDisabledSpells()) {
                spell = CombatSpell.getSpellByDisabledSpriteID(spellSpriteID);
            }
            if (spell != null && (spellbookMaxHit = (int)SpellbookSpellMaxHit.calculateMagicMaxHit(this.client, this.itemManager, playerEquipment = this.client.getItemContainer(InventoryID.EQUIPMENT) != null ? this.client.getItemContainer(InventoryID.EQUIPMENT).getItems() : null, spell)) > 0) {
                String tooltip = "Max hit: " + spellbookMaxHit;
                this.tooltipManager.add(new Tooltip(tooltip));
            }
        }
    }
}

