/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="MaxHitCalc")
public interface MaxHitCalcConfig
extends Config {
    @ConfigSection(name="Main Panel", description="Settings relating to the Main Panel", position=2, closedByDefault=false)
    public static final String mainPanelSettings = "Main Panel";
    @ConfigSection(name="Special Attack Settings", description="Settings for Special Attacks and Weapons", position=3, closedByDefault=false)
    public static final String specSettings = "Special Attack Settings";
    @ConfigSection(name="Inventory Settings", description="Settings relating to tooltips on Inventory Items", position=4, closedByDefault=false)
    public static final String inventorySettings = "Inventory Settings";
    @ConfigSection(name="Spell Settings", description="Settings relating to tooltips on Spells", position=5, closedByDefault=false)
    public static final String spellSettings = "Spell Settings";

    @ConfigItem(keyName="showLeaguesMaxHit", name="Show Max hit with Relics", description="Show Max hit with Leagues 4 Relics", position=0)
    default public boolean showLeaguesMaxHit() {
        return true;
    }

    @ConfigItem(keyName="blowpipeDartType", name="Blowpipe Dart Type", description="Sets the Dart type for calculation", position=0)
    default public BlowpipeDartType blowpipeDartType() {
        return BlowpipeDartType.MITHRIL;
    }

    @ConfigItem(keyName="colossalBladeMonsterSize", name="Colossal Blade Monster Size", description="Set the Monster Size for Colossal Blade Type Bonus", position=1)
    default public ColossalBladeSizeBonus colossalBladeMonsterSize() {
        return ColossalBladeSizeBonus.ONE;
    }

    @ConfigItem(keyName="showMaxHit", name="Display Max Hit", description="Shows your Max Hit with equipped item.", position=0, section="Main Panel")
    default public boolean showMaxHit() {
        return true;
    }

    @ConfigItem(keyName="showSpec", name="Display Max Spec", description="Shows your Max Spec with equipped items.", position=1, section="Main Panel")
    default public boolean showSpec() {
        return true;
    }

    @ConfigItem(keyName="showType", name="Display Max Hit vs Type", description="Shows your Max Hit vs current Type bonus.", position=2, section="Main Panel")
    default public boolean showType() {
        return true;
    }

    @ConfigItem(keyName="showSpecVsType", name="Display Max Spec vs Type", description="Shows your Max Spec vs current Type bonus.", position=3, section="Main Panel")
    default public boolean showSpecVsType() {
        return true;
    }

    @ConfigItem(keyName="showPredictionTooltip", name="Tooltip for Predicted Next Max Hit", description="Hover over the panel for a prediction of requirements for next max hit.", position=4, section="Main Panel")
    default public boolean showPredictionTooltip() {
        return true;
    }

    @ConfigItem(keyName="displayDoubleHitWeaponsAsOneHit", name="Combine Multi Hit Specs as One Hit", description="Weapons like the DDS will display as one hit calculation.", position=0, section="Special Attack Settings")
    default public boolean displayMultiHitWeaponsAsOneHit() {
        return true;
    }

    @ConfigItem(keyName="showInventoryTooltip", name="Tooltip on Inventory Item", description="Hover over an item in your inventory to see it's max hit impact when equipped.", position=0, section="Inventory Settings")
    default public boolean showInventoryTooltip() {
        return true;
    }

    @ConfigItem(keyName="showSpellbookTooltip", name="Tooltip on Spells in Spellbook", description="Hover over a spell in the spellbook to see its current max hit.", position=0, section="Spell Settings")
    default public boolean showSpellbookTooltip() {
        return true;
    }

    @ConfigItem(keyName="showAutocastSelectionTooltip", name="Tooltip on Spells in Autocast Selection", description="Hover over a spell in the autocast selection to see its current max hit.", position=1, section="Spell Settings")
    default public boolean showAutocastSelectionTooltip() {
        return true;
    }

    @ConfigItem(keyName="showTooltipOnDisabledSpells", name="Tooltip on Disabled Spells", description="Show max hit on spells you don't have the runes to use.", position=2, section="Spell Settings")
    default public boolean showTooltipOnDisabledSpells() {
        return true;
    }

    public static enum ColossalBladeSizeBonus {
        ONE(1){

            public String toString() {
                return "1x1";
            }
        }
        ,
        TWO(2){

            public String toString() {
                return "2x2";
            }
        }
        ,
        THREE(3){

            public String toString() {
                return "3x3";
            }
        }
        ,
        FOUR(4){

            public String toString() {
                return "4x4";
            }
        }
        ,
        FIVE(5){

            public String toString() {
                return "5x5 +";
            }
        };

        public final int monsterSize;

        private ColossalBladeSizeBonus(int monsterSize) {
            this.monsterSize = monsterSize;
        }
    }

    public static enum BlowpipeDartType {
        MITHRIL,
        ADAMANT,
        RUNE,
        AMETHYST,
        DRAGON;

    }
}

