/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import com.maxhitcalc.AttackStyle;
import com.maxhitcalc.CombatSpell;
import com.maxhitcalc.EquipmentItems;
import com.maxhitcalc.MaxHitCalcConfig;
import com.maxhitcalc.WeaponType;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.Prayer;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;

public class MaxHit {
    protected static double getPrayerBonus(Client client, AttackStyle weaponAttackStyle) {
        if (weaponAttackStyle == AttackStyle.ACCURATE || weaponAttackStyle == AttackStyle.AGGRESSIVE || weaponAttackStyle == AttackStyle.CONTROLLED || weaponAttackStyle == AttackStyle.DEFENSIVE) {
            if (client.isPrayerActive(Prayer.BURST_OF_STRENGTH)) {
                return 1.05;
            }
            if (client.isPrayerActive(Prayer.SUPERHUMAN_STRENGTH)) {
                return 1.1;
            }
            if (client.isPrayerActive(Prayer.ULTIMATE_STRENGTH)) {
                return 1.15;
            }
            if (client.isPrayerActive(Prayer.CHIVALRY)) {
                return 1.18;
            }
            if (client.isPrayerActive(Prayer.PIETY)) {
                return 1.23;
            }
            if (client.getVarbitValue(14829) == 1) {
                return 1.2;
            }
            if (client.getVarbitValue(14832) == 1) {
                return 1.15;
            }
            if (client.getVarbitValue(14833) == 1) {
                return 1.27;
            }
        }
        if (weaponAttackStyle == AttackStyle.RANGING || weaponAttackStyle == AttackStyle.LONGRANGE) {
            if (client.isPrayerActive(Prayer.SHARP_EYE)) {
                return 1.05;
            }
            if (client.isPrayerActive(Prayer.HAWK_EYE)) {
                return 1.1;
            }
            if (client.isPrayerActive(Prayer.EAGLE_EYE)) {
                return 1.15;
            }
            if (client.isPrayerActive(Prayer.RIGOUR)) {
                return 1.23;
            }
            if (client.getVarbitValue(14830) == 1) {
                return 1.2;
            }
            if (client.getVarbitValue(14832) == 1) {
                return 1.15;
            }
            if (client.getVarbitValue(14834) == 1) {
                return 1.27;
            }
        }
        if ((weaponAttackStyle == AttackStyle.CASTING || weaponAttackStyle == AttackStyle.DEFENSIVE_CASTING) && client.getVarbitValue(14835) == 1) {
            return 1.04;
        }
        return 1.0;
    }

    protected static int getAttackStyleBonus(AttackStyle weaponAttackStyle, int attackStyleID) {
        if (weaponAttackStyle.getName().equalsIgnoreCase("Aggressive")) {
            return 3;
        }
        if (weaponAttackStyle.getName().equalsIgnoreCase("Controlled")) {
            return 1;
        }
        if (weaponAttackStyle.getName().equalsIgnoreCase("RANGING") && attackStyleID == 0) {
            return 3;
        }
        return 0;
    }

    protected static double getMeleeStrengthBonus(Client client, ItemManager itemManager, Item[] playerEquipment) {
        if (playerEquipment == null) {
            return 0.0;
        }
        double strengthBonus = 0.0;
        for (Item equipmentItem : playerEquipment) {
            int equipmentID;
            if (equipmentItem == null || equipmentItem.getId() == -1 || itemManager.getItemStats(equipmentID = equipmentItem.getId(), false) == null) continue;
            int equipmentStrengthStat = itemManager.getItemStats(equipmentID, false).getEquipment().getStr();
            strengthBonus += (double)equipmentStrengthStat;
        }
        return strengthBonus;
    }

    protected static double getVoidMeleeBonus(Client client, Item[] playerEquipment) {
        if (playerEquipment == null) {
            return 1.0;
        }
        String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
        String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
        String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
        String glovesItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.GLOVES);
        if (headItemName.contains("Void melee") && glovesItemName.contains("Void") && (bodyItemName.contains("Void") ? legsItemName.contains("Void") : bodyItemName.contains("Elite void") && legsItemName.contains("Elite void"))) {
            return 1.1;
        }
        return 1.0;
    }

    protected static List<Double> getMeleeSpecialBonusMultiplier(Client client, Item[] playerEquipment) {
        ArrayList<Double> specialBonusesToApply = new ArrayList<Double>();
        if (playerEquipment == null) {
            return specialBonusesToApply;
        }
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
        String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
        String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
        String ammuletItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.AMULET);
        if (headItemName.contains("Dharok's") && bodyItemName.contains("Dharok's") && legsItemName.contains("Dharok's") && weaponItemName.contains("Dharok's")) {
            double baseHP = client.getRealSkillLevel(Skill.HITPOINTS);
            double currentHP = client.getBoostedSkillLevel(Skill.HITPOINTS);
            double dharokBonus = (baseHP - currentHP) / 100.0 * (baseHP / 100.0);
            specialBonusesToApply.add(dharokBonus);
        }
        if (headItemName.contains("Obsidian") && bodyItemName.contains("Obsidian") && legsItemName.contains("Obsidian") && (weaponItemName.contains("ket") || weaponItemName.contains("xil"))) {
            specialBonusesToApply.add(0.1);
        }
        if ((weaponItemName.contains("ket") || weaponItemName.contains("xil")) && ammuletItemName.contains("Berserker")) {
            specialBonusesToApply.add(0.2);
        }
        return specialBonusesToApply;
    }

    protected static double calculateMeleeMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle, int attackStyleID) {
        String weaponName;
        int strengthLevel = client.getBoostedSkillLevel(Skill.STRENGTH);
        double prayerBonus = MaxHit.getPrayerBonus(client, weaponAttackStyle);
        int styleBonus = MaxHit.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
        double voidBonus = MaxHit.getVoidMeleeBonus(client, playerEquipment);
        double effectiveStrength = Math.floor((Math.floor((double)strengthLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
        double strengthBonus = MaxHit.getMeleeStrengthBonus(client, itemManager, playerEquipment);
        double baseDamage = 0.5 + effectiveStrength * ((strengthBonus + 64.0) / 640.0);
        double flooredBaseDamage = Math.floor(baseDamage);
        List<Double> specialBonusMultipliers = MaxHit.getMeleeSpecialBonusMultiplier(client, playerEquipment);
        double maxHit = flooredBaseDamage;
        if (!specialBonusMultipliers.isEmpty()) {
            for (double bonus : specialBonusMultipliers) {
                maxHit += Math.floor(maxHit * bonus);
            }
        }
        if ((weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON)).contains("Osmumten's fang")) {
            maxHit = maxHit * 0.85 + 1.0;
        }
        if (weaponName.contains("Colossal blade")) {
            maxHit += 2.0;
        }
        return maxHit;
    }

    protected static double getVoidRangedBonus(Client client, Item[] playerEquipment) {
        String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
        String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
        String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
        String glovesItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.GLOVES);
        if (headItemName.contains("Void ranger") && glovesItemName.contains("Void")) {
            if (bodyItemName.contains("Void")) {
                if (legsItemName.contains("Void")) {
                    return 1.1;
                }
            } else if (bodyItemName.contains("Elite void") && legsItemName.contains("Elite void")) {
                return 1.125;
            }
        }
        return 1.0;
    }

    protected static double getRangedStrengthBonus(Client client, ItemManager itemManager, Item[] playerEquipment, MaxHitCalcConfig.BlowpipeDartType dartType) {
        double rangedStrengthBonus = 0.0;
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        int weaponID = EquipmentItems.getItemIdInGivenSetSlot(playerEquipment, EquipmentInventorySlot.WEAPON);
        String ammoItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.AMMO);
        int ammoID = EquipmentItems.getItemIdInGivenSetSlot(playerEquipment, EquipmentInventorySlot.AMMO);
        boolean skipAmmo = false;
        if (weaponItemName.contains("dart") || weaponItemName.contains("knife") || weaponItemName.contains("thrownaxe") || weaponItemName.contains("Toktz-xil-ul")) {
            skipAmmo = true;
        } else if (weaponItemName.contains("Morrigan's javelin") || weaponItemName.contains("Morrigan's throwing axe") || weaponItemName.contains("Mud pie")) {
            skipAmmo = true;
        } else if (weaponItemName.contains("Crystal bow") || weaponItemName.contains("faerdhinen")) {
            skipAmmo = true;
        } else if (weaponItemName.contains("blowpipe")) {
            skipAmmo = true;
            rangedStrengthBonus = dartType == MaxHitCalcConfig.BlowpipeDartType.ADAMANT ? (rangedStrengthBonus += 17.0) : (dartType == MaxHitCalcConfig.BlowpipeDartType.RUNE ? (rangedStrengthBonus += 26.0) : (dartType == MaxHitCalcConfig.BlowpipeDartType.AMETHYST ? (rangedStrengthBonus += 28.0) : (dartType == MaxHitCalcConfig.BlowpipeDartType.DRAGON ? (rangedStrengthBonus += 35.0) : (rangedStrengthBonus += 9.0))));
        }
        for (Item equipmentItem : playerEquipment) {
            int equipmentID;
            if (equipmentItem == null || equipmentItem.getId() == -1 || itemManager.getItemStats(equipmentID = equipmentItem.getId(), false) == null) continue;
            int equipmentStrengthStat = itemManager.getItemStats(equipmentID, false).getEquipment().getRstr();
            if (equipmentID == ammoID && skipAmmo) continue;
            rangedStrengthBonus += (double)equipmentStrengthStat;
        }
        return rangedStrengthBonus;
    }

    protected static double getRangeGearBoost(Client client, Item[] playerEquipment) {
        double damagePercentBonus = 1.0;
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
        String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
        String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
        if (weaponItemName.contains("Crystal bow") || weaponItemName.contains("faerdhinen")) {
            if (!(!headItemName.contains("Crystal helm") || headItemName.contains("(basic)") && headItemName.contains("(attuned)") && headItemName.contains("(perfected)"))) {
                damagePercentBonus += 0.025;
            }
            if (!(!bodyItemName.contains("Crystal body") || bodyItemName.contains("(basic)") && bodyItemName.contains("(attuned)") && bodyItemName.contains("(perfected)"))) {
                damagePercentBonus += 0.075;
            }
            if (!(!legsItemName.contains("Crystal legs") || legsItemName.contains("(basic)") && legsItemName.contains("(attuned)") && legsItemName.contains("(perfected)"))) {
                damagePercentBonus += 0.05;
            }
        }
        return damagePercentBonus;
    }

    protected static double calculateRangedMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle, int attackStyleID, MaxHitCalcConfig.BlowpipeDartType dartType) {
        int rangedLevel = client.getBoostedSkillLevel(Skill.RANGED);
        double prayerBonus = MaxHit.getPrayerBonus(client, weaponAttackStyle);
        int styleBonus = MaxHit.getAttackStyleBonus(weaponAttackStyle, attackStyleID);
        double voidBonus = MaxHit.getVoidRangedBonus(client, playerEquipment);
        double effectiveRangedStrength = Math.floor((Math.floor((double)rangedLevel * prayerBonus) + (double)styleBonus + 8.0) * voidBonus);
        double equipmentRangedStrength = MaxHit.getRangedStrengthBonus(client, itemManager, playerEquipment, dartType);
        double gearBonus = MaxHit.getRangeGearBoost(client, playerEquipment);
        double maxHit = 0.5 + effectiveRangedStrength * (equipmentRangedStrength + 64.0) / 640.0 * gearBonus;
        return maxHit;
    }

    protected static double getSpellBaseHit(Client client, Item[] playerEquipment, AttackStyle weaponAttackStyle, double magicLevel) {
        int spellSpriteID = -1;
        double basehit = 0.0;
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        String capeItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.CAPE);
        String glovesItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.GLOVES);
        if (weaponItemName.contains("of the seas")) {
            basehit = Math.max(Math.floor((Math.min(magicLevel, 125.0) - 15.0) / 3.0), 1.0);
        } else if (weaponItemName.contains("of the swamp")) {
            basehit = Math.max(Math.floor((Math.min(magicLevel, 125.0) - 6.0) / 3.0), 3.0);
        } else if (weaponItemName.contains("Sanguinesti")) {
            basehit = Math.max(Math.floor((Math.min(magicLevel, 125.0) - 3.0) / 3.0), 4.0);
        } else if (weaponItemName.contains("Thammaron's")) {
            basehit = Math.floor(magicLevel / 3.0) - 8.0;
        } else if (weaponItemName.contains("Accursed")) {
            basehit = Math.floor(magicLevel / 3.0) - 6.0;
        } else if (weaponItemName.contains("Tumeken")) {
            basehit = Math.floor(magicLevel / 3.0) + 1.0;
        } else if (weaponItemName.contains("Warped sceptre")) {
            basehit = Math.floor((8.0 * magicLevel + 96.0) / 37.0);
        } else if (weaponItemName.contains("Crystal staff (basic)")) {
            basehit = 23.0;
        } else if (weaponItemName.contains("Crystal staff (attuned)")) {
            basehit = 31.0;
        } else if (weaponItemName.contains("Crystal staff (perfected)")) {
            basehit = 39.0;
        } else if (weaponItemName.contains("Corrupted staff (basic)")) {
            basehit = 23.0;
        } else if (weaponItemName.contains("Corrupted staff (attuned)")) {
            basehit = 31.0;
        } else if (weaponItemName.contains("Corrupted staff (perfected)")) {
            basehit = 39.0;
        } else {
            double magicDartDamage;
            int selectedSpellId = client.getVarbitValue(276);
            if (selectedSpellId == 0) {
                return -1.0;
            }
            CombatSpell selectedSpell = CombatSpell.getSpellbyVarbitValue(selectedSpellId);
            if (selectedSpell == null) {
                System.out.println("Error");
                return -1.0;
            }
            basehit = selectedSpell == CombatSpell.MAGIC_DART ? (magicDartDamage = Math.floor(magicLevel * 0.1) + 10.0) : (double)selectedSpell.getBaseDamage();
            if (selectedSpell == CombatSpell.FLAMES_OF_ZAMORAK || selectedSpell == CombatSpell.CLAWS_OF_GUTHIX || selectedSpell == CombatSpell.SARADOMIN_STRIKE) {
                basehit = client.getVarpValue(272) > 0 ? (selectedSpell == CombatSpell.CLAWS_OF_GUTHIX && (capeItemName.toLowerCase().contains("guthix cape") || capeItemName.toLowerCase().contains("guthix max cape")) ? 30.0 : (selectedSpell == CombatSpell.FLAMES_OF_ZAMORAK && (capeItemName.toLowerCase().contains("zamorak cape") || capeItemName.toLowerCase().contains("zamorak max cape")) ? 30.0 : (selectedSpell == CombatSpell.SARADOMIN_STRIKE && (capeItemName.toLowerCase().contains("saradomin cape") || capeItemName.toLowerCase().contains("saradomin max cape")) ? 30.0 : 20.0))) : 20.0;
            }
            if (selectedSpell.getName().toLowerCase().contains("bolt") && glovesItemName.toLowerCase().contains("chaos gauntlets")) {
                basehit += 3.0;
            }
        }
        return basehit;
    }

    protected static CombatSpell getSpell(Client client) {
        int selectedSpellId = client.getVarbitValue(276);
        if (selectedSpellId == 0) {
            return null;
        }
        CombatSpell selectedSpell = CombatSpell.getSpellbyVarbitValue(selectedSpellId);
        return selectedSpell;
    }

    protected static double getMagicEquipmentBoost(Client client, ItemManager itemManager, Item[] playerEquipment) {
        CombatSpell selectedSpell;
        if (playerEquipment == null) {
            return 1.0;
        }
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        double magicdamagebonus = 0.0;
        for (Item equipmentItem : playerEquipment) {
            if (equipmentItem == null || equipmentItem.getId() == -1) continue;
            int equipmentID = equipmentItem.getId();
            double equipmentMagicBonusStat = 0.0;
            if (itemManager.getItemStats(equipmentID, false) == null) continue;
            equipmentMagicBonusStat = itemManager.getItemStats(equipmentID, false).getEquipment().getMdmg();
            magicdamagebonus += equipmentMagicBonusStat / 100.0;
        }
        magicdamagebonus += MaxHit.getVoidMagicBonus(client, playerEquipment);
        if (weaponItemName.contains("Tumeken")) {
            magicdamagebonus *= 3.0;
            magicdamagebonus = Math.min(magicdamagebonus, 1.0);
        }
        if ((selectedSpell = CombatSpell.getSpellbyVarbitValue(client.getVarbitValue(276))) != null && (selectedSpell.getName().toLowerCase().contains("smoke") || selectedSpell.getName().toLowerCase().contains("shadow") || selectedSpell.getName().toLowerCase().contains("blood") || selectedSpell.getName().toLowerCase().contains("ice"))) {
            String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
            String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
            String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
            if (headItemName.toLowerCase().contains("virtus")) {
                magicdamagebonus += 0.03;
            }
            if (bodyItemName.toLowerCase().contains("virtus")) {
                magicdamagebonus += 0.03;
            }
            if (legsItemName.toLowerCase().contains("virtus")) {
                magicdamagebonus += 0.03;
            }
        }
        return 1.0 + magicdamagebonus;
    }

    protected static double getVoidMagicBonus(Client client, Item[] playerEquipment) {
        if (playerEquipment == null) {
            return 0.0;
        }
        String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
        String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
        String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
        String glovesItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.GLOVES);
        if (headItemName.contains("Void mage") && glovesItemName.contains("Void") && bodyItemName.contains("Elite void") && legsItemName.contains("Elite void")) {
            return 0.025;
        }
        return 0.0;
    }

    protected static double getTomeSpellBonus(Client client, Item[] playerEquipment, AttackStyle weaponAttackStyle) {
        String shieldItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.SHIELD);
        int selectedSpellId = client.getVarbitValue(276);
        if (selectedSpellId == 0) {
            return 1.0;
        }
        CombatSpell selectedSpell = CombatSpell.getSpellbyVarbitValue(selectedSpellId);
        if (selectedSpell == null) {
            return 1.0;
        }
        if (selectedSpell.getName().toLowerCase().contains("fire") && shieldItemName.contains("Tome of fire") && !shieldItemName.contains("(empty)")) {
            return 1.5;
        }
        if (selectedSpell.getName().toLowerCase().contains("water") && shieldItemName.contains("Tome of water") && !shieldItemName.contains("(empty)")) {
            return 1.2;
        }
        return 1.0;
    }

    protected static double calculateMagicMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle) {
        CombatSpell spell;
        double spellBaseMaxHit = MaxHit.getSpellBaseHit(client, playerEquipment, weaponAttackStyle, client.getBoostedSkillLevel(Skill.MAGIC));
        if (spellBaseMaxHit == 0.0) {
            return -1.0;
        }
        double magicDmgBonus = MaxHit.getMagicEquipmentBoost(client, itemManager, playerEquipment);
        double maxDamage = spellBaseMaxHit * magicDmgBonus;
        double correctTomeSpellBonus = MaxHit.getTomeSpellBonus(client, playerEquipment, weaponAttackStyle);
        maxDamage *= correctTomeSpellBonus;
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        if ((weaponItemName.toLowerCase().contains("smoke battlestaff") || weaponItemName.toLowerCase().contains("smoke staff")) && (spell = MaxHit.getSpell(client)) != null && spell.getSpellbook().contains("standard")) {
            double SmokeStandardSpellsBonus = maxDamage * (double)0.1f;
            maxDamage += SmokeStandardSpellsBonus;
        }
        return maxDamage;
    }

    public static double calculate(Client client, ItemManager itemManager, MaxHitCalcConfig config) {
        int attackStyleID = client.getVarpValue(43);
        int weaponTypeID = client.getVarbitValue(357);
        WeaponType weaponType = WeaponType.getWeaponType(weaponTypeID);
        AttackStyle[] weaponAttackStyles = weaponType.getAttackStyles();
        AttackStyle attackStyle = weaponAttackStyles[attackStyleID];
        Item[] playerEquipment = EquipmentItems.getCurrentlyEquipped(client);
        if (attackStyle.equals((Object)AttackStyle.ACCURATE) || attackStyle.equals((Object)AttackStyle.AGGRESSIVE) || attackStyle.equals((Object)AttackStyle.CONTROLLED) || attackStyle.equals((Object)AttackStyle.DEFENSIVE)) {
            return MaxHit.calculateMeleeMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID);
        }
        if (attackStyle.equals((Object)AttackStyle.RANGING) || attackStyle.equals((Object)AttackStyle.LONGRANGE)) {
            return MaxHit.calculateRangedMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID, config.blowpipeDartType());
        }
        if (attackStyle.equals((Object)AttackStyle.CASTING) || attackStyle.equals((Object)AttackStyle.DEFENSIVE_CASTING)) {
            return MaxHit.calculateMagicMaxHit(client, itemManager, playerEquipment, attackStyle);
        }
        return -1.0;
    }
}

