/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitcalc;

import com.maxhitcalc.AttackStyle;
import com.maxhitcalc.CombatSpell;
import com.maxhitcalc.EquipmentItems;
import com.maxhitcalc.MaxHit;
import com.maxhitcalc.MaxHitCalcConfig;
import com.maxhitcalc.WeaponType;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;

public class MaxAgainstType
extends MaxHit {
    protected static List<Double> getTypeBonus(Client client, AttackStyle attackStyle, Item[] playerEquipment) {
        ArrayList<Double> typeBonusToApply = new ArrayList<Double>();
        String weaponItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        String amuletItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.AMULET);
        String headItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.HEAD);
        String bodyItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.BODY);
        String legsItemName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.LEGS);
        if (attackStyle == AttackStyle.AGGRESSIVE || attackStyle == AttackStyle.CONTROLLED || attackStyle == AttackStyle.ACCURATE || attackStyle == AttackStyle.DEFENSIVE) {
            if (amuletItemName.contains("Salve amulet (e)")) {
                typeBonusToApply.add(1.2);
            } else if (amuletItemName.contains("Salve amulet(ei)")) {
                typeBonusToApply.add(1.2);
            } else if (headItemName.contains("Black mask")) {
                typeBonusToApply.add(1.1667);
            } else if (headItemName.contains("Slayer helmet")) {
                typeBonusToApply.add(1.1667);
            } else if (headItemName.contains("slayer helmet")) {
                typeBonusToApply.add(1.1667);
            } else if (amuletItemName.contains("Salve amulet")) {
                typeBonusToApply.add(1.15);
            }
            if (weaponItemName.contains("Silverlight")) {
                typeBonusToApply.add(1.6);
            } else if (weaponItemName.contains("Darklight")) {
                typeBonusToApply.add(1.6);
            }
            if (weaponItemName.contains("Gadderhammer")) {
                typeBonusToApply.add(1.25);
            }
            if (weaponItemName.contains("Arclight")) {
                typeBonusToApply.add(1.7);
            }
            if (weaponItemName.contains("Leaf-bladed battleaxe")) {
                typeBonusToApply.add(1.175);
            }
            if (weaponItemName.contains("Dragon hunter")) {
                typeBonusToApply.add(1.2);
            }
            if (weaponItemName.contains("Ivandis flail")) {
                typeBonusToApply.add(1.2);
            }
            if (weaponItemName.contains("Viggora's") && !weaponItemName.contains("(u)")) {
                typeBonusToApply.add(1.5);
            }
            if (weaponItemName.contains("Ursine chainmace") && !weaponItemName.contains("(u)")) {
                typeBonusToApply.add(1.5);
            }
            int inquisitorPieces = 0;
            if (headItemName.contains("Inquisitor's")) {
                ++inquisitorPieces;
                typeBonusToApply.add(1.025);
            }
            if (bodyItemName.contains("Inquisitor's")) {
                ++inquisitorPieces;
            }
            if (legsItemName.contains("Inquisitor's")) {
                ++inquisitorPieces;
            }
            if (inquisitorPieces != 0) {
                double inquisitorTotal = (double)inquisitorPieces * 0.05;
                if (inquisitorPieces == 3) {
                    inquisitorTotal += 0.1;
                }
                typeBonusToApply.add(inquisitorTotal);
            }
            if (weaponItemName.contains("Blisterwood flail")) {
                typeBonusToApply.add(1.25);
            }
            if (weaponItemName.contains("Barronite mace")) {
                typeBonusToApply.add(1.15);
            }
            if (weaponItemName.contains("Keris")) {
                typeBonusToApply.add(1.33);
            }
        } else if (attackStyle == AttackStyle.RANGING || attackStyle == AttackStyle.LONGRANGE) {
            if (amuletItemName.contains("Salve amulet(ei)")) {
                typeBonusToApply.add(1.2);
            } else if (amuletItemName.contains("Salve amulet(i)")) {
                typeBonusToApply.add(1.1667);
            } else if (headItemName.contains("Black mask")) {
                if (headItemName.contains("(i)")) {
                    typeBonusToApply.add(1.15);
                }
            } else if (headItemName.contains("Slayer helmet (i)")) {
                typeBonusToApply.add(1.15);
            } else if (headItemName.contains("slayer helmet (i)")) {
                typeBonusToApply.add(1.15);
            }
            if (weaponItemName.contains("Dragon hunter")) {
                typeBonusToApply.add(1.25);
            }
            if (weaponItemName.contains("Craw's bow") && !weaponItemName.contains("(u)")) {
                typeBonusToApply.add(1.5);
            }
            if (weaponItemName.contains("Webweaver bow") && !weaponItemName.contains("(u)")) {
                typeBonusToApply.add(1.5);
            }
        } else if (attackStyle == AttackStyle.CASTING || attackStyle == AttackStyle.DEFENSIVE_CASTING) {
            if (amuletItemName.contains("Salve amulet(ei)")) {
                typeBonusToApply.add(1.2);
            } else if (amuletItemName.contains("Salve amulet(i)")) {
                typeBonusToApply.add(1.15);
            } else if (headItemName.contains("Black mask")) {
                if (headItemName.contains("(i)")) {
                    typeBonusToApply.add(1.15);
                }
            } else if (headItemName.contains("Slayer helmet (i)")) {
                typeBonusToApply.add(1.15);
            } else if (headItemName.contains("slayer helmet (i)")) {
                typeBonusToApply.add(1.15);
            }
            if (weaponItemName.contains("Thammaron's sceptre") && !weaponItemName.contains("(u)")) {
                typeBonusToApply.add(1.5);
            }
            if (weaponItemName.contains("Accursed sceptre") && !weaponItemName.contains("u)")) {
                typeBonusToApply.add(1.5);
            }
        }
        return typeBonusToApply;
    }

    protected static double getSpellBaseHit(Client client, Item[] playerEquipment, AttackStyle weaponAttackStyle, double magicLevel) {
        int spellSpriteID = -1;
        double basehit = 0.0;
        String weaponItemName = "";
        if (playerEquipment.length > EquipmentInventorySlot.WEAPON.getSlotIdx() && playerEquipment[EquipmentInventorySlot.WEAPON.getSlotIdx()] != null) {
            weaponItemName = client.getItemDefinition(playerEquipment[EquipmentInventorySlot.WEAPON.getSlotIdx()].getId()).getName();
        }
        String capeItemName = "";
        if (playerEquipment.length > EquipmentInventorySlot.CAPE.getSlotIdx() && playerEquipment[EquipmentInventorySlot.CAPE.getSlotIdx()] != null) {
            capeItemName = client.getItemDefinition(playerEquipment[EquipmentInventorySlot.CAPE.getSlotIdx()].getId()).getName();
        }
        if (weaponItemName.contains("of the seas")) {
            basehit = Math.max(Math.floor((Math.min(magicLevel, 125.0) - 15.0) / 3.0), 1.0);
        } else if (weaponItemName.contains("of the swamp")) {
            basehit = Math.max(Math.floor((Math.min(magicLevel, 125.0) - 6.0) / 3.0), 3.0);
        } else if (weaponItemName.contains("Sanguinesti")) {
            basehit = Math.max(Math.floor((Math.min(magicLevel, 125.0) - 3.0) / 3.0), 4.0);
        } else if (weaponItemName.contains("Thammaron's")) {
            basehit = Math.floor(magicLevel / 3.0) - 8.0;
        } else if (weaponItemName.contains("Accursed")) {
            basehit = Math.floor(magicLevel / 3.0) - 6.0;
        } else if (weaponItemName.contains("Tumeken")) {
            basehit = Math.floor(magicLevel / 3.0) + 1.0;
        } else if (weaponItemName.contains("Crystal staff (basic)")) {
            basehit = 23.0;
        } else if (weaponItemName.contains("Crystal staff (attuned)")) {
            basehit = 31.0;
        } else if (weaponItemName.contains("Crystal staff (perfected)")) {
            basehit = 39.0;
        } else {
            if (client.getWidget(38862876) == null) {
                return -1.0;
            }
            if (weaponAttackStyle.equals((Object)AttackStyle.CASTING)) {
                spellSpriteID = client.getWidget(38862876).getSpriteId();
            } else if (weaponAttackStyle.equals((Object)AttackStyle.DEFENSIVE_CASTING)) {
                spellSpriteID = client.getWidget(38862871).getSpriteId();
            }
            CombatSpell selectedSpell = CombatSpell.getSpellBySpriteID(spellSpriteID);
            if (selectedSpell != null) {
                if (selectedSpell == CombatSpell.MAGIC_DART) {
                    double magicDartDamage = Math.floor(magicLevel * 0.1) + 10.0;
                    if (weaponItemName.contains("Slayer's staff (e)")) {
                        magicDartDamage = Math.floor(magicLevel * 0.16666666666666666) + 13.0;
                    }
                    basehit = magicDartDamage;
                } else {
                    basehit = selectedSpell.getBaseDamage();
                }
                if (selectedSpell == CombatSpell.FLAMES_OF_ZAMORAK || selectedSpell == CombatSpell.CLAWS_OF_GUTHIX || selectedSpell == CombatSpell.SARADOMIN_STRIKE) {
                    basehit = client.getVarpValue(272) > 0 ? (selectedSpell == CombatSpell.CLAWS_OF_GUTHIX && (capeItemName.toLowerCase().contains("guthix cape") || capeItemName.toLowerCase().contains("guthix max cape")) ? 30.0 : (selectedSpell == CombatSpell.FLAMES_OF_ZAMORAK && (capeItemName.toLowerCase().contains("zamorak cape") || capeItemName.toLowerCase().contains("zamorak max cape")) ? 30.0 : (selectedSpell == CombatSpell.SARADOMIN_STRIKE && (capeItemName.toLowerCase().contains("saradomin cape") || capeItemName.toLowerCase().contains("saradomin max cape")) ? 30.0 : 20.0))) : 20.0;
                }
            }
        }
        return basehit;
    }

    protected static double calculateMagicMaxHit(Client client, ItemManager itemManager, Item[] playerEquipment, AttackStyle weaponAttackStyle) {
        double spellBaseMaxHit = MaxAgainstType.getSpellBaseHit(client, playerEquipment, weaponAttackStyle, client.getBoostedSkillLevel(Skill.MAGIC));
        double magicDmgBonus = MaxAgainstType.getMagicEquipmentBoost(client, itemManager, playerEquipment);
        double maxDamage = spellBaseMaxHit * magicDmgBonus;
        double correctTomeSpellBonus = MaxAgainstType.getTomeSpellBonus(client, playerEquipment, weaponAttackStyle);
        return maxDamage *= correctTomeSpellBonus;
    }

    private static double calculateTypeMaxHit(Client client, ItemManager itemManager, MaxHitCalcConfig config) {
        int attackStyleID = client.getVarpValue(43);
        int weaponTypeID = client.getVarbitValue(357);
        WeaponType weaponType = WeaponType.getWeaponType(weaponTypeID);
        AttackStyle[] weaponAttackStyles = weaponType.getAttackStyles();
        AttackStyle attackStyle = weaponAttackStyles[attackStyleID];
        Item[] playerEquipment = client.getItemContainer(InventoryID.EQUIPMENT) != null ? client.getItemContainer(InventoryID.EQUIPMENT).getItems() : null;
        if (attackStyle.equals((Object)AttackStyle.ACCURATE) || attackStyle.equals((Object)AttackStyle.AGGRESSIVE) || attackStyle.equals((Object)AttackStyle.CONTROLLED) || attackStyle.equals((Object)AttackStyle.DEFENSIVE)) {
            return MaxAgainstType.calculateMeleeMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID);
        }
        if (attackStyle.equals((Object)AttackStyle.RANGING) || attackStyle.equals((Object)AttackStyle.LONGRANGE)) {
            return MaxAgainstType.calculateRangedMaxHit(client, itemManager, playerEquipment, attackStyle, attackStyleID, config.blowpipeDartType());
        }
        if (attackStyle.equals((Object)AttackStyle.CASTING) || attackStyle.equals((Object)AttackStyle.DEFENSIVE_CASTING)) {
            return MaxAgainstType.calculateMagicMaxHit(client, itemManager, playerEquipment, attackStyle);
        }
        return -1.0;
    }

    public static double calculate(Client client, ItemManager itemManager, MaxHitCalcConfig config) {
        Item[] playerEquipment = EquipmentItems.getCurrentlyEquipped(client);
        int attackStyleID = client.getVarpValue(43);
        int weaponTypeID = client.getVarbitValue(357);
        WeaponType weaponType = WeaponType.getWeaponType(weaponTypeID);
        AttackStyle[] weaponAttackStyles = weaponType.getAttackStyles();
        AttackStyle attackStyle = weaponAttackStyles[attackStyleID];
        List<Double> typeModifiersList = MaxAgainstType.getTypeBonus(client, attackStyle, playerEquipment);
        double maxHit = MaxHit.calculate(client, itemManager, config);
        double maxHitVsType = Math.floor(MaxAgainstType.calculateTypeMaxHit(client, itemManager, config));
        String weaponName = EquipmentItems.getItemNameInGivenSetSlot(client, playerEquipment, EquipmentInventorySlot.WEAPON);
        if (weaponName.contains("Colossal blade")) {
            maxHitVsType -= 2.0;
        }
        if (!typeModifiersList.isEmpty()) {
            for (double modifier : typeModifiersList) {
                maxHitVsType = Math.floor(maxHitVsType * modifier);
            }
        }
        if (weaponName.contains("Colossal blade")) {
            int sizeBonus = 2 * Math.min(config.colossalBladeMonsterSize().monsterSize, 5);
            maxHitVsType += (double)sizeBonus;
        }
        if (maxHit >= maxHitVsType) {
            return 0.0;
        }
        return maxHitVsType;
    }
}

