/*
 * Decompiled with CFR 0.152.
 */
package com.durtydan;

import com.durtydan.ExampleConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pre-GE")
public class ExamplePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ExamplePlugin.class);
    @Inject
    private Client client;
    @Inject
    private ExampleConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;

    protected void startUp() throws Exception {
        log.info("Pre-GE started!");
    }

    protected void shutDown() throws Exception {
        log.info("Pre-GE stopped!");
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String target = Text.removeTags((String)event.getMenuTarget());
        if (event.getMenuEntry().getOption().equals("Create <col=ff9040>Buy</col> offer")) {
            event.consume();
            if (this.config.sellmode()) {
                this.sendChatMessage("Pre-GE sell mode prevents you from buying at the Grand Exchange.");
            } else {
                this.sendChatMessage("Pre-GE prevents you from using the Grand Exchange.");
            }
            return;
        }
        if (event.getMenuEntry().getOption().equals("Create <col=ff9040>Sell</col> offer") && !this.config.sellmode()) {
            event.consume();
            this.sendChatMessage("Pre-GE prevents you from using the Grand Exchange.");
            return;
        }
    }

    private void sendChatMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    @Provides
    ExampleConfig provideConfig(ConfigManager configManager) {
        return (ExampleConfig)configManager.getConfig(ExampleConfig.class);
    }
}

