/*
 * Decompiled with CFR 0.152.
 */
package com.boss.health.indicator.ui;

import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class PercentSpinner
extends JSpinner {
    public PercentSpinner(double initialValue, double minValue, double maxValue, double stepSize) {
        super(new SpinnerNumberModel(initialValue, minValue, maxValue, stepSize));
        final DecimalFormat percentFormat = new DecimalFormat("0.##%");
        NumberFormatter formatter = new NumberFormatter(percentFormat);
        formatter.setValueClass(Double.class);
        formatter.setMinimum(Double.valueOf(minValue));
        formatter.setMaximum(Double.valueOf(maxValue));
        formatter.setAllowsInvalid(true);
        JFormattedTextField textField = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        JFormattedTextField.AbstractFormatter f = new JFormattedTextField.AbstractFormatter(){

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    return "";
                }
                double percentValue = ((Number)value).doubleValue();
                return percentFormat.format(percentValue);
            }

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (!((String)text).endsWith("%")) {
                    text = (String)text + "%";
                }
                if (text == null || ((String)text).isEmpty()) {
                    return null;
                }
                double percentValue = percentFormat.parse((String)text).doubleValue();
                return percentValue;
            }
        };
        textField.setFormatterFactory(new DefaultFormatterFactory(f));
    }
}

