/*
 * Decompiled with CFR 0.152.
 */
package com.boss.health.indicator.ui;

import com.boss.health.indicator.BossHealthIndicatorPlugin;
import com.boss.health.indicator.SelfRunnable;
import com.boss.health.indicator.model.Indicator;
import com.boss.health.indicator.ui.BooleanPicker;
import com.boss.health.indicator.ui.ColorPicker;
import com.boss.health.indicator.ui.IconButton;
import com.boss.health.indicator.ui.Icons;
import com.boss.health.indicator.ui.PercentagePicker;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class IndicatorPicker {
    private JPanel panel;
    private Runnable onChanged;
    private PercentagePicker percentagePicker;
    private ColorPicker colorPicker;
    private BooleanPicker notificationPicker;

    public IndicatorPicker(Indicator indicator, Runnable onChanged, BossHealthIndicatorPlugin plugin, SelfRunnable<IndicatorPicker> onDelete) {
        this.onChanged = onChanged;
        this.panel = new JPanel();
        this.percentagePicker = new PercentagePicker(indicator.getPercentage(), onChanged);
        this.colorPicker = new ColorPicker(indicator.getColor(), plugin, onChanged);
        this.notificationPicker = new BooleanPicker(Icons.BELL_ENABLED, Icons.BELL_ENABLED_HOVER, Icons.BELL_DISABLED, Icons.BELL_DISABLED_HOVER, indicator.getNotify(), "Display notification when threshold reached", onChanged);
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.colorPicker.getComponent());
        this.panel.add(Box.createHorizontalStrut(10));
        this.panel.add(this.percentagePicker.getComponent());
        this.panel.add(Box.createHorizontalStrut(10));
        this.panel.add(new IconButton(Icons.REMOVE_ICON, Icons.REMOVE_ICON_HOVER, "Remove Indicator", () -> onDelete.run(this)));
        this.panel.add(this.notificationPicker);
    }

    public IndicatorPicker(Runnable onChanged, BossHealthIndicatorPlugin plugin, SelfRunnable<IndicatorPicker> onDelete) {
        this(new Indicator(0.0, Color.WHITE, false), onChanged, plugin, onDelete);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public Indicator getIndicator() {
        return new Indicator(this.percentagePicker.getPercent(), this.colorPicker.getColor(), this.notificationPicker.getValue());
    }
}

